/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PasswordCipherer;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource.RepoReportDataSource;

public class RepoJdbcDataSource
extends RepoDataSource
implements RepoReportDataSource {
    private String driverClass;
    private String connectionUrl;
    private String username;
    private String password;
    private String timezone;

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String url) {
        this.connectionUrl = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    protected Class getClientItf() {
        return JdbcReportDataSource.class;
    }

    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        JdbcReportDataSource ds = (JdbcReportDataSource)clientRes;
        ds.setDriverClass(this.getDriverClass());
        ds.setConnectionUrl(this.getConnectionUrl());
        ds.setUsername(this.getUsername());
        ds.setTimezone(this.getTimezone());
        ds.setPassword(PasswordCipherer.getInstance().decodePassword(this.getPassword()));
    }

    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        JdbcReportDataSource ds = (JdbcReportDataSource)clientRes;
        this.setDriverClass(ds.getDriverClass());
        this.setConnectionUrl(ds.getConnectionUrl());
        this.setUsername(ds.getUsername());
        this.setTimezone(ds.getTimezone());
        this.setPassword(PasswordCipherer.getInstance().encodePassword(ds.getPassword()));
    }
}

