/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.olap.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.service.MondrianConnectionSchemaParameters;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapManagementService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.RepositoryCatalogLocator;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import java.io.Serializable;
import java.util.List;
import mondrian.olap.CacheControl;
import mondrian.rolap.agg.AggregationManager;
import mondrian.spi.CatalogLocator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.ehcache.EhCacheFactoryBean;

public class OlapManagementServiceImpl
implements OlapManagementService {
    private static final Log log = LogFactory.getLog(OlapManagementServiceImpl.class);
    RepositoryService repositoryService;
    OlapConnectionService olapConnectionService;
    private EhCacheFactoryBean mondrianConnectionCacheFactory;
    private EhCacheFactoryBean sharedMondrianConnectionCacheFactory;
    private Cache mondrianConnectionCache;
    private Cache sharedMondrianConnectionCache;
    private CatalogLocator repositoryCatalogLocator = new RepositoryCatalogLocator();
    private ExecutionContext runtimeContext = ExecutionContextImpl.getRuntimeExecutionContext();
    private MondrianConnectionAction flushConnection = new MondrianConnectionAction(){

        public String getName() {
            return "flush connection";
        }

        public void doIt(MondrianConnection monConn) {
            OlapManagementServiceImpl.this.flushConnection((Resource)monConn);
        }
    };
    private MondrianConnectionAction notifySchemaChange = new MondrianConnectionAction(){

        public String getName() {
            return "notify schema change";
        }

        public void doIt(MondrianConnection monConn) {
            String uri = monConn.getURIString();
            Cache aConnectionCache = OlapManagementServiceImpl.this.getMondrianConnectionCache();
            log.debug((Object)("schema change: " + uri));
            Element element = new Element((Serializable)((Object)uri), (Serializable)OlapManagementServiceImpl.this.getConnectionParameters(monConn, false));
            aConnectionCache.remove((Serializable)((Object)uri));
            aConnectionCache.put(element);
        }
    };
    private MondrianConnectionAction notifySchemaUse = new MondrianConnectionAction(){

        public String getName() {
            return "notify schema use";
        }

        public void doIt(MondrianConnection monConn) {
            String uri = OlapManagementServiceImpl.this.transformUri(monConn.getURIString());
            log.debug((Object)("schema use: " + uri));
            Cache aConnectionCache = OlapManagementServiceImpl.this.getMondrianConnectionCache();
            Element schemaReference = aConnectionCache.get((Serializable)((Object)uri));
            if (schemaReference == null) {
                MondrianConnectionSchemaParameters parameters = OlapManagementServiceImpl.this.getConnectionParameters(monConn, true);
                schemaReference = new Element((Serializable)((Object)parameters.repositoryUri), (Serializable)parameters);
                aConnectionCache.put(schemaReference);
            }
        }
    };

    public void flushOlapCache() {
        AggregationManager.instance().getCacheControl(null).flushSchemaCache();
        log.debug((Object)"All schemas flushed");
    }

    public void flushConnection(Resource resource) {
        if (resource == null) {
            throw new JSException("Null resource");
        }
        this.flushIfRelatedToMondrianConnection(resource);
    }

    public void flushConnection(String uri) {
        Resource resource = this.getRepositoryService().getResource(this.runtimeContext, uri);
        if (resource == null) {
            throw new JSException("No such resource: " + uri);
        }
        this.flushConnection(resource);
    }

    private MondrianConnectionSchemaParameters getConnectionParameters(MondrianConnection monConn, boolean transform) {
        MondrianConnectionSchemaParameters parameters = null;
        String monConnUri = transform ? this.transformUri(monConn.getURIString()) : monConn.getURIString();
        String dsUri = null;
        ReportDataSource dataSource = null;
        ResourceReference ref = monConn.getDataSource();
        if (ref.isLocal()) {
            dataSource = (ReportDataSource)ref.getLocalResource();
        } else {
            dsUri = transform ? this.transformUri(ref.getReferenceURI()) : ref.getReferenceURI();
            dataSource = (ReportDataSource)this.getRepositoryService().getResource(this.runtimeContext, dsUri);
        }
        if (dataSource == null) {
            throw new JSException("null data source on dereference of mondrian connection " + monConnUri + " for " + (monConn.getDataSource().isLocal() ? "local: " + ref.getLocalResource().getURIString() : dsUri));
        }
        String catalogUrl = monConn.getSchema().getReferenceURI();
        if (transform) {
            catalogUrl = this.transformUri(catalogUrl);
        }
        catalogUrl = this.repositoryCatalogLocator.locate(catalogUrl);
        log.debug((Object)("catalogUrl: " + catalogUrl + ", original URI: " + monConn.getSchema().getReferenceURI() + ", transform: " + transform));
        if (dataSource instanceof JdbcReportDataSource) {
            JdbcReportDataSource jdbcDs = (JdbcReportDataSource)dataSource;
            String jdbcConnectString = jdbcDs.getConnectionUrl();
            String jdbcUser = jdbcDs.getUsername();
            parameters = new MondrianConnectionSchemaParameters(monConnUri, catalogUrl, jdbcConnectString, jdbcUser);
        } else {
            JndiJdbcReportDataSource jndiDs = (JndiJdbcReportDataSource)dataSource;
            String strDataSource = jndiDs.getJndiName() != null && !jndiDs.getJndiName().startsWith("java:") ? "java:comp/env/" : "";
            strDataSource = strDataSource + jndiDs.getJndiName();
            parameters = new MondrianConnectionSchemaParameters(monConnUri, catalogUrl, strDataSource);
        }
        return parameters;
    }

    public void flushConnection(MondrianConnectionSchemaParameters monConnSchemaParameters) {
        log.debug((Object)("flushing connection " + monConnSchemaParameters));
        String connectionKey = monConnSchemaParameters.jdbcConnectionString;
        CacheControl cacheControl = AggregationManager.instance().getCacheControl(null);
        cacheControl.flushSchema(monConnSchemaParameters.catalogUri, connectionKey, monConnSchemaParameters.jdbcUser, monConnSchemaParameters.jndiDataSource);
    }

    public void flushIfRelatedToMondrianConnection(Resource resource) {
        this.actIfRelatedToMondrianConnection(resource, this.flushConnection);
    }

    protected void actIfRelatedToMondrianConnection(Resource resource, MondrianConnectionAction act) {
        if (resource instanceof JdbcReportDataSource || resource instanceof JndiJdbcReportDataSource) {
            this.actIfRelatedToMondrianConnection("dataSource", resource, act);
        } else if (resource instanceof MondrianConnection) {
            act.doIt((MondrianConnection)resource);
        } else if (resource instanceof FileResource) {
            this.actIfRelatedToMondrianConnection("schema", resource, act);
        }
    }

    protected void actIfRelatedToMondrianConnection(String accessorName, Resource resource, MondrianConnectionAction act) {
        log.debug((Object)("checking for " + act.getName() + ": " + resource.getClass().getName() + ", uri: " + resource.getURIString() + " via accessor: " + accessorName));
        FilterCriteria criteria = new FilterCriteria(this.getMondrianConnectionClass());
        criteria.addFilterElement((FilterElement)FilterCriteria.createReferenceFilter((String)accessorName, resource.getClass(), (String)resource.getURIString()));
        List mondrianConnectionLookups = this.getRepositoryService().loadResourcesList(this.runtimeContext, criteria);
        if (mondrianConnectionLookups != null && !mondrianConnectionLookups.isEmpty()) {
            for (ResourceLookup lookup : mondrianConnectionLookups) {
                MondrianConnection monConn = (MondrianConnection)this.getRepositoryService().getResource(this.runtimeContext, lookup.getURI());
                act.doIt(monConn);
            }
        }
    }

    protected Class getMondrianConnectionClass() {
        return MondrianConnection.class;
    }

    public void notifySchemaChange(ExecutionContext context, Resource resource) {
        this.actIfRelatedToMondrianConnection(resource, this.notifySchemaChange);
    }

    public void notifySchemaUse(ExecutionContext context, Resource resource) {
        this.actIfRelatedToMondrianConnection(resource, this.notifySchemaUse);
    }

    protected String transformUri(String uri) {
        return uri;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public OlapConnectionService getOlapConnectionService() {
        return this.olapConnectionService;
    }

    public void setOlapConnectionService(OlapConnectionService olapConnectionService) {
        this.olapConnectionService = olapConnectionService;
    }

    public EhCacheFactoryBean getMondrianConnectionCacheFactory() {
        return this.mondrianConnectionCacheFactory;
    }

    public void setMondrianConnectionCacheFactory(EhCacheFactoryBean mondrianConnectionCacheFactory) {
        this.mondrianConnectionCacheFactory = mondrianConnectionCacheFactory;
    }

    public EhCacheFactoryBean getSharedMondrianConnectionCacheFactory() {
        return this.sharedMondrianConnectionCacheFactory;
    }

    public void setSharedMondrianConnectionCacheFactory(EhCacheFactoryBean sharedMondrianConnectionCacheFactory) {
        this.sharedMondrianConnectionCacheFactory = sharedMondrianConnectionCacheFactory;
    }

    public Cache getMondrianConnectionCache() {
        if (this.mondrianConnectionCache == null) {
            this.mondrianConnectionCache = (Cache)this.getMondrianConnectionCacheFactory().getObject();
        }
        return this.mondrianConnectionCache;
    }

    public void setMondrianConnectionCache(Cache mondrianConnectionCache) {
        this.mondrianConnectionCache = mondrianConnectionCache;
    }

    public Cache getSharedMondrianConnectionCache() {
        if (this.sharedMondrianConnectionCache == null) {
            this.sharedMondrianConnectionCache = (Cache)this.getSharedMondrianConnectionCacheFactory().getObject();
        }
        return this.sharedMondrianConnectionCache;
    }

    protected static interface MondrianConnectionAction {
        public String getName();

        public void doIt(MondrianConnection var1);
    }
}

