/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.security;

import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.SimpleAclEntry;

public class JasperServerAclEntry
extends SimpleAclEntry {
    public static final int EXECUTE = (int)Math.pow(2.0, 5.0);
    private static final int[] VALID_PERMISSIONS = new int[]{0, ADMINISTRATION, READ, WRITE, CREATE, DELETE, READ_WRITE_CREATE_DELETE, READ_WRITE_CREATE, READ_WRITE, READ_WRITE_DELETE, EXECUTE};
    private static final String[] VALID_PERMISSIONS_AS_STRING = new String[]{"NOTHING", "ADMINISTRATION", "READ", "WRITE", "CREATE", "DELETE", "READ_WRITE_CREATE_DELETE", "READ_WRITE_CREATE", "READ_WRITE", "READ_WRITE_DELETE", "EXECUTE"};

    public JasperServerAclEntry() {
    }

    public JasperServerAclEntry(Object recipient, AclObjectIdentity aclObjectIdentity, AclObjectIdentity aclObjectParentIdentity, int mask) {
        super(recipient, aclObjectIdentity, aclObjectParentIdentity, mask);
    }

    public int[] getValidPermissions() {
        return (int[])VALID_PERMISSIONS.clone();
    }

    public String printPermissionsBlock(int i) {
        StringBuffer sb = new StringBuffer();
        if (this.isPermitted(i, ADMINISTRATION)) {
            sb.append('A');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, READ)) {
            sb.append('R');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, WRITE)) {
            sb.append('W');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, CREATE)) {
            sb.append('C');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, DELETE)) {
            sb.append('D');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, EXECUTE)) {
            sb.append('X');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static int parsePermission(String permission) {
        for (int i = 0; i < VALID_PERMISSIONS_AS_STRING.length; ++i) {
            if (!VALID_PERMISSIONS_AS_STRING[i].equalsIgnoreCase(permission)) continue;
            return VALID_PERMISSIONS[i];
        }
        throw new IllegalArgumentException("Permission provided does not exist: " + permission);
    }
}

