/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

public class StringUtil {
    public static final String[] EMPTY_LIST = new String[0];

    public static int indexOf(String[] strings, String string) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(String[] strings, String string) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String[] insertAt(String[] strings, String string, int index) {
        int tail;
        String[] newStrings = new String[strings.length + 1];
        if (index > 0) {
            System.arraycopy(strings, 0, newStrings, 0, index);
        }
        if ((tail = strings.length - index) > 0) {
            System.arraycopy(strings, index, newStrings, index + 1, tail);
        }
        newStrings[index] = string;
        return newStrings;
    }

    public static String[] prepend(String[] strings, String string) {
        String[] newStrings = new String[strings.length + 1];
        newStrings[0] = string;
        System.arraycopy(strings, 0, newStrings, 1, strings.length);
        return newStrings;
    }

    public static String[] append(String[] strings, String string) {
        String[] newStrings = new String[strings.length + 1];
        System.arraycopy(strings, 0, newStrings, 0, strings.length);
        newStrings[strings.length] = string;
        return newStrings;
    }

    public static String[] remove(String[] strings, String string) {
        int index = StringUtil.indexOf(strings, string);
        if (index < 0) {
            return strings;
        }
        return StringUtil.removeAt(strings, index);
    }

    public static String[] removeAt(String[] strings, int index) {
        int first;
        int tail;
        String string = strings[index];
        String[] newStrings = new String[strings.length - 1];
        if (index > 0) {
            System.arraycopy(strings, 0, newStrings, 0, index);
        }
        if ((tail = strings.length - (first = index + 1)) > 0) {
            System.arraycopy(strings, first, newStrings, index, tail);
        }
        return newStrings;
    }

    public static String protect(String string) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('\"');
        StringUtil.escape(string, buffer);
        buffer.append('\"');
        return buffer.toString();
    }

    public static String escape(String string) {
        StringBuffer buffer = new StringBuffer();
        StringUtil.escape(string, buffer);
        return buffer.toString();
    }

    private static void escape(String string, StringBuffer buffer) {
        int length = string.length();
        block10: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block10;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block10;
                }
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block10;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block10;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block10;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block10;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block10;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block10;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        buffer.append(c);
                        continue block10;
                    }
                    buffer.append("\\u");
                    String hex = Integer.toString(c, 16);
                    for (int hexLength = hex.length(); hexLength < 4; ++hexLength) {
                        buffer.append('0');
                    }
                    buffer.append(hex);
                }
            }
        }
    }

    public static String unprotect(String string) {
        int length = string.length();
        if (length >= 2 && string.charAt(0) == '\"' && string.charAt(length - 1) == '\"') {
            return StringUtil.unescape(string, 1, length - 2);
        }
        return StringUtil.unescape(string, 0, length);
    }

    public static String unescape(String string) {
        return StringUtil.unescape(string, 0, string.length());
    }

    private static String unescape(String string, int offset, int length) {
        StringBuffer buffer = new StringBuffer();
        int end = offset + length;
        block16: for (int i = offset; i < end; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (i + 1 == end) {
                        buffer.append(c);
                        continue block16;
                    }
                    switch (string.charAt(i + 1)) {
                        case 'b': {
                            buffer.append('\b');
                            ++i;
                            break;
                        }
                        case 't': {
                            buffer.append('\t');
                            ++i;
                            break;
                        }
                        case 'n': {
                            buffer.append('\n');
                            ++i;
                            break;
                        }
                        case 'f': {
                            buffer.append('\f');
                            ++i;
                            break;
                        }
                        case 'r': {
                            buffer.append('\r');
                            ++i;
                            break;
                        }
                        case '\"': {
                            buffer.append('\"');
                            ++i;
                            break;
                        }
                        case '\'': {
                            buffer.append('\'');
                            ++i;
                            break;
                        }
                        case '\\': {
                            buffer.append('\\');
                            ++i;
                            break;
                        }
                        case 'u': {
                            if (i + 5 >= end) continue block16;
                            try {
                                int escaped = Integer.parseInt(string.substring(i + 2, i + 6), 16);
                                buffer.append((char)escaped);
                                i += 5;
                            }
                            catch (NumberFormatException ignore) {
                                buffer.append(c);
                            }
                            break;
                        }
                        default: {
                            buffer.append(c);
                            break;
                        }
                    }
                    continue block16;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static final void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String arg2 = StringUtil.protect(arg);
            System.out.print("'");
            System.out.print(arg);
            System.out.print("' = ");
            System.out.print(arg2);
            System.out.print(" = ");
            System.out.println(StringUtil.unprotect(arg2));
        }
    }

    public static String capitalize(String string) {
        int length = string.length();
        if (length == 0) {
            return string;
        }
        if (length == 1) {
            return string.toUpperCase();
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String uncapitalize(String string) {
        int length = string.length();
        if (length == 0) {
            return string;
        }
        if (length == 1) {
            return string.toLowerCase();
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public static String[] split(String string, char separatorChar) {
        int nextSep;
        int elementCount = 0;
        int sep = 0;
        while ((sep = string.indexOf(separatorChar, sep)) >= 0) {
            ++elementCount;
            ++sep;
        }
        String[] elements = new String[++elementCount];
        elementCount = 0;
        sep = 0;
        while ((nextSep = string.indexOf(separatorChar, sep)) >= 0) {
            elements[elementCount++] = sep == nextSep ? "" : string.substring(sep, nextSep);
            sep = nextSep + 1;
        }
        elements[elementCount++] = string.substring(sep);
        return elements;
    }

    public static String join(String[] strings, char separatorChar) {
        StringBuffer buffer = new StringBuffer();
        int stringCount = strings.length;
        if (stringCount > 0) {
            buffer.append(strings[0]);
            for (int i = 1; i < stringCount; ++i) {
                buffer.append(separatorChar);
                buffer.append(strings[i]);
            }
        }
        return buffer.toString();
    }

    public static String join(String[] strings, String separator) {
        StringBuffer buffer = new StringBuffer();
        int stringCount = strings.length;
        if (stringCount > 0) {
            buffer.append(strings[0]);
            for (int i = 1; i < stringCount; ++i) {
                buffer.append(separator);
                buffer.append(strings[i]);
            }
        }
        return buffer.toString();
    }

    public static String replaceAll(String string, String oldSub, String newSub) {
        int end;
        StringBuffer replaced = new StringBuffer();
        int oldSubLength = oldSub.length();
        int begin = 0;
        while ((end = string.indexOf(oldSub, begin)) >= 0) {
            if (end > begin) {
                replaced.append(string.substring(begin, end));
            }
            replaced.append(newSub);
            begin = end + oldSubLength;
        }
        if (begin < string.length()) {
            replaced.append(string.substring(begin));
        }
        return replaced.toString();
    }
}

