/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.io.ExportImportIOFactory;
import com.jaspersoft.jasperserver.export.io.ExportOutput;
import com.jaspersoft.jasperserver.export.io.ExportOutputFactory;
import com.jaspersoft.jasperserver.export.io.ImportInput;
import com.jaspersoft.jasperserver.export.io.ImportInputFactory;
import com.jaspersoft.jasperserver.export.util.CommandOut;
import java.util.List;

public class ExportImportIOFactoryImpl
implements ExportImportIOFactory {
    private static final CommandOut commandOut = CommandOut.getInstance();
    private List outputFactories;
    private List inputFactories;

    public ImportInput createInput(Parameters parameters) {
        ImportInputFactory matchingFactory = null;
        for (ImportInputFactory factory : this.inputFactories) {
            if (!factory.matches(parameters)) continue;
            matchingFactory = factory;
            break;
        }
        if (matchingFactory == null) {
            throw new JSException("No input parameter was specified");
        }
        commandOut.debug("Using " + matchingFactory.getClass().getName() + " input factory");
        return matchingFactory.createInput(parameters);
    }

    public ExportOutput createOutput(Parameters parameters) {
        ExportOutputFactory matchingFactory = null;
        for (ExportOutputFactory factory : this.outputFactories) {
            if (!factory.matches(parameters)) continue;
            matchingFactory = factory;
            break;
        }
        if (matchingFactory == null) {
            throw new JSException("jsexception.no.output.parameter.specified");
        }
        commandOut.debug("Using " + matchingFactory.getClass().getName() + " output factory");
        return matchingFactory.createOutput(parameters);
    }

    public List getOutputFactories() {
        return this.outputFactories;
    }

    public void setOutputFactories(List outputFactories) {
        this.outputFactories = outputFactories;
    }

    public List getInputFactories() {
        return this.inputFactories;
    }

    public void setInputFactories(List inputFactories) {
        this.inputFactories = inputFactories;
    }
}

