/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.export.io.BaseImportInput;
import com.jaspersoft.jasperserver.export.io.PathProcessor;
import com.jaspersoft.jasperserver.export.io.ZipFileInputManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileInput
extends BaseImportInput {
    private final String zipFilename;
    private final ZipFileInputManager manager;
    private PathProcessor pathProcessor;
    private ZipFile zipFile;

    public ZipFileInput(String zipFilename, PathProcessor pathProcessor, ZipFileInputManager manager) {
        this.zipFilename = zipFilename;
        this.pathProcessor = pathProcessor;
        this.manager = manager;
    }

    public void open() throws IOException {
        this.zipFile = new ZipFile(new File(this.zipFilename), 1);
    }

    public void close() throws IOException {
        this.zipFile.close();
    }

    public boolean fileExists(String path) {
        ZipEntry entry = this.zipFile.getEntry(this.getZipPath(path));
        return entry != null && !entry.isDirectory();
    }

    public boolean folderExists(String path) {
        ZipEntry entry = this.zipFile.getEntry(this.getZipPath(path));
        return entry != null && entry.isDirectory();
    }

    public InputStream getFileInputStream(String path) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(this.getZipPath(path));
        return this.zipFile.getInputStream(entry);
    }

    protected String getZipPath(String path) {
        return this.pathProcessor.processPath(path);
    }

    public void propertiesRead(Properties properties) {
        this.manager.updateInputProperties(this, properties);
    }

    public void setPathProcessor(PathProcessor pathProcessor) {
        this.pathProcessor = pathProcessor;
    }
}

