/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.export.draw.EllipseDrawer;
import net.sf.jasperreports.engine.export.draw.FrameDrawer;
import net.sf.jasperreports.engine.export.draw.ImageDrawer;
import net.sf.jasperreports.engine.export.draw.LineDrawer;
import net.sf.jasperreports.engine.export.draw.Offset;
import net.sf.jasperreports.engine.export.draw.RectangleDrawer;
import net.sf.jasperreports.engine.export.draw.TextDrawer;
import net.sf.jasperreports.engine.util.JRProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintDrawVisitor
implements PrintElementVisitor<Offset> {
    private Graphics2D grx;
    private LineDrawer lineDrawer = new LineDrawer();
    private RectangleDrawer rectangleDrawer = new RectangleDrawer();
    private EllipseDrawer ellipseDrawer = new EllipseDrawer();
    private ImageDrawer imageDrawer = new ImageDrawer();
    private TextDrawer textDrawer;
    private FrameDrawer frameDrawer;

    public void setTextRenderer(JRReport report) {
        TextRenderer textRenderer = new TextRenderer(JRProperties.getBooleanProperty(report, "net.sf.jasperreports.export.graphics2d.min.job.size", true), JRProperties.getBooleanProperty(report, "net.sf.jasperreports.awt.ignore.missing.font", false));
        this.textDrawer = new TextDrawer(textRenderer);
        this.frameDrawer = new FrameDrawer(null, textRenderer);
    }

    public void setTextDrawer(TextDrawer textDrawer) {
        this.textDrawer = textDrawer;
    }

    public void setFrameDrawer(FrameDrawer frameDrawer) {
        this.frameDrawer = frameDrawer;
    }

    public void setClip(boolean isClip) {
        this.frameDrawer.setClip(isClip);
    }

    public void setGraphics2D(Graphics2D grx) {
        this.grx = grx;
    }

    @Override
    public void visit(JRPrintText textElement, Offset offset) {
        this.textDrawer.draw(this.grx, textElement, offset.getX(), offset.getY());
    }

    @Override
    public void visit(JRPrintImage image, Offset offset) {
        try {
            this.imageDrawer.draw(this.grx, image, offset.getX(), offset.getY());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public void visit(JRPrintRectangle rectangle, Offset offset) {
        this.rectangleDrawer.draw(this.grx, rectangle, offset.getX(), offset.getY());
    }

    @Override
    public void visit(JRPrintLine line, Offset offset) {
        this.lineDrawer.draw(this.grx, line, offset.getX(), offset.getY());
    }

    @Override
    public void visit(JRPrintEllipse ellipse, Offset offset) {
        this.ellipseDrawer.draw(this.grx, ellipse, offset.getX(), offset.getY());
    }

    @Override
    public void visit(JRPrintFrame frame, Offset offset) {
        try {
            this.frameDrawer.draw(this.grx, frame, offset.getX(), offset.getY());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public void visit(JRGenericPrintElement printElement, Offset offset) {
    }
}

