/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;

public class InstallMojo
extends AbstractInstallMojo {
    protected String packaging;
    private File pomFile;
    private Artifact artifact;
    private List attachedArtifacts;

    public void execute() throws MojoExecutionException {
        boolean isPomArtifact = "pom".equals(this.packaging);
        ProjectArtifactMetadata metadata = null;
        if (this.updateReleaseInfo) {
            this.artifact.setRelease(true);
        }
        try {
            if (isPomArtifact) {
                this.installer.install(this.pomFile, this.artifact, this.localRepository);
                this.installChecksums(this.artifact);
            } else {
                metadata = new ProjectArtifactMetadata(this.artifact, this.pomFile);
                this.artifact.addMetadata((ArtifactMetadata)metadata);
                File file = this.artifact.getFile();
                if (file != null && file.isFile()) {
                    this.installer.install(file, this.artifact, this.localRepository);
                    this.installChecksums(this.artifact);
                } else if (!this.attachedArtifacts.isEmpty()) {
                    this.getLog().info((CharSequence)"No primary artifact to install, installing attached artifacts instead.");
                    Artifact pomArtifact = this.artifactFactory.createProjectArtifact(this.artifact.getGroupId(), this.artifact.getArtifactId(), this.artifact.getBaseVersion());
                    pomArtifact.setFile(this.pomFile);
                    if (this.updateReleaseInfo) {
                        pomArtifact.setRelease(true);
                    }
                    this.installer.install(this.pomFile, pomArtifact, this.localRepository);
                    this.installChecksums(pomArtifact);
                } else {
                    throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
                }
            }
            Iterator i = this.attachedArtifacts.iterator();
            while (i.hasNext()) {
                Artifact attached = (Artifact)i.next();
                this.installer.install(attached.getFile(), attached, this.localRepository);
                this.installChecksums(attached);
            }
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

