/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.authority;

import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSRoleSearchCriteria;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import com.jaspersoft.jasperserver.ws.authority.WSUserSearchCriteria;
import com.jaspersoft.jasperserver.ws.axis2.authority.RoleBeanTraslator;
import com.jaspersoft.jasperserver.ws.axis2.authority.UserAndRoleManagementService;
import com.jaspersoft.jasperserver.ws.axis2.authority.UserBeanTraslator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.axis.AxisFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAndRoleManagementServiceImpl
implements UserAndRoleManagementService {
    protected UserAuthorityService userAuthorityService;
    private TenantService tenantService;
    private AuditContext auditContext;
    private SecurityContextProvider securityContextProvider;
    private ConfigurationBean conf;
    private List<WSRole> defaultRoles;

    protected void createAuditEvent(final String auditEventType) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                UserAndRoleManagementServiceImpl.this.auditContext.createAuditEvent(auditEventType);
            }
        });
    }

    protected void addExceptionToAuditEvent(String auditEventType, final Exception exception) {
        this.auditContext.doInAuditContext(auditEventType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                UserAndRoleManagementServiceImpl.this.auditContext.addPropertyToAuditEvent("exception", (Object)exception, auditEvent);
            }
        });
    }

    @Override
    public WSUser[] findUsers(WSUserSearchCriteria criteria) throws AxisFault {
        if (criteria == null) {
            throw new AxisFault("User search criteria is null.");
        }
        if (!this.doesContextUserHasAccessToTenant(criteria.getTenantId())) {
            throw new AxisFault("Access is denied.");
        }
        List<Object> userList = new ArrayList();
        int maxRecords = criteria.getMaxRecords();
        Boolean includeSubOrgs = criteria.getIncludeSubOrgs();
        Set tenantsCriteriaSet = this.getTenantsCriteriaSet(criteria.getTenantId(), includeSubOrgs == null || includeSubOrgs != false);
        List<Role> requiredRoles = RoleBeanTraslator.toRoleList(criteria.getRequiredRoles());
        List result = maxRecords > 0 ? this.userAuthorityService.getTenantUsers(null, tenantsCriteriaSet, criteria.getName(), 0, maxRecords) : this.userAuthorityService.getTenantUsers(null, tenantsCriteriaSet, criteria.getName());
        userList = this.getUsersWithRoles(result, requiredRoles);
        return UserBeanTraslator.toWSUserArray(userList);
    }

    private List<User> getUsersWithRoles(List users, List<Role> roles) {
        if (roles == null) {
            return new ArrayList<User>(users);
        }
        ArrayList<User> userList = new ArrayList<User>();
        for (Object o : users) {
            User u = (User)o;
            if (!this.isUserHasRoles(u, roles)) continue;
            userList.add(u);
        }
        return userList;
    }

    private boolean isUserHasRoles(User user, List<Role> roles) {
        boolean isUserHasRoles = true;
        for (Role r : roles) {
            boolean hasRole = false;
            for (Object o : user.getRoles()) {
                Role ur = (Role)o;
                boolean isNameEquals = ur.getRoleName().equals(r.getRoleName());
                boolean isTenantEquals = this.isTenantEquals(ur.getTenantId(), r.getTenantId());
                if (!isNameEquals || !isTenantEquals) continue;
                hasRole = true;
                break;
            }
            if (hasRole) continue;
            isUserHasRoles = false;
            break;
        }
        return isUserHasRoles;
    }

    private boolean isTenantEquals(String tenantId1, String tenantId2) {
        if (tenantId1 == null) {
            return tenantId2 == null;
        }
        return tenantId1.equals(tenantId2);
    }

    @Override
    public WSUser putUser(WSUser user) throws AxisFault {
        String auditEventType = "createUser";
        try {
            if (user == null) {
                this.createAuditEvent(auditEventType);
                throw new AxisFault("User is null.");
            }
            User aUser = UserBeanTraslator.toUser(user);
            String nameWithoutNotSupportedSymbols = aUser.getUsername().replaceAll(this.conf.getUserNameNotSupportedSymbols(), "");
            if (nameWithoutNotSupportedSymbols.length() != aUser.getUsername().length()) {
                this.createAuditEvent(auditEventType);
                throw new AxisFault("User name contains not supported symbols");
            }
            User existedUser = this.getUser(aUser);
            auditEventType = existedUser == null ? "createUser" : "updateUser";
            this.createAuditEvent(auditEventType);
            if (!this.isEmailValid(aUser)) {
                throw new AxisFault("Email address contains not supported symbols");
            }
            if (aUser.getPassword() == null || aUser.getPassword().trim().length() == 0) {
                throw new AxisFault("Password should not be empty");
            }
            if (!this.doesContextUserHasAccessToTenant(aUser.getTenantId())) {
                throw new AxisFault("Access is denied.");
            }
            if (existedUser == null && this.defaultRoles != null) {
                for (WSRole wsRole : this.defaultRoles) {
                    Role role = this.getRole(RoleBeanTraslator.toRole(wsRole));
                    this.addDefaultRoleToUser(role, aUser);
                }
            }
            try {
                this.userAuthorityService.putUser(null, aUser);
            }
            catch (Exception e) {
                this.handleUnexpectedException(e, aUser.getUsername());
            }
            return UserBeanTraslator.toWSUser(aUser);
        }
        catch (AxisFault axisFault) {
            this.addExceptionToAuditEvent(auditEventType, (Exception)((Object)axisFault));
            throw axisFault;
        }
    }

    private boolean isEmailValid(User user) throws AxisFault {
        String email = user.getEmailAddress();
        if (email == null) {
            return true;
        }
        return !(email.trim().length() > 0 ? !JasperServerUtil.regExValidateEmail((String)user.getEmailAddress()) : email.trim().length() != email.length());
    }

    private void addDefaultRoleToUser(Role role, User user) {
        if (role == null) {
            return;
        }
        boolean isUserHasRole = false;
        for (Object o : user.getRoles()) {
            Role r = (Role)o;
            boolean isNameEquals = role.getRoleName().equals(r.getRoleName());
            boolean isTenantEquals = this.isTenantEquals(role.getTenantId(), r.getTenantId());
            isUserHasRole = isNameEquals && isTenantEquals;
            if (!isUserHasRole) continue;
            return;
        }
        user.addRole(role);
    }

    protected User getUser(User user) {
        return this.userAuthorityService.getUser(null, user.getUsername());
    }

    @Override
    public void deleteUser(WSUser user) throws AxisFault {
        this.createAuditEvent("deleteUser");
        try {
            if (user == null) {
                throw new AxisFault("User is null.");
            }
            if (!this.doesContextUserHasAccessToTenant(user.getTenantId())) {
                throw new AxisFault("Access is denied.");
            }
            this.deleteUser(user.getUsername(), user.getTenantId());
        }
        catch (AxisFault axisFault) {
            this.addExceptionToAuditEvent("deleteUser", (Exception)((Object)axisFault));
            throw axisFault;
        }
    }

    protected void deleteUser(String username, String tenantId) {
        this.userAuthorityService.deleteUser(null, username);
    }

    @Override
    public WSRole[] findRoles(WSRoleSearchCriteria criteria) throws AxisFault {
        if (criteria == null) {
            throw new AxisFault("Role search criteria is null.");
        }
        if (!this.doesContextUserHasAccessToTenant(criteria.getTenantId()) && !this.isRootTenant(criteria.getTenantId())) {
            throw new AxisFault("Access is denied.");
        }
        int maxRecords = criteria.getMaxRecords();
        Boolean includeSubOrgs = criteria.getIncludeSubOrgs();
        Set tenantsCriteriaSet = this.getTenantsCriteriaSet(criteria.getTenantId(), includeSubOrgs == null || includeSubOrgs != false);
        List result = maxRecords > 0 ? this.userAuthorityService.getTenantRoles(null, tenantsCriteriaSet, criteria.getRoleName(), 0, maxRecords) : this.userAuthorityService.getTenantRoles(null, tenantsCriteriaSet, criteria.getRoleName());
        return RoleBeanTraslator.toWSRoleArray(result);
    }

    @Override
    public WSRole putRole(WSRole role) throws AxisFault {
        String auditEventType = "createRole";
        try {
            if (role == null) {
                this.createAuditEvent(auditEventType);
                throw new AxisFault("Role is null.");
            }
            Role aRole = RoleBeanTraslator.toRole(role);
            String nameWithoutNotSupportedSymbols = aRole.getRoleName().replaceAll(this.conf.getRoleNameNotSupportedSymbols(), "");
            if (nameWithoutNotSupportedSymbols.length() != aRole.getRoleName().length()) {
                this.createAuditEvent(auditEventType);
                throw new AxisFault("Role name contains not supported symbols");
            }
            Role existedRole = this.getRole(aRole);
            auditEventType = existedRole == null ? "createRole" : "updateRole";
            this.createAuditEvent(auditEventType);
            if (!this.doesContextUserHasAccessToTenant(aRole.getTenantId())) {
                throw new AxisFault("Access is denied.");
            }
            this.userAuthorityService.putRole(null, aRole);
            Role r = this.getRole(aRole);
            if (r != null) {
                return RoleBeanTraslator.toWSRole(r);
            }
            throw new AxisFault("Error while putting role : " + aRole.getRoleName());
        }
        catch (AxisFault axisFault) {
            this.addExceptionToAuditEvent(auditEventType, (Exception)((Object)axisFault));
            throw axisFault;
        }
    }

    @Override
    public WSRole updateRoleName(WSRole oldRole, String newName) throws AxisFault {
        this.createAuditEvent("updateRole");
        try {
            if (oldRole == null) {
                throw new AxisFault("Role is null.");
            }
            if (newName == null) {
                throw new AxisFault("New name is null.");
            }
            Role aRole = RoleBeanTraslator.toRole(oldRole);
            String nameWithoutNotSupportedSymbols = newName.replaceAll(this.conf.getRoleNameNotSupportedSymbols(), "");
            if (nameWithoutNotSupportedSymbols.length() != newName.length()) {
                throw new AxisFault("Role name contains not supported symbols");
            }
            if (!this.doesContextUserHasAccessToTenant(aRole.getTenantId())) {
                throw new AxisFault("Access is denied.");
            }
            Role existedRole = this.getRole(aRole);
            if (existedRole == null) {
                throw new AxisFault("Can't find role " + aRole.getRoleName());
            }
            String auditEventType = "updateRole";
            this.createAuditEvent(auditEventType);
            RoleImpl newRole = new RoleImpl();
            newRole.setRoleName(newName);
            newRole.setTenantId(existedRole.getTenantId());
            newRole.setExternallyDefined(existedRole.isExternallyDefined());
            Role r = this.updateRole(existedRole, (Role)newRole);
            if (r != null) {
                return RoleBeanTraslator.toWSRole(r);
            }
            throw new AxisFault("Error while putting role : " + aRole.getRoleName());
        }
        catch (AxisFault axisFault) {
            this.addExceptionToAuditEvent("updateRole", (Exception)((Object)axisFault));
            throw axisFault;
        }
    }

    protected Role updateRole(Role oldRole, Role newRole) {
        this.userAuthorityService.updateRole(null, oldRole.getRoleName(), newRole);
        return this.getRole(newRole);
    }

    protected Role getRole(Role role) {
        return this.userAuthorityService.getRole(null, role.getRoleName());
    }

    protected Set getTenantsCriteriaSet(String tenantId, boolean includeSubOrgs) throws AxisFault {
        HashSet<String> tenantIdSet = new HashSet<String>();
        tenantIdSet.add(tenantId);
        if (includeSubOrgs) {
            String id = tenantId == null ? "organizations" : tenantId;
            List allTenants = null;
            try {
                allTenants = this.tenantService.getAllSubTenantList(null, id);
            }
            catch (Exception e) {
                throw new AxisFault("Organization '" + tenantId + "' not found.");
            }
            if (allTenants != null) {
                for (Tenant tenant : allTenants) {
                    tenantIdSet.add(tenant.getId());
                }
            }
        }
        return tenantIdSet;
    }

    @Override
    public void deleteRole(WSRole role) throws AxisFault {
        this.createAuditEvent("deleteRole");
        try {
            if (role == null) {
                throw new AxisFault("Role is null.");
            }
            if (!this.doesContextUserHasAccessToTenant(role.getTenantId())) {
                throw new AxisFault("Access is denied.");
            }
            this.deleteRole(role.getRoleName(), role.getTenantId());
        }
        catch (AxisFault axisFault) {
            this.addExceptionToAuditEvent("deleteRole", (Exception)((Object)axisFault));
            throw axisFault;
        }
    }

    protected void deleteRole(String roleName, String tenantId) {
        this.userAuthorityService.deleteRole(null, roleName);
    }

    private boolean doesContextUserHasAccessToTenant(String tenantId) throws AxisFault {
        String currentTenantId = this.securityContextProvider.getContextUser().getTenantId();
        Set tenants = this.getTenantsCriteriaSet(currentTenantId, true);
        return tenants.contains(tenantId);
    }

    private boolean isRootTenant(String tenantId) throws AxisFault {
        return tenantId == null || "organizations".equals(tenantId);
    }

    public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
        this.userAuthorityService = userAuthorityService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public void setDefaultRoles(List<WSRole> defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public void setConfigurationBean(ConfigurationBean configurationBean) {
        this.conf = configurationBean;
    }

    protected void handleUnexpectedException(Exception unexpectedException, String username) throws AxisFault {
        throw new AxisFault("An unexpected exception has occurred while putting user:" + username);
    }
}

