/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.springframework.remoting.caucho.HessianSkeletonInvoker;
import org.springframework.util.ClassUtils;

class Hessian1SkeletonInvoker
extends HessianSkeletonInvoker {
    private static final Method invokeMethod = ClassUtils.getMethodIfAvailable((Class)HessianSkeleton.class, (String)"invoke", (Class[])new Class[]{HessianInput.class, HessianOutput.class});
    private static final boolean applySerializerFactoryToOutput = ClassUtils.hasMethod((Class)HessianOutput.class, (String)"setSerializerFactory", (Class[])new Class[]{SerializerFactory.class});

    public Hessian1SkeletonInvoker(HessianSkeleton skeleton, SerializerFactory serializerFactory) {
        super(skeleton, serializerFactory);
        if (invokeMethod == null) {
            throw new IllegalStateException("Hessian 1 (version 3.0.19-) not present");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(InputStream inputStream, OutputStream outputStream) throws Throwable {
        HessianInput in = new HessianInput(inputStream);
        HessianOutput out = new HessianOutput(outputStream);
        if (this.serializerFactory != null) {
            in.setSerializerFactory(this.serializerFactory);
            if (applySerializerFactoryToOutput) {
                out.setSerializerFactory(this.serializerFactory);
            }
        }
        try {
            invokeMethod.invoke((Object)this.skeleton, in, out);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                in.close();
                inputStream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                out.close();
                outputStream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            inputStream.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            out.close();
            outputStream.close();
        }
        catch (IOException ex) {}
    }
}

