/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;

class DrilldownMemberFunDef
extends FunDefBase {
    static final String[] reservedWords = new String[]{"RECURSIVE"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("DrilldownMember", "DrilldownMember(<Set1>, <Set2>[, RECURSIVE])", "Drills down the members in a set that are present in a second specified set.", new String[]{"fxxx", "fxxxy"}, DrilldownMemberFunDef.class, reservedWords);

    public DrilldownMemberFunDef(FunDef funDef) {
        super(funDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        String literalArg = DrilldownMemberFunDef.getLiteralArg(call, 2, "", reservedWords);
        final boolean recursive = literalArg.equals("RECURSIVE");
        return new AbstractListCalc(call, new Calc[]{listCalc1, listCalc2}){

            @Override
            public List evaluateList(Evaluator evaluator) {
                List list1 = listCalc1.evaluateList(evaluator);
                List list2 = listCalc2.evaluateList(evaluator);
                return this.drilldownMember(list1, list2, evaluator);
            }

            /*
             * WARNING - void declaration
             */
            protected void drillDownObj(Evaluator evaluator, Object element, Set memberSet, List<Object> resultList) {
                Member[] tuple;
                if (null == element) {
                    return;
                }
                Member m = null;
                int k = -1;
                if (element instanceof Member) {
                    m = (Member)element;
                    if (!memberSet.contains(m)) {
                        return;
                    }
                    tuple = null;
                } else {
                    void var10_12;
                    Util.assertTrue(element instanceof Member[]);
                    tuple = (Member[])element;
                    m = null;
                    Member[] arr$ = tuple;
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var10_12 < len$) {
                        Member member = arr$[var10_12];
                        ++k;
                        if (memberSet.contains(member)) {
                            m = member;
                            break;
                        }
                        ++var10_12;
                    }
                    if (m == null) {
                        return;
                    }
                }
                List<Member> children = evaluator.getSchemaReader().getMemberChildren(m);
                for (Member[] memberArray : children) {
                    Member[] objNew;
                    if (tuple == null) {
                        objNew = memberArray;
                    } else {
                        Member[] members = (Member[])tuple.clone();
                        members[k] = memberArray;
                        objNew = members;
                    }
                    resultList.add(objNew);
                    if (!recursive) continue;
                    this.drillDownObj(evaluator, objNew, memberSet, resultList);
                }
            }

            private List drilldownMember(List<?> v0, List<Member> v1, Evaluator evaluator) {
                if (null == v0 || v0.isEmpty() || null == v1 || v1.isEmpty()) {
                    return v0;
                }
                HashSet<Member> set1 = new HashSet<Member>();
                set1.addAll(v1);
                ArrayList<Object> result = new ArrayList<Object>();
                int i = 0;
                int n = v0.size();
                while (i < n) {
                    Object o = v0.get(i++);
                    result.add(o);
                    this.drillDownObj(evaluator, o, set1, result);
                }
                return result;
            }
        };
    }
}

