/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.core.util.CipherUtil;
import com.jaspersoft.jasperserver.war.action.EntitiesListManager;
import com.jaspersoft.jasperserver.war.action.EntitiesListState;
import com.jaspersoft.jasperserver.war.helper.JSONHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseFormAction
extends FormAction {
    protected static final String AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    private final String ATTRIBUTE_STATE = ((Object)((Object)this)).getClass().getName() + ":state";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected TenantService tenantService;
    protected MessageSource messages;
    protected JSONHelper jsonHelper;
    protected AuditContext auditContext;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public void setJsonHelper(JSONHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    protected void putState(RequestContext context, Object state) {
        context.getExternalContext().getSessionMap().put(this.ATTRIBUTE_STATE, state);
    }

    protected Object getState(RequestContext context) {
        return context.getExternalContext().getSessionMap().get(this.ATTRIBUTE_STATE);
    }

    protected String getParameter(RequestContext context, String name) {
        ParameterMap map = context.getRequestParameters();
        if (map.contains(name)) {
            return map.get(name);
        }
        return null;
    }

    public String getDecodedRequestParameter(RequestContext context, String name) {
        return CipherUtil.uriDecode((String)this.getParameter(context, name));
    }

    protected List getEntitiesAndUpdateState(EntitiesListState state, int maxResults, EntitiesListManager manager) {
        if (state.getResultIndex() == 0) {
            state.updateResultState(0, manager.getResultsCount());
        }
        List entities = state.getResultIndex() >= state.getResultsCount() ? Collections.emptyList() : manager.getResults(state.getResultIndex(), maxResults);
        state.updateResultState(state.getResultIndex() + entities.size(), state.getResultsCount());
        return entities;
    }

    protected Set<String> getSubTenantIdsSet(String tenantId) {
        if (tenantId == null) {
            return null;
        }
        HashSet<String> tenantIdSet = new HashSet<String>();
        if (!tenantId.equals("organizations")) {
            tenantIdSet.add(tenantId);
            List allSubTenantIds = this.tenantService.getAllSubTenantIdList(null, tenantId);
            if (allSubTenantIds != null) {
                tenantIdSet.addAll(allSubTenantIds);
            }
        }
        return tenantIdSet;
    }

    protected String getCurrentTenantId() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        TenantQualified tenantQualified = (TenantQualified)authenticationToken.getPrincipal();
        if (authenticationToken.getPrincipal() instanceof TenantQualified) {
            return tenantQualified.getTenantId();
        }
        return null;
    }

    protected List<Role> getCurrentUserRoles() {
        MetadataUserDetails userDetails;
        Set roles;
        ArrayList<Role> roleList = new ArrayList<Role>();
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        if (authenticationToken.getPrincipal() instanceof MetadataUserDetails && (roles = (userDetails = (MetadataUserDetails)authenticationToken.getPrincipal()).getRoles()) != null) {
            roleList.addAll(roles);
        }
        return roleList;
    }

    protected String getCurrentUsername() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        return authenticationToken.getName();
    }

    protected void createAuditEvent(final String auditEventName) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                BaseFormAction.this.auditContext.createAuditEvent(auditEventName);
            }
        });
    }

    protected void closeAuditEvent(String auditEventName) {
        this.auditContext.doInAuditContext(auditEventName, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                BaseFormAction.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }
}

