/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CustomReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceDefinition;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JdkTimeZonesList;
import com.jaspersoft.jasperserver.war.dto.ReportDataSourceWrapper;
import com.jaspersoft.jasperserver.war.dto.StringOption;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class DataSourceAction
extends FormAction
implements ApplicationContextAware {
    private static final String ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS = "resourceIdNotSupportedSymbols";
    private RepositoryService repository;
    private JasperServerConstImpl constants = new JasperServerConstImpl();
    private JdkTimeZonesList timezones;
    private ResourceFactory dataSourceMappings;
    public static final String FORM_OBJECT_KEY = "dataResource";
    public static final String DATASOURCEURI_PARAM = "resource";
    public static final String PARENT_FOLDER_ATTR = "parentFolder";
    public static final String PARENT_FOLDER_URI = "ParentFolderUri";
    public static final String DATASOURCE_JDBC = "jdbc";
    public static final String DATASOURCE_JNDI = "jndi";
    public static final String DATASOURCE_BEAN = "bean";
    public static final String TYPE = "type";
    protected MessageSource messages;
    private ConfigurationBean configuration;
    private CustomReportDataSourceServiceFactory customDataSourceFactory;
    private EngineService engine;
    private String queryLanguageFlowAttribute;
    ApplicationContext ctx;

    public DataSourceAction() {
        this.setFormObjectClass(ReportDataSourceWrapper.class);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.ctx = arg0;
    }

    public Event initAction(RequestContext context) throws Exception {
        TimeZone zone;
        StringOption option;
        ReportDataSourceWrapper formObject = (ReportDataSourceWrapper)this.getFormObject(context);
        if (formObject.isNewMode()) {
            context.getFlowScope().put(TYPE, (Object)context.getExternalContext().getRequestParameterMap().get(TYPE));
        } else {
            context.getFlowScope().put(TYPE, (Object)this.getTypeByFormObjectByType(formObject.getType()));
        }
        String typeFromRequest = context.getExternalContext().getRequestParameterMap().get(TYPE);
        boolean forceNewMode = formObject.isSubflowMode();
        if (formObject.isNewMode() || typeFromRequest != null && !typeFromRequest.equals(this.getTypeByFormObjectByType(formObject.getType()))) {
            formObject = (ReportDataSourceWrapper)this.createFormObject(context);
            if (forceNewMode) {
                formObject.setMode((byte)3);
            }
        }
        ReportDataSource ds = formObject.getReportDataSource();
        Locale displayLocale = LocaleContextHolder.getLocale();
        String selectedTimezone = null;
        if (ds instanceof JdbcReportDataSource) {
            selectedTimezone = ((JdbcReportDataSource)ds).getTimezone();
        }
        if (ds instanceof JndiJdbcReportDataSource) {
            selectedTimezone = ((JndiJdbcReportDataSource)ds).getTimezone();
        }
        ArrayList<StringOption> timezoneList = this.timezones.getTimeZones(displayLocale);
        timezoneList = new ArrayList<StringOption>(timezoneList);
        if (selectedTimezone != null && selectedTimezone.length() > 0 && !timezoneList.contains(option = new StringOption(selectedTimezone, (zone = TimeZone.getTimeZone(selectedTimezone)).getDisplayName(displayLocale)))) {
            timezoneList.add(0, option);
        }
        context.getFlowScope().put("timezones", timezoneList);
        context.getFlowScope().put("selectedTimezone", (Object)selectedTimezone);
        this.getFormObjectAccessor(context).setCurrentFormObject((Object)formObject, ScopeType.FLOW);
        context.getFlowScope().put(FORM_OBJECT_KEY, (Object)formObject);
        context.getFlowScope().put(ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getResourceIdNotSupportedSymbols());
        if (formObject.getReportDataSource() != null) {
            formObject.getReportDataSource().setParentFolder(context.getExternalContext().getRequestParameterMap().get(PARENT_FOLDER_URI));
        }
        if (formObject.isSubflowMode() && formObject.getAllDatasources() == null) {
            context.getFlowScope().put("constants", (Object)this.constants);
        }
        if (ds instanceof CustomReportDataSource) {
            CustomReportDataSource cds = (CustomReportDataSource)ds;
            CustomDataSourceDefinition customDef = this.customDataSourceFactory.getDefinitionByServiceClass(cds.getServiceClass());
            customDef.setDefaultValues(cds, false);
            formObject.setCustomProperties(customDef.getEditablePropertyDefinitions());
            formObject.setCustomDatasourceLabel(customDef.getLabelName());
            context.getFlowScope().put(TYPE, (Object)customDef.getName());
        }
        return this.success();
    }

    public String getTypeByFormObjectByType(String formObjectType) {
        if (JasperServerConstImpl.getJNDIDatasourceType().equals(formObjectType)) {
            return DATASOURCE_JNDI;
        }
        if (JasperServerConstImpl.getJDBCDatasourceType().equals(formObjectType)) {
            return DATASOURCE_JDBC;
        }
        if (JasperServerConstImpl.getBeanDatasourceType().equals(formObjectType)) {
            return DATASOURCE_BEAN;
        }
        return formObjectType;
    }

    public Event prepareChooseType(RequestContext context) throws Exception {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        for (CustomDataSourceDefinition cds : this.customDataSourceFactory.getDefinitions()) {
            typeMap.put(cds.getName(), this.messages.getMessage(cds.getLabelName(), null, LocaleContextHolder.getLocale()));
        }
        context.getRequestScope().put("allTypes", typeMap);
        return this.success();
    }

    public Event saveDatasource(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        if (wrapper.isStandAloneMode()) {
            ReportDataSource ds;
            if (wrapper.getType() != null && (ds = wrapper.getReportDataSource()).getName() != null) {
                try {
                    this.repository.saveResource(null, (Resource)ds);
                }
                catch (JSDuplicateResourceException e) {
                    this.getFormErrors(context).rejectValue("reportDataSource.name", "ReportDataSourceValidator.error.duplicate");
                    return this.error();
                }
            }
            if (!wrapper.isEditMode()) {
                context.getExternalContext().getSessionMap().put("repositorySystemConfirm", (Object)this.messages.getMessage("resource.file.fileAdded", (Object[])new String[]{wrapper.getReportDataSource().getName(), wrapper.getReportDataSource().getParentFolder()}, LocaleContextHolder.getLocale()));
            }
            return this.yes();
        }
        return this.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event testJdbcDataSource(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        JdbcReportDataSource ds = (JdbcReportDataSource)wrapper.getReportDataSource();
        Connection conn = null;
        try {
            Class.forName(ds.getDriverClass());
            conn = DriverManager.getConnection(ds.getConnectionUrl(), ds.getUsername(), ds.getPassword());
            context.getRequestScope().put("connection.test", (Object)(conn != null ? 1 : 0));
        }
        catch (Exception e) {
            context.getRequestScope().put("connection.test", (Object)Boolean.FALSE);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return this.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event testJndiDataSource(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)wrapper.getReportDataSource();
        Connection conn = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource dataSource = (DataSource)ctx.lookup("java:comp/env/" + ds.getJndiName());
            conn = dataSource.getConnection();
            context.getRequestScope().put("connection.test", (Object)(conn != null ? 1 : 0));
        }
        catch (Exception e) {
            context.getRequestScope().put("connection.test", (Object)Boolean.FALSE);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return this.success();
    }

    public Event testBeanDataSource(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        BeanReportDataSource ds = (BeanReportDataSource)wrapper.getReportDataSource();
        try {
            Object bean = this.ctx.getBean(ds.getBeanName());
            if (bean == null) {
                context.getRequestScope().put("connection.test", (Object)Boolean.FALSE);
                return this.success();
            }
            if (ds.getBeanMethod() == null) {
                context.getRequestScope().put("connection.test", (Object)(bean instanceof ReportDataSourceService));
            } else {
                try {
                    Method serviceMethod = bean.getClass().getMethod(ds.getBeanMethod(), null);
                    Object obj = serviceMethod.invoke(bean, null);
                    context.getRequestScope().put("connection.test", (Object)(obj != null ? 1 : 0));
                }
                catch (SecurityException e) {
                    context.getRequestScope().put("connection.test", (Object)Boolean.FALSE);
                }
            }
        }
        catch (Exception e) {
            context.getRequestScope().put("connection.test", (Object)Boolean.FALSE);
        }
        return this.success();
    }

    public Event validateDataSource(RequestContext context) throws Exception {
        Errors errors = this.getFormErrors(context);
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        this.getValidator().validate((Object)wrapper, errors);
        List fieldErrors = errors.getFieldErrors();
        if (fieldErrors != null && !fieldErrors.isEmpty()) {
            FieldError error = (FieldError)fieldErrors.get(0);
            String field = error.getField();
            if ("source".equals(field) || "selectedUri".equals(field)) {
                return this.result("chooseSource");
            }
            if (TYPE.equals(field)) {
                return this.result("chooseType");
            }
            if (JasperServerConstImpl.getJDBCDatasourceType().equals(wrapper.getType())) {
                return this.result("jdbcPropsForm");
            }
            if (JasperServerConstImpl.getJNDIDatasourceType().equals(wrapper.getType())) {
                return this.result("jndiPropsForm");
            }
            if (JasperServerConstImpl.getBeanDatasourceType().equals(wrapper.getType())) {
                return this.result("beanPropsForm");
            }
            return this.result("customPropsForm");
        }
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        ReportDataSourceWrapper formObject = new ReportDataSourceWrapper();
        String resourceUri = context.getRequestParameters().get(DATASOURCEURI_PARAM);
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            Resource resource = this.repository.getResource(null, resourceUri);
            if (resource == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            formObject.setMode((byte)2);
            ReportDataSource dataSource = (ReportDataSource)resource;
            formObject.setType(this.getDataSourceMappings().getIdForClass(dataSource.getClass()));
            if (JasperServerConstImpl.getJNDIDatasourceType().equals(this.getDataSourceMappings().getIdForClass(dataSource.getClass()))) {
                context.getFlowScope().put(TYPE, (Object)DATASOURCE_JNDI);
            } else if (JasperServerConstImpl.getBeanDatasourceType().equals(this.getDataSourceMappings().getIdForClass(dataSource.getClass()))) {
                context.getFlowScope().put(TYPE, (Object)DATASOURCE_BEAN);
            }
            formObject.setReportDataSource(dataSource);
        }
        if (formObject.getReportDataSource() == null) {
            ReportDataSource source;
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            String type = context.getExternalContext().getRequestParameterMap().get(TYPE);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get(PARENT_FOLDER_URI);
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            if (parentFolder == null || parentFolder.trim().length() == 0) {
                parentFolder = "/";
            }
            formObject.setMode((byte)1);
            formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
            if (type == null) {
                source = this.newReportDataSource(JasperServerConstImpl.getJDBCDatasourceType());
                formObject.setType(JasperServerConstImpl.getJDBCDatasourceType());
            } else if (type.equals(DATASOURCE_JDBC)) {
                source = this.newReportDataSource(JasperServerConstImpl.getJDBCDatasourceType());
                formObject.setType(JasperServerConstImpl.getJNDIDatasourceType());
            } else if (type.equals(DATASOURCE_JNDI)) {
                source = this.newReportDataSource(JasperServerConstImpl.getJNDIDatasourceType());
                formObject.setType(JasperServerConstImpl.getJNDIDatasourceType());
            } else if (type.equals(DATASOURCE_BEAN)) {
                source = this.newReportDataSource(JasperServerConstImpl.getBeanDatasourceType());
                formObject.setType(JasperServerConstImpl.getBeanDatasourceType());
            } else {
                source = this.newReportDataSource(type);
                formObject.setType(type);
            }
            source.setParentFolder(parentFolder);
            source.setVersion(-1);
            formObject.setReportDataSource(source);
        }
        return formObject;
    }

    private ReportDataSource newReportDataSource(String dsType) {
        CustomDataSourceDefinition cdsd;
        if (this.customDataSourceFactory != null && (cdsd = this.customDataSourceFactory.getDefinitionByName(dsType)) != null) {
            CustomReportDataSource cds = (CustomReportDataSource)this.getDataSourceMappings().newResource(null, "Custom Data Source");
            cds.setServiceClass(cdsd.getServiceClassName());
            HashMap propMap = new HashMap();
            cds.setPropertyMap(propMap);
            for (Map pd : cdsd.getPropertyDefinitions()) {
                String name = (String)pd.get("name");
                Object deflt = pd.get("default");
                Object hidden = pd.get("hidden");
                if (Boolean.parseBoolean((String)hidden)) continue;
                propMap.put(name, deflt);
            }
            return cds;
        }
        return (ReportDataSource)this.getDataSourceMappings().newResource(null, dsType);
    }

    private ReportDataSource newReportDataSource(String dsType, ReportDataSource oldDS) {
        ReportDataSource newDS = this.newReportDataSource(dsType);
        newDS.setParentFolder(oldDS.getParentFolder());
        newDS.setName(oldDS.getName());
        newDS.setLabel(oldDS.getLabel());
        newDS.setDescription(oldDS.getDescription());
        newDS.setVersion(oldDS.getVersion());
        if (oldDS instanceof JdbcReportDataSource) {
            JdbcReportDataSource oldJdbc = (JdbcReportDataSource)oldDS;
            JdbcReportDataSource newJdbc = (JdbcReportDataSource)newDS;
            newJdbc.setDriverClass(oldJdbc.getDriverClass());
            newJdbc.setConnectionUrl(oldJdbc.getConnectionUrl());
            newJdbc.setPassword(oldJdbc.getPassword());
            newJdbc.setTimezone(oldJdbc.getTimezone());
            newJdbc.setUsername(oldJdbc.getUsername());
        } else if (oldDS instanceof JndiJdbcReportDataSource) {
            JndiJdbcReportDataSource oldJndi = (JndiJdbcReportDataSource)oldDS;
            JndiJdbcReportDataSource newJndi = (JndiJdbcReportDataSource)newDS;
            newJndi.setJndiName(oldJndi.getJndiName());
            newJndi.setTimezone(oldJndi.getTimezone());
        } else if (oldDS instanceof BeanReportDataSource) {
            BeanReportDataSource oldBean = (BeanReportDataSource)oldDS;
            BeanReportDataSource newBean = (BeanReportDataSource)newDS;
            newBean.setBeanMethod(oldBean.getBeanMethod());
            newBean.setBeanName(oldBean.getBeanName());
        }
        return newDS;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public ResourceFactory getDataSourceMappings() {
        return this.dataSourceMappings;
    }

    public void setDataSourceMappings(ResourceFactory dataSourceMappings) {
        this.dataSourceMappings = dataSourceMappings;
    }

    public JdkTimeZonesList getTimezones() {
        return this.timezones;
    }

    public void setTimezones(JdkTimeZonesList timezones) {
        this.timezones = timezones;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public CustomReportDataSourceServiceFactory getCustomDataSourceFactory() {
        return this.customDataSourceFactory;
    }

    public void setCustomDataSourceFactory(CustomReportDataSourceServiceFactory customDataSourceFactory) {
        this.customDataSourceFactory = customDataSourceFactory;
    }

    public String getQueryLanguageFlowAttribute() {
        return this.queryLanguageFlowAttribute;
    }

    public void setQueryLanguageFlowAttribute(String queryLanguageFlowAttribute) {
        this.queryLanguageFlowAttribute = queryLanguageFlowAttribute;
    }

    protected String getQueryLanguage(RequestContext context) {
        return context.getFlowScope().getString(this.getQueryLanguageFlowAttribute());
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }
}

