/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class InputControlLabelResolver {
    private static Pattern LABEL_KEY_PATTERN = Pattern.compile("^\\$R\\{(.+)\\}(.*)$");

    public static String resolve(String key, MessageSource reportMessageSource, MessageSource serverMessageSource) {
        String label = key;
        Matcher m = LABEL_KEY_PATTERN.matcher(key);
        if (m.matches()) {
            String labelKey = m.group(1);
            String labelPostfix = m.group(2);
            boolean messageFound = false;
            if (reportMessageSource != null) {
                try {
                    label = reportMessageSource.getMessage(labelKey, null, LocaleContextHolder.getLocale());
                    messageFound = true;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (serverMessageSource != null && !messageFound) {
                try {
                    label = serverMessageSource.getMessage(labelKey, null, LocaleContextHolder.getLocale());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            label = label + labelPostfix;
        }
        return label;
    }
}

