/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.common;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.war.common.RoleAccessUris;
import com.jaspersoft.jasperserver.war.common.UriDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleAccessUrisResolver {
    private List<RoleAccessUris> roleAccessUrisList;

    public void setRoleAccessUrisList(List<RoleAccessUris> roleAccessUrisList) {
        this.roleAccessUrisList = roleAccessUrisList;
    }

    public List<UriDescriptor> getRestrictedUris() {
        ArrayList<UriDescriptor> restrictedUris = new ArrayList<UriDescriptor>();
        for (RoleAccessUris roleAccessUris : this.roleAccessUrisList) {
            if (this.hasRole(roleAccessUris)) continue;
            restrictedUris.addAll(roleAccessUris.getUris());
        }
        return restrictedUris;
    }

    public String getAbsoluteUri(String path) {
        return path;
    }

    protected boolean hasRole(RoleAccessUris roleAccessUris) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Set roles = ((User)authentication.getPrincipal()).getRoles();
        for (Role role : roles) {
            if (!role.getRoleName().equals(roleAccessUris.getRoleName())) continue;
            return true;
        }
        return false;
    }
}

