/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.model.JSONObject;
import com.jaspersoft.jasperserver.war.model.TreeDataFilter;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import com.jaspersoft.jasperserver.war.model.impl.TreeNodeImpl;
import com.jaspersoft.jasperserver.war.themes.ThemeService;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.springframework.context.i18n.LocaleContextHolder;

public class RepositoryExplorerTreeDataProviderImpl
implements TreeDataProvider {
    private RepositoryService repositoryService;
    private RepositorySecurityChecker repositoryServiceSecurityChecker;
    private ObjectPermissionService objectPermissionService;
    private ThemeService themeService;
    private TreeDataFilter filter;

    public List getChildren(ExecutionContext executionContext, String parentUri, int depth) {
        TreeNode n = this.getNode(executionContext, parentUri, depth + 1);
        if (n != null) {
            return n.getChildren();
        }
        return null;
    }

    public TreeNode getNode(ExecutionContext executionContext, String uri, int depth) {
        Resource resource = this.repositoryService.getResource(executionContext, uri);
        if (resource != null) {
            return this.createNode(resource, false);
        }
        Folder folder = this.repositoryService.getFolder(executionContext, uri);
        if (folder != null) {
            TreeNode node = this.createNode((Resource)folder, true);
            if (depth > 0) {
                this.processFolder(node, depth - 1);
            }
            return node;
        }
        return null;
    }

    protected TreeNode createNode(Resource resource, boolean isFolder) {
        Properties extraProperty = new Properties();
        extraProperty.isWritable = this.repositoryServiceSecurityChecker.isEditable(resource);
        extraProperty.isRemovable = this.repositoryServiceSecurityChecker.isRemovable(resource);
        extraProperty.isAdministrable = this.objectPermissionService.isObjectAdministrable(null, (Object)resource);
        if (isFolder) {
            extraProperty.desc = resource.getDescription();
            extraProperty.date = resource.getCreationDate();
            extraProperty = this.addThemeProperties(resource, extraProperty);
            return new TreeNodeImpl(this, resource.getName(), resource.getLabel(), resource.getResourceType(), resource.getURIString(), 1, extraProperty);
        }
        return new TreeNodeImpl((TreeDataProvider)this, resource.getName(), resource.getLabel(), resource.getResourceType(), resource.getURIString(), extraProperty);
    }

    protected Properties addThemeProperties(Resource resource, Properties extraProperty) {
        String uri = resource.getURIString();
        if (this.themeService.isThemeFolder(null, uri)) {
            extraProperty.isThemeFolder = true;
            if (this.themeService.isActiveThemeFolder(null, uri)) {
                extraProperty.isActiveThemeFolder = true;
            }
        } else if (this.themeService.isThemeRootFolder(null, resource.getURIString())) {
            extraProperty.isThemeRootFolder = true;
        }
        return extraProperty;
    }

    private void processFolder(TreeNode folder, int depth) {
        TreeNode n;
        String folderURI = folder.getUriString();
        FilterCriteria criteria = FilterCriteria.createFilter();
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
        List folders = this.repositoryService.getSubFolders(null, folderURI);
        List resources = this.repositoryService.loadResourcesList(null, criteria);
        if (folders != null) {
            for (Folder f : folders) {
                n = this.createNode((Resource)f, true);
                if (this.filter != null && !this.filter.filter(n)) continue;
                folder.getChildren().add(n);
                if (depth <= 0) continue;
                this.processFolder(n, depth - 1);
            }
        }
        if (resources != null) {
            for (Resource r : resources) {
                n = this.createNode(r, false);
                if (this.filter != null && !this.filter.filter(n)) continue;
                folder.getChildren().add(n);
            }
        }
    }

    public TreeDataFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TreeDataFilter filter) {
        this.filter = filter;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public RepositorySecurityChecker getRepositoryServiceSecurityChecker() {
        return this.repositoryServiceSecurityChecker;
    }

    public void setRepositoryServiceSecurityChecker(RepositorySecurityChecker repositoryServiceSecurityChecker) {
        this.repositoryServiceSecurityChecker = repositoryServiceSecurityChecker;
    }

    public ObjectPermissionService getObjectPermissionService() {
        return this.objectPermissionService;
    }

    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    public ThemeService getThemeService() {
        return this.themeService;
    }

    public void setThemeService(ThemeService themeService) {
        this.themeService = themeService;
    }

    private static class Properties
    implements JSONObject {
        public String desc = null;
        public Date date = null;
        public boolean isWritable = false;
        public boolean isRemovable = false;
        public boolean isAdministrable = false;
        public boolean isThemeFolder = false;
        public boolean isActiveThemeFolder = false;
        public boolean isThemeRootFolder = false;

        private Properties() {
        }

        public String toJSONString() {
            org.json.JSONObject o = new org.json.JSONObject();
            try {
                o.put("isWritable", this.isWritable);
                o.put("isRemovable", this.isRemovable);
                o.put("isAdministrable", this.isAdministrable);
                if (this.desc != null) {
                    o.put("desc", (Object)this.desc);
                }
                if (this.date != null) {
                    DateFormat formatter = DateFormat.getDateTimeInstance(3, 3, LocaleContextHolder.getLocale());
                    o.put("date", (Object)formatter.format(this.date));
                }
                if (this.isThemeFolder) {
                    o.put("isThemeFolder", this.isThemeFolder);
                }
                if (this.isActiveThemeFolder) {
                    o.put("isActiveThemeFolder", this.isActiveThemeFolder);
                }
                if (this.isThemeRootFolder) {
                    o.put("isThemeRootFolder", this.isThemeRootFolder);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return o.toString();
        }
    }
}

