/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.FileResourceWrapper;
import com.jaspersoft.jasperserver.war.dto.OlapClientConnectionWrapper;
import com.jaspersoft.jasperserver.war.dto.ReportUnitWrapper;
import java.util.List;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class FileResourceValidator
implements Validator {
    private RepositoryService repository;
    private RepositorySecurityChecker repositoryServiceSecurityChecker;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setRepositoryServiceSecurityChecker(RepositorySecurityChecker repositoryServiceSecurityChecker) {
        this.repositoryServiceSecurityChecker = repositoryServiceSecurityChecker;
    }

    public boolean supports(Class clazz) {
        return FileResourceWrapper.class.isAssignableFrom(clazz);
    }

    public void validate(Object arg0, Errors arg1) {
    }

    public void validateNaming(FileResourceWrapper wrapper, Errors errors) {
        if (wrapper.getFileResource().getLabel() == null || wrapper.getFileResource().getLabel().trim().length() == 0) {
            errors.rejectValue("fileResource.label", "FileResourceValidator.error.not.empty");
        } else if (wrapper.getFileResource().getLabel().length() > 100) {
            errors.rejectValue("fileResource.label", "FileResourceValidator.error.too.long");
        } else if (!JasperServerUtil.regExValidateLabel(wrapper.getFileResource().getLabel())) {
            errors.rejectValue("fileResource.label", "FileResourceValidator.error.invalid.chars");
        }
        if (wrapper.getFileResource().getName() == null || wrapper.getFileResource().getName().trim().length() == 0) {
            errors.rejectValue("fileResource.name", "FileResourceValidator.error.not.empty");
        } else {
            Object parentObject;
            String name;
            wrapper.getFileResource().setName(wrapper.getFileResource().getName().trim());
            if ("prop".equals(wrapper.getFileResource().getFileType()) && !(name = wrapper.getFileResource().getName()).endsWith(".properties")) {
                wrapper.getFileResource().setName(name + ".properties");
            }
            if (wrapper.getFileResource().getName().length() > 100) {
                errors.rejectValue("fileResource.name", "FileResourceValidator.error.too.long");
            } else if (!JasperServerUtil.regExValidateName(wrapper.getFileResource().getName())) {
                errors.rejectValue("fileResource.name", "FileResourceValidator.error.invalid.chars");
            } else if (wrapper.isSubflowMode() && (parentObject = wrapper.getParentFlowObject()) != null && ReportUnitWrapper.class.isAssignableFrom(parentObject.getClass())) {
                List controls;
                ReportUnitWrapper parent = (ReportUnitWrapper)parentObject;
                List resources = parent.getReportUnit().getResources();
                if (resources != null && !resources.isEmpty()) {
                    for (int i = 0; i < resources.size(); ++i) {
                        ResourceReference resRef = (ResourceReference)resources.get(i);
                        Resource res = null;
                        if (!resRef.isLocal()) continue;
                        res = resRef.getLocalResource();
                        if (!wrapper.getFileResource().getName().equals(res.getName())) continue;
                        errors.rejectValue("fileResource.name", "FileResourceValidator.error.duplicate");
                        break;
                    }
                }
                if ((controls = parent.getReportUnit().getInputControls()) != null && !controls.isEmpty()) {
                    for (int i = 0; i < controls.size(); ++i) {
                        ResourceReference resRef = (ResourceReference)controls.get(i);
                        if (!resRef.isLocal()) continue;
                        Resource res = resRef.getLocalResource();
                        if (!wrapper.getFileResource().getName().equals(res.getName())) continue;
                        errors.rejectValue("fileResource.name", "FileResourceValidator.error.duplicate.inputControl");
                        break;
                    }
                }
            }
            if (wrapper.getFileResource().getCreationDate() == null) {
                if (wrapper.getParentFlowObject() instanceof OlapClientConnectionWrapper) {
                    parentObject = (OlapClientConnectionWrapper)wrapper.getParentFlowObject();
                    if (wrapper.getFileResource().getURIString().equals(((OlapClientConnectionWrapper)parentObject).getParentFolder() + "/" + ((OlapClientConnectionWrapper)parentObject).getConnectionName())) {
                        errors.rejectValue("fileResource.name", "FileResourceValidator.error.duplicate");
                    }
                    if (wrapper.getFileResource().getFileType().equals("accessGrantSchema") && (wrapper.getFileResource().getURIString().equals(((OlapClientConnectionWrapper)wrapper.getParentFlowObject()).getSchemaUri()) || wrapper.getFileResource().getURIString().equals(((OlapClientConnectionWrapper)wrapper.getParentFlowObject()).getDatasourceUri()))) {
                        errors.rejectValue("fileResource.name", "FileResourceValidator.error.duplicate");
                    }
                }
                if (this.repository.repositoryPathExists(null, wrapper.getFileResource().getURIString())) {
                    errors.rejectValue("fileResource.name", "FileResourceValidator.error.duplicate");
                }
            }
            if ("prop".equals(wrapper.getFileResource().getFileType()) && !(name = wrapper.getFileResource().getName()).endsWith(".properties")) {
                errors.rejectValue("fileResource.name", "FileResourceValidator.error.resourceBundle");
            }
        }
        if (wrapper.getFileResource().getDescription() != null && wrapper.getFileResource().getDescription().length() > 250) {
            errors.rejectValue("fileResource.description", "FileResourceValidator.error.too.long");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateUpload(FileResourceWrapper wrapper, Errors errors) {
        if (!wrapper.isSubflowMode()) {
            if (!(wrapper.isLocated() || wrapper.getNewData() != null && wrapper.getNewData().length != 0)) {
                errors.rejectValue("newData", "FileResourceValidator.error.not.uploaded");
            }
        } else {
            if (wrapper.getSource() == null) {
                errors.rejectValue("source", "FileResourceValidator.error.no.file");
                return;
            }
            if (wrapper.isLocated()) {
                return;
            }
            if (wrapper.getSource().equals("NONE")) {
                return;
            }
            if (wrapper.getSource().equals("FILE_SYSTEM")) {
                if (wrapper.getFileResource().getData() == null || wrapper.getFileResource().getData().length == 0) {
                    errors.rejectValue("newData", "FileResourceValidator.error.not.uploaded");
                }
            } else {
                String newUri = wrapper.getNewUri();
                if (newUri == null || newUri.trim().length() == 0) {
                    errors.rejectValue("newUri", "FileResourceValidator.error.no.folder");
                } else {
                    Resource resource = null;
                    try {
                        resource = this.repository.getResource(null, newUri);
                    }
                    finally {
                        if (resource == null) {
                            errors.rejectValue("newUri", "FileResourceValidator.error.not.exist");
                        }
                    }
                }
            }
        }
    }

    public void validateFolderURI(FileResourceWrapper wrapper, Errors errors) {
        String folderURI = wrapper.getFileResource().getParentFolder();
        if (!this.getRepository().folderExists(null, folderURI)) {
            errors.rejectValue("fileResource.parentFolder", "FileResourceValidator.error.folder.inexistent", new Object[]{folderURI}, "");
        } else if (SecurityContextHolder.getContext().getAuthentication() != null && !this.repositoryServiceSecurityChecker.isEditable((Resource)this.getRepository().getFolder(null, folderURI))) {
            errors.rejectValue("fileResource.parentFolder", "FileResourceValidator.error.folder.notwriteable", new Object[]{folderURI}, "");
        }
    }

    public void validateAll(FileResourceWrapper wrapper, Errors errors) {
        this.validateNaming(wrapper, errors);
        this.validateUpload(wrapper, errors);
        this.validateFolderURI(wrapper, errors);
    }
}

