/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.ant.AnnotationConfigurationTask;
import org.hibernate.tool.ant.ConfigurationTask;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.GenericExporterTask;
import org.hibernate.tool.ant.Hbm2CfgXmlExporterTask;
import org.hibernate.tool.ant.Hbm2DAOExporterTask;
import org.hibernate.tool.ant.Hbm2DDLExporterTask;
import org.hibernate.tool.ant.Hbm2DocExporterTask;
import org.hibernate.tool.ant.Hbm2HbmXmlExporterTask;
import org.hibernate.tool.ant.Hbm2JavaExporterTask;
import org.hibernate.tool.ant.JDBCConfigurationTask;

public class HibernateToolTask
extends Task {
    ConfigurationTask configurationTask;
    private File destDir;
    private List generators = new ArrayList();
    private Path classPath;
    private Path templatePath;
    private Properties properties = new Properties();

    private void checkConfiguration() {
        if (this.configurationTask != null) {
            throw new BuildException("Only a single configuration is allowed.");
        }
    }

    public ConfigurationTask createConfiguration() {
        this.checkConfiguration();
        this.configurationTask = new ConfigurationTask();
        return this.configurationTask;
    }

    public JDBCConfigurationTask createJDBCConfiguration() {
        this.checkConfiguration();
        this.configurationTask = new JDBCConfigurationTask();
        return (JDBCConfigurationTask)this.configurationTask;
    }

    public AnnotationConfigurationTask createAnnotationConfiguration() {
        this.checkConfiguration();
        this.configurationTask = new AnnotationConfigurationTask();
        return (AnnotationConfigurationTask)this.configurationTask;
    }

    public ExporterTask createHbm2DDL() {
        Hbm2DDLExporterTask generator = new Hbm2DDLExporterTask(this);
        this.generators.add(generator);
        return generator;
    }

    public ExporterTask createHbmTemplate() {
        GenericExporterTask generator = new GenericExporterTask(this);
        this.generators.add(generator);
        return generator;
    }

    public ExporterTask createHbm2CfgXml() {
        Hbm2CfgXmlExporterTask generator = new Hbm2CfgXmlExporterTask(this);
        this.generators.add(generator);
        return generator;
    }

    public ExporterTask createHbm2Java() {
        Hbm2JavaExporterTask generator = new Hbm2JavaExporterTask(this);
        this.generators.add(generator);
        return generator;
    }

    public ExporterTask createHbm2HbmXml() {
        Hbm2HbmXmlExporterTask generator = new Hbm2HbmXmlExporterTask(this);
        this.generators.add(generator);
        return generator;
    }

    public ExporterTask createHbm2Doc() {
        Hbm2DocExporterTask generator = new Hbm2DocExporterTask(this);
        this.generators.add(generator);
        return generator;
    }

    public ExporterTask createHbm2DAO() {
        Hbm2DAOExporterTask generator = new Hbm2DAOExporterTask(this);
        this.generators.add(generator);
        return generator;
    }

    public void setClasspath(Path s) {
        this.classPath = s;
    }

    public Path createClasspath() {
        this.classPath = new Path(this.getProject());
        return this.classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.log("Executing Hibernate Tool with a " + this.configurationTask.getDescription());
        this.validateParameters();
        Iterator iterator = this.generators.iterator();
        AntClassLoader loader = this.getProject().createClassLoader(this.classPath);
        try {
            loader.setParent(((Object)((Object)this)).getClass().getClassLoader());
            loader.setThreadContextLoader();
            int count = 1;
            while (iterator.hasNext()) {
                ExporterTask generatorTask = (ExporterTask)iterator.next();
                this.log(count++ + ". task: " + generatorTask.getName());
                generatorTask.execute();
            }
        }
        finally {
            if (loader != null) {
                loader.resetThreadContextLoader();
                loader.cleanup();
            }
        }
    }

    private void validateParameters() {
        Iterator iterator = this.generators.iterator();
        while (iterator.hasNext()) {
            ExporterTask generatorTask = (ExporterTask)iterator.next();
            generatorTask.validateParameters();
        }
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public Configuration getConfiguration() {
        return this.configurationTask.getConfiguration();
    }

    public void setTemplatePath(Path path) {
        this.templatePath = path;
    }

    public Path getTemplatePath() {
        if (this.templatePath == null) {
            this.templatePath = new Path(this.getProject());
        }
        return this.templatePath;
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.getConfiguration().getProperties());
        p.putAll((Map<?, ?>)this.properties);
        return p;
    }

    public void addConfiguredPropertySet(PropertySet ps) {
        this.properties.putAll((Map<?, ?>)ps.getProperties());
    }

    public void addConfiguredProperty(Environment.Variable property) {
        this.properties.put(property.getKey(), property.getValue());
    }
}

