/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Component;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ConfigurationNavigator;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.ImportProducer;
import org.hibernate.tool.hbm2x.VelocityProducer;
import org.hibernate.tool.hbm2x.pojo.ComponentPOJOClass;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class GenericExporter
extends AbstractExporter {
    String templateName;
    private String filePattern;
    private String exporterClassName;

    public GenericExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    public GenericExporter() {
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void start() {
        if (this.exporterClassName != null) {
            try {
                Class exporterClass = ReflectHelper.classForName((String)this.exporterClassName);
                Exporter exporter = (Exporter)exporterClass.newInstance();
                Properties p = this.getProperties();
                if (this.getTemplateName() != null) {
                    p.put("hibernatetool.template_name", this.getTemplateName());
                }
                if (this.filePattern != null) {
                    p.put("hibernatetool.file_pattern", this.filePattern);
                }
                exporter.setProperties(this.getProperties());
                exporter.setArtifactCollector(this.getArtifactCollector());
                exporter.setConfiguration(this.getConfiguration());
                exporter.setOutputDirectory(this.getOutputDirectory());
                exporter.setTemplatePath(this.getTemplatePaths());
                exporter.start();
            }
            catch (Exception e) {
                throw new ExporterException("Could not instantiate exporter of class " + this.exporterClassName, e);
            }
        } else {
            super.start();
        }
    }

    public void doStart() {
        if (this.filePattern == null) {
            throw new ExporterException("File pattern not set on GenericExporter");
        }
        if (this.templateName == null) {
            throw new ExporterException("Template pattern not set on GenericExporter");
        }
        if (this.filePattern.indexOf("{class-name}") >= 0) {
            this.exportClasses();
        } else {
            VelocityProducer producer = new VelocityProducer(this.getTemplateHelper(), this.getArtifactCollector());
            producer.produce(new HashMap(), this.getTemplateName(), new File(this.getOutputDirectory(), this.filePattern), this.templateName);
        }
    }

    private void exportClasses() {
        HashMap components = new HashMap();
        Iterator iterator = this.getCfg2JavaTool().getPOJOIterator(this.getConfiguration().getClassMappings());
        HashMap additionalContext = new HashMap();
        while (iterator.hasNext()) {
            POJOClass element = (POJOClass)iterator.next();
            ConfigurationNavigator.collectComponents(components, element);
            this.exportPersistentClass(additionalContext, element);
        }
        iterator = components.values().iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            ComponentPOJOClass element = new ComponentPOJOClass(component, this.getCfg2JavaTool());
            this.exportComponent(additionalContext, element);
        }
    }

    protected void exportComponent(Map additionalContext, POJOClass element) {
        this.exportPOJO(additionalContext, element);
    }

    protected void exportPersistentClass(Map additionalContext, POJOClass element) {
        this.exportPOJO(additionalContext, element);
    }

    protected void exportPOJO(Map additionalContext, POJOClass element) {
        ImportProducer producer = new ImportProducer(this.getTemplateHelper(), this.getArtifactCollector(), element);
        additionalContext.put("pojo", element);
        additionalContext.put("clazz", element.getDecoratedObject());
        additionalContext.put("secondclassimports", "$secondpassclassimports");
        String filename = this.resolveFilename(element);
        if (filename.indexOf(36) >= 0) {
            this.log.warn((Object)("Filename for " + element.getDeclarationName() + " contains a $. Innerclass generation is not supported."));
        }
        producer.produce(additionalContext, this.getTemplateName(), new File(this.getOutputDirectory(), filename), this.templateName);
    }

    private String resolveFilename(POJOClass element) {
        String filename = StringHelper.replace((String)this.filePattern, (String)"{class-name}", (String)element.getDeclarationName());
        String packageLocation = StringHelper.replace((String)element.getPackageName(), (String)".", (String)"/");
        if (StringHelper.isEmpty((String)packageLocation)) {
            packageLocation = ".";
        }
        filename = StringHelper.replace((String)filename, (String)"{package-name}", (String)packageLocation);
        return filename;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public void setExporterClassName(String exporterClassName) {
        this.exporterClassName = exporterClassName;
    }
}

