/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.core.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.binding.collection.MapAccessor;
import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;

public class LocalParameterMap
implements ParameterMap,
Serializable {
    private static final DefaultConversionService DEFAULT_CONVERSION_SERVICE = new DefaultConversionService();
    private Map parameters;
    private transient MapAccessor parameterAccessor;
    private transient ConversionService conversionService;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public LocalParameterMap(Map parameters) {
        this(parameters, (ConversionService)DEFAULT_CONVERSION_SERVICE);
    }

    public LocalParameterMap(Map parameters, ConversionService conversionService) {
        this.initParameters(parameters);
        this.conversionService = conversionService;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalParameterMap)) {
            return false;
        }
        LocalParameterMap other = (LocalParameterMap)o;
        return this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }

    public Map asMap() {
        return Collections.unmodifiableMap(this.parameterAccessor.asMap());
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean contains(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    public String get(String parameterName) {
        return this.get(parameterName, (String)null);
    }

    public String get(String parameterName, String defaultValue) {
        if (!this.parameters.containsKey(parameterName)) {
            return defaultValue;
        }
        Object value = this.parameters.get(parameterName);
        if (value.getClass().isArray()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.parameterAccessor.assertKeyValueInstanceOf((Object)parameterName, value, (Class)clazz);
            String[] array = (String[])value;
            if (array.length == 0) {
                return null;
            }
            String first = ((String[])value)[0];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.parameterAccessor.assertKeyValueInstanceOf((Object)parameterName, (Object)first, (Class)clazz2);
            return first;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.parameterAccessor.assertKeyValueInstanceOf((Object)parameterName, value, (Class)clazz);
        return (String)value;
    }

    public String[] getArray(String parameterName) {
        if (!this.parameters.containsKey(parameterName)) {
            return null;
        }
        Object value = this.parameters.get(parameterName);
        if (value.getClass().isArray()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.parameterAccessor.assertKeyValueInstanceOf((Object)parameterName, value, (Class)clazz);
            return (String[])value;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.parameterAccessor.assertKeyValueInstanceOf((Object)parameterName, value, (Class)clazz);
        return new String[]{(String)value};
    }

    public Object[] getArray(String parameterName, Class targetElementType) throws ConversionExecutionException {
        String[] parameters = this.getArray(parameterName);
        return parameters != null ? this.convert(parameters, targetElementType) : null;
    }

    public Object get(String parameterName, Class targetType) throws ConversionExecutionException {
        return this.get(parameterName, targetType, null);
    }

    public Object get(String parameterName, Class targetType, Object defaultValue) throws ConversionExecutionException {
        String parameter;
        if (defaultValue != null) {
            this.assertAssignableTo(targetType, defaultValue.getClass());
        }
        return (parameter = this.get(parameterName)) != null ? this.convert(parameter, targetType) : defaultValue;
    }

    public String getRequired(String parameterName) throws IllegalArgumentException {
        this.parameterAccessor.assertContainsKey((Object)parameterName);
        return this.get(parameterName);
    }

    public String[] getRequiredArray(String parameterName) throws IllegalArgumentException {
        this.parameterAccessor.assertContainsKey((Object)parameterName);
        return this.getArray(parameterName);
    }

    public Object[] getRequiredArray(String parameterName, Class targetElementType) throws IllegalArgumentException, ConversionExecutionException {
        String[] parameters = this.getRequiredArray(parameterName);
        return this.convert(parameters, targetElementType);
    }

    public Object getRequired(String parameterName, Class targetType) throws IllegalArgumentException, ConversionExecutionException {
        return this.convert(this.getRequired(parameterName), targetType);
    }

    public Number getNumber(String parameterName, Class targetType) throws ConversionExecutionException {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertAssignableTo(clazz, targetType);
        return (Number)this.get(parameterName, targetType);
    }

    public Number getNumber(String parameterName, Class targetType, Number defaultValue) throws ConversionExecutionException {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertAssignableTo(clazz, targetType);
        return (Number)this.get(parameterName, targetType, defaultValue);
    }

    public Number getRequiredNumber(String parameterName, Class targetType) throws IllegalArgumentException, ConversionExecutionException {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertAssignableTo(clazz, targetType);
        return (Number)this.getRequired(parameterName, targetType);
    }

    public Integer getInteger(String parameterName) throws ConversionExecutionException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Integer)this.get(parameterName, clazz);
    }

    public Integer getInteger(String parameterName, Integer defaultValue) throws ConversionExecutionException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Integer)this.get(parameterName, clazz, defaultValue);
    }

    public Integer getRequiredInteger(String parameterName) throws IllegalArgumentException, ConversionExecutionException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Integer)this.getRequired(parameterName, clazz);
    }

    public Long getLong(String parameterName) throws ConversionExecutionException {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Long)this.get(parameterName, clazz);
    }

    public Long getLong(String parameterName, Long defaultValue) throws ConversionExecutionException {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Long)this.get(parameterName, clazz, defaultValue);
    }

    public Long getRequiredLong(String parameterName) throws IllegalArgumentException, ConversionExecutionException {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Long)this.getRequired(parameterName, clazz);
    }

    public Boolean getBoolean(String parameterName) throws ConversionExecutionException {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Boolean)this.get(parameterName, clazz);
    }

    public Boolean getBoolean(String parameterName, Boolean defaultValue) throws ConversionExecutionException {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Boolean)this.get(parameterName, clazz, defaultValue);
    }

    public Boolean getRequiredBoolean(String parameterName) throws IllegalArgumentException, ConversionExecutionException {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Boolean)this.getRequired(parameterName, clazz);
    }

    public MultipartFile getMultipartFile(String parameterName) {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.springframework.web.multipart.MultipartFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MultipartFile)this.parameterAccessor.get((Object)parameterName, (Class)clazz);
    }

    public MultipartFile getRequiredMultipartFile(String parameterName) throws IllegalArgumentException {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.springframework.web.multipart.MultipartFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MultipartFile)this.parameterAccessor.getRequired((Object)parameterName, (Class)clazz);
    }

    public AttributeMap asAttributeMap() {
        return new LocalAttributeMap(this.getMapInternal());
    }

    protected void initParameters(Map parameters) {
        this.parameters = parameters;
        this.parameterAccessor = new MapAccessor(this.parameters);
    }

    protected Map getMapInternal() {
        return this.parameters;
    }

    private Object convert(String parameter, Class targetType) throws ConversionExecutionException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.conversionService.getConversionExecutor((Class)clazz, targetType).execute((Object)parameter);
    }

    private Object[] convert(String[] parameters, Class targetElementType) throws ConversionExecutionException {
        ArrayList<Object> list = new ArrayList<Object>(parameters.length);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ConversionExecutor converter = this.conversionService.getConversionExecutor((Class)clazz, targetElementType);
        int i = 0;
        while (i < parameters.length) {
            list.add(converter.execute((Object)parameters[i]));
            ++i;
        }
        return list.toArray((Object[])Array.newInstance(targetElementType, parameters.length));
    }

    private void assertAssignableTo(Class clazz, Class requiredType) {
        Assert.isTrue((boolean)clazz.isAssignableFrom(requiredType), (String)("The provided required type must be assignable to [" + clazz + "]"));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parameterAccessor = new MapAccessor(this.parameters);
        this.conversionService = DEFAULT_CONVERSION_SERVICE;
    }

    public String toString() {
        return StylerUtils.style((Object)this.parameters);
    }
}

