/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.springframework.util.Assert;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.FlowBuilderContext;
import org.springframework.webflow.engine.builder.FlowBuilderException;

public class FlowAssembler {
    private FlowBuilder flowBuilder;
    private FlowBuilderContext flowBuilderContext;

    public FlowAssembler(FlowBuilder flowBuilder, FlowBuilderContext flowBuilderContext) {
        Assert.notNull((Object)flowBuilder, (String)"A flow builder is required for flow assembly");
        Assert.notNull((Object)flowBuilderContext, (String)"A flow builder context is required for flow assembly");
        this.flowBuilder = flowBuilder;
        this.flowBuilderContext = flowBuilderContext;
    }

    public FlowBuilder getFlowBuilder() {
        return this.flowBuilder;
    }

    public FlowBuilderContext getFlowBuilderContext() {
        return this.flowBuilderContext;
    }

    public Flow assembleFlow() throws FlowBuilderException {
        Flow flow;
        try {
            this.flowBuilder.init(this.flowBuilderContext);
            this.directAssembly();
            flow = this.flowBuilder.getFlow();
            Object var1_2 = null;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.flowBuilder.dispose();
            throw throwable;
        }
        this.flowBuilder.dispose();
        return flow;
    }

    protected void directAssembly() throws FlowBuilderException {
        this.flowBuilder.buildVariables();
        this.flowBuilder.buildInputMapper();
        this.flowBuilder.buildStartActions();
        this.flowBuilder.buildStates();
        this.flowBuilder.buildGlobalTransitions();
        this.flowBuilder.buildEndActions();
        this.flowBuilder.buildOutputMapper();
        this.flowBuilder.buildExceptionHandlers();
    }
}

