/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.validation;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.message.MessageContextErrors;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.validation.DefaultValidationContext;

public class ValidationHelper {
    private static final Log logger;
    private final Object model;
    private final RequestContext requestContext;
    private final String eventId;
    private final String modelName;
    private final ExpressionParser expressionParser;
    private final MessageCodesResolver messageCodesResolver;
    private final MappingResults mappingResults;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.validation.ValidationHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public ValidationHelper(Object model, RequestContext requestContext, String eventId, String modelName, ExpressionParser expressionParser, MessageCodesResolver messageCodesResolver, MappingResults mappingResults) {
        Assert.notNull((Object)model, (String)"The model to validate is required");
        Assert.notNull((Object)requestContext, (String)"The request context for the validator is required");
        this.model = model;
        this.requestContext = requestContext;
        this.eventId = eventId;
        this.modelName = modelName;
        this.expressionParser = expressionParser;
        this.messageCodesResolver = messageCodesResolver;
        this.mappingResults = mappingResults;
    }

    public void validate() {
        this.invokeModelValidationMethod(this.model);
        Object validator = this.getModelValidator();
        if (validator != null) {
            this.invokeModelValidator(this.model, validator);
        }
    }

    private void invokeModelValidationMethod(Object model) {
        this.invokeValidateMethodForCurrentState(model);
        this.invokeDefaultValidateMethod(model);
    }

    private boolean invokeValidateMethodForCurrentState(Object model) {
        String methodName = "validate" + StringUtils.capitalize((String)this.requestContext.getCurrentState().getId());
        Class<?> clazz = model.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.springframework.binding.validation.ValidationContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method validateMethod = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])classArray);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state model validation method '" + methodName + "(ValidationContext)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        Class<?> clazz3 = model.getClass();
        Class[] classArray2 = new Class[1];
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.springframework.binding.message.MessageContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz4;
        validateMethod = ReflectionUtils.findMethod(clazz3, (String)methodName, (Class[])classArray2);
        if (validateMethod != null) {
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{this.requestContext.getMessageContext()});
            return true;
        }
        Class<?> clazz5 = model.getClass();
        Class[] classArray3 = new Class[1];
        Class<?> clazz6 = class$3;
        if (clazz6 == null) {
            try {
                clazz6 = class$3 = Class.forName("org.springframework.validation.Errors");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[0] = clazz6;
        validateMethod = ReflectionUtils.findMethod(clazz5, (String)methodName, (Class[])classArray3);
        if (validateMethod != null) {
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state model validation method '" + methodName + "(Errors)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{errors});
            return true;
        }
        return false;
    }

    private boolean invokeDefaultValidateMethod(Object model) {
        Class<?> clazz = model.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.springframework.binding.validation.ValidationContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method validateMethod = ReflectionUtils.findMethod(clazz, (String)"validate", (Class[])classArray);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking default model validation method 'validate(ValidationContext)'");
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        Class<?> clazz3 = model.getClass();
        Class[] classArray2 = new Class[1];
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.springframework.validation.Errors");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz4;
        validateMethod = ReflectionUtils.findMethod(clazz3, (String)"validate", (Class[])classArray2);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking default model validation method 'validate(Errors)'");
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{errors});
            return true;
        }
        return false;
    }

    private Object getModelValidator() {
        String validatorName;
        ApplicationContext beanFactory = this.requestContext.getActiveFlow().getApplicationContext();
        if (beanFactory != null && StringUtils.hasText((String)this.modelName) && beanFactory.containsBean(validatorName = String.valueOf(this.modelName) + "Validator")) {
            return beanFactory.getBean(validatorName);
        }
        return null;
    }

    private void invokeModelValidator(Object model, Object validator) {
        this.invokeValidatorValidateMethodForCurrentState(model, validator);
        this.invokeValidatorDefaultValidateMethod(model, validator);
    }

    private boolean invokeValidatorValidateMethodForCurrentState(Object model, Object validator) {
        String methodName = "validate" + StringUtils.capitalize((String)this.requestContext.getCurrentState().getId());
        Class<?> clazz = validator.getClass();
        Class[] classArray = new Class[2];
        classArray[0] = model.getClass();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.springframework.binding.validation.ValidationContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Method validateMethod = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])classArray);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state validator method '" + ClassUtils.getShortName(validator.getClass()) + "." + methodName + "(" + ClassUtils.getShortName(model.getClass()) + ", ValidationContext)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        Class<?> clazz3 = validator.getClass();
        Class[] classArray2 = new Class[2];
        classArray2[0] = model.getClass();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.springframework.validation.Errors");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz4;
        validateMethod = ReflectionUtils.findMethod(clazz3, (String)methodName, (Class[])classArray2);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state validator method '" + ClassUtils.getShortName(validator.getClass()) + "." + methodName + "(" + ClassUtils.getShortName(model.getClass()) + ", Errors)'"));
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, errors});
            return true;
        }
        Class<?> clazz5 = validator.getClass();
        Class[] classArray3 = new Class[2];
        classArray3[0] = model.getClass();
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("org.springframework.binding.message.MessageContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[1] = clazz6;
        validateMethod = ReflectionUtils.findMethod(clazz5, (String)methodName, (Class[])classArray3);
        if (validateMethod != null) {
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, this.requestContext.getMessageContext()});
            return true;
        }
        return false;
    }

    private boolean invokeValidatorDefaultValidateMethod(Object model, Object validator) {
        if (validator instanceof Validator) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking Spring Validator '" + ClassUtils.getShortName(validator.getClass()) + "'"));
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ((Validator)validator).validate(model, (Errors)errors);
            return true;
        }
        Class<?> clazz = validator.getClass();
        Class[] classArray = new Class[2];
        classArray[0] = model.getClass();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.springframework.binding.validation.ValidationContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Method validateMethod = ReflectionUtils.findMethod(clazz, (String)"validate", (Class[])classArray);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking default validator method '" + ClassUtils.getShortName(validator.getClass()) + ".validate(" + ClassUtils.getShortName(model.getClass()) + ", ValidationContext)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        Class<?> clazz3 = validator.getClass();
        Class[] classArray2 = new Class[2];
        classArray2[0] = model.getClass();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.springframework.validation.Errors");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz4;
        validateMethod = ReflectionUtils.findMethod(clazz3, (String)"validate", (Class[])classArray2);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking default validator method '" + ClassUtils.getShortName(validator.getClass()) + ".validate(" + ClassUtils.getShortName(model.getClass()) + ", Errors)'"));
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, errors});
            return true;
        }
        return false;
    }
}

