/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;

public class AcegiSecurityContextProvider
implements SecurityContextProvider {
    private static final Log log = LogFactory.getLog(AcegiSecurityContextProvider.class);
    private UserDetailsService userDetailsService;
    private UserAuthorityService userAuthorityService;

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public UserAuthorityService getUserAuthorityService() {
        return this.userAuthorityService;
    }

    public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
        this.userAuthorityService = userAuthorityService;
    }

    public String getContextUsername() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        if (authenticationToken == null) {
            return null;
        }
        if (authenticationToken.getPrincipal() instanceof UserDetails) {
            UserDetails contextUserDetails = (UserDetails)authenticationToken.getPrincipal();
            return contextUserDetails.getUsername();
        }
        if (authenticationToken.getPrincipal() instanceof String) {
            return (String)authenticationToken.getPrincipal();
        }
        return null;
    }

    public User getContextUser() {
        String username = this.getContextUsername();
        if (username == null) {
            return null;
        }
        return this.getUserAuthorityService().getUser(null, username);
    }

    public void setAuthenticatedUser(String username) {
        UserDetails userDetails = this.getUserDetailsService().loadUserByUsername(username);
        String quotedUsername = "\"" + username + "\"";
        if (userDetails == null) {
            throw new JSException("jsexception.user.not.found", new Object[]{quotedUsername});
        }
        if (!userDetails.isAccountNonExpired()) {
            throw new JSException("jsexception.user.expired", new Object[]{quotedUsername});
        }
        if (!userDetails.isAccountNonLocked()) {
            throw new JSException("jsexception.user.locked", new Object[]{quotedUsername});
        }
        if (!userDetails.isCredentialsNonExpired()) {
            throw new JSException("jsexception.user.credentials.are.expired", new Object[]{quotedUsername});
        }
        if (!userDetails.isEnabled()) {
            throw new JSException("jsexception.user.disabled", new Object[]{quotedUsername});
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting user " + username + " as authenticated"));
        }
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)userDetails.getPassword(), userDetails.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
    }

    public void revertAuthenticatedUser() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }
}

