/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.Output;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportOutput;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.MemoryDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public class HtmlReportOutput
implements Output {
    private static final Log log = LogFactory.getLog(HtmlReportOutput.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReportOutput getOutput(EngineService engineService, ExecutionContext executionContext, String reportUnitURI, DataContainer htmlData, JRHyperlinkProducerFactory hyperlinkProducerFactory, RepositoryService repositoryService, JasperPrint jasperPrint, String baseFilename, Locale locale, String characterEncoding) throws JobExecutionException {
        try {
            String filename = baseFilename + ".html";
            String childrenFolderName = repositoryService.getChildrenFolderName(filename);
            JRHtmlExporter exporter = new JRHtmlExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)characterEncoding);
            boolean close = true;
            OutputStream htmlDataOut = htmlData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)htmlDataOut);
                HashMap images = new HashMap();
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, images);
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)(childrenFolderName + '/'));
                if (hyperlinkProducerFactory != null) {
                    exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)hyperlinkProducerFactory);
                }
                exporter.exportReport();
                close = false;
                htmlDataOut.close();
                ReportOutput htmlOutput = new ReportOutput(htmlData, "html", filename);
                for (Map.Entry imageEntry : images.entrySet()) {
                    String imageName = (String)imageEntry.getKey();
                    byte[] imageData = (byte[])imageEntry.getValue();
                    MemoryDataContainer imageDataContainer = new MemoryDataContainer(imageData);
                    ReportOutput image = new ReportOutput((DataContainer)imageDataContainer, "img", imageName);
                    htmlOutput.addChild(image);
                }
                ReportOutput reportOutput = htmlOutput;
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        htmlDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }
}

