/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationDetail;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.domain.Result;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.TrialReportUnitRequest;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import junit.textui.TestRunner;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;

public class EngineServiceImplTest
extends BaseJasperServerTest {
    private ExecutionContext context;

    public EngineServiceImplTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    protected void onSetUp() throws Exception {
        this.context = new ExecutionContextImpl();
    }

    public static void main(String[] args) {
        TestRunner.run(EngineServiceImplTest.class);
    }

    public void testExecute() throws Exception {
        FileResource reportRes = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        this.setCommon((Resource)reportRes, "EmployeesJRXML");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/Employees.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Employees_JDBC");
        unit.setLabel("Employees_JDBC");
        unit.setParentFolder("/reports/samples");
        unit.setDataSourceReference("/datasources/JServerJdbcDS");
        unit.setMainReport(reportRes);
        this.getRepositoryService().saveResource(null, (Resource)unit);
        ReportUnitResult result = (ReportUnitResult)this.getEngineService().execute(this.context, (Request)new ReportUnitRequest("/reports/samples/Employees_JDBC", new HashMap()));
        EngineServiceImplTest.assertNotNull((Object)result);
        JasperPrint jasperPrint = result.getJasperPrint();
        EngineServiceImplTest.assertNotNull((Object)jasperPrint);
        List pages = jasperPrint.getPages();
        EngineServiceImplTest.assertNotNull((Object)pages);
        EngineServiceImplTest.assertTrue((pages.size() > 0 ? 1 : 0) != 0);
        this.getRepositoryService().deleteResource(null, "/reports/samples/Employees_JDBC");
    }

    public void testGetResources() throws Exception {
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryService().getResource(this.context, "/reports/samples/AllAccounts");
        EngineServiceImplTest.assertNotNull((Object)reportUnit);
        ResourceReference reportRef = reportUnit.getMainReport();
        EngineServiceImplTest.assertNotNull((Object)reportRef);
        EngineServiceImplTest.assertTrue((boolean)reportRef.isLocal());
        Resource report = reportRef.getLocalResource();
        EngineServiceImplTest.assertNotNull((Object)report);
        EngineServiceImplTest.assertTrue((boolean)(report instanceof FileResource));
        Resource[] resources = this.getEngineService().getResources(new ResourceReference(report));
        EngineServiceImplTest.assertNotNull((Object)resources);
        EngineServiceImplTest.assertTrue((resources.length == 2 ? 1 : 0) != 0);
    }

    public void testValidate() {
        ReportUnit unit = this.createUnit();
        ValidationResult result = this.getEngineService().validate(null, unit);
        EngineServiceImplTest.assertNotNull((Object)result);
        EngineServiceImplTest.assertEquals((String)"ERROR", (String)result.getValidationState());
        List results = result.getResults();
        EngineServiceImplTest.assertNotNull((Object)results);
        EngineServiceImplTest.assertTrue((results.size() >= 1 ? 1 : 0) != 0);
        ValidationDetail detail = (ValidationDetail)results.get(0);
        EngineServiceImplTest.assertNotNull((Object)detail);
        EngineServiceImplTest.assertEquals((String)"SalesByMonthTrialReport", (String)detail.getName());
        this.addJar(unit);
        result = this.getEngineService().validate(null, unit);
        EngineServiceImplTest.assertNotNull((Object)result);
        EngineServiceImplTest.assertEquals((String)"VALID", (String)result.getValidationState());
    }

    public void testTrialExecute() {
        ReportUnit unit = this.createUnit();
        this.addJar(unit);
        TrialReportUnitRequest request = new TrialReportUnitRequest(unit, null);
        Result result = this.getEngineService().execute(null, (Request)request);
        EngineServiceImplTest.assertNotNull((Object)result);
        EngineServiceImplTest.assertTrue((boolean)(result instanceof ReportUnitResult));
        ReportUnitResult ruRes = (ReportUnitResult)result;
        JasperPrint print = ruRes.getJasperPrint();
        EngineServiceImplTest.assertNotNull((Object)print);
        List pages = print.getPages();
        EngineServiceImplTest.assertNotNull((Object)pages);
        EngineServiceImplTest.assertTrue((pages.size() > 1 ? 1 : 0) != 0);
    }

    private ReportUnit createUnit() {
        ReportUnit unit = (ReportUnit)this.getRepositoryService().newResource(null, ReportUnit.class);
        this.setCommon((Resource)unit, "SalesByMonthTrial");
        unit.setParentFolder("/reports");
        FileResource mainReport = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        mainReport.setFileType("jrxml");
        this.setCommon((Resource)mainReport, "SalesByMonthTrialReport");
        mainReport.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/SalesByMonth.jrxml"));
        unit.setMainReport(mainReport);
        unit.setDataSourceReference("/datasources/JServerJdbcDS");
        FileResource img = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        img.setFileType("img");
        img.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        this.setCommon((Resource)img, "Logo");
        unit.addResource(img);
        FileResource subrep = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        subrep.setFileType("jrxml");
        subrep.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/SalesByMonthDetail.jrxml"));
        this.setCommon((Resource)subrep, "SalesByMonthDetail");
        unit.addResource(subrep);
        FileResource resBdl = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/sales.properties"));
        this.setCommon((Resource)resBdl, "sales.properties");
        unit.addResource(resBdl);
        return unit;
    }

    private void addJar(ReportUnit unit) {
        FileResource jar = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        jar.setFileType("jar");
        jar.readData(((Object)((Object)this)).getClass().getResourceAsStream("/jars/scriptlet.jar"));
        this.setCommon((Resource)jar, "Scriptlet");
        unit.addResource(jar);
    }

    private void setCommon(Resource res, String id) {
        res.setName(id);
        res.setLabel(id + "_label");
        res.setDescription(id + " description");
    }

    public void testGetMainJasperReport() {
        JasperReport jasperReport = this.getEngineService().getMainJasperReport(null, "/reports/samples/AllAccounts");
        EngineServiceImplTest.assertNotNull((Object)jasperReport);
        EngineServiceImplTest.assertEquals((String)"AllAccounts", (String)jasperReport.getName());
    }

    public void testExecuteWithCustomDS() throws Exception {
        ReportUnitResult result = (ReportUnitResult)this.getEngineService().execute(this.context, (Request)new ReportUnitRequest("/reports/samples/DataSourceReport", new HashMap()));
        EngineServiceImplTest.assertNotNull((Object)result);
        JasperPrint jasperPrint = result.getJasperPrint();
        EngineServiceImplTest.assertNotNull((Object)jasperPrint);
        List pages = jasperPrint.getPages();
        EngineServiceImplTest.assertNotNull((Object)pages);
        EngineServiceImplTest.assertTrue((pages.size() > 0 ? 1 : 0) != 0);
    }

    public void testExecuteWithTableModelDS() throws Exception {
        ReportUnitResult result = (ReportUnitResult)this.getEngineService().execute(this.context, (Request)new ReportUnitRequest("/reports/samples/DataSourceTableModel", new HashMap()));
        EngineServiceImplTest.assertNotNull((Object)result);
        JasperPrint jasperPrint = result.getJasperPrint();
        EngineServiceImplTest.assertNotNull((Object)jasperPrint);
        List pages = jasperPrint.getPages();
        EngineServiceImplTest.assertNotNull((Object)pages);
        EngineServiceImplTest.assertTrue((pages.size() > 0 ? 1 : 0) != 0);
    }

    public void testRemoveCustomDataSourceResources() {
        this.deleteResource("/reports/samples/DataSourceReport");
        this.deleteResource("/reports/samples/DataSourceTableModel");
        this.deleteResource("/reports/samples/DataSourceReportTemplate");
        this.deleteResource("/datasources/CustomDSFromBean");
        this.deleteResource("/datasources/CustomTableModelDS");
    }

    public void deleteResource(String uri) {
        Resource result = this.getRepositoryService().getResource(null, uri);
        EngineServiceImplTest.assertNotNull((Object)result);
        this.getRepositoryService().deleteResource(null, uri);
    }
}

