/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin;

import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.gui.JRPluginConfigurationDialog;
import it.businesslogic.ireport.gui.MainFrame;
import java.awt.Component;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.w3c.tools.codec.Base64Encoder;

public class UpgradeSearch
implements Runnable {
    private JRPluginConfigurationDialog win = null;

    public void run() {
        if (!IRPlugin.getMainInstance().getBrandingProperties().getProperty("irplugin.update.checking.enabled", "true").equals("true")) {
            return;
        }
        try {
            IRPlugin.getMainInstance().applyProxySettings();
            URL url = new URL(IRPlugin.getMainInstance().getBrandingProperties().getProperty("irplugin.update.url"));
            URLConnection uConn = url.openConnection();
            Properties props = IRPlugin.getMainInstance().getProperties();
            if (props.getProperty("PROPERTY_USE_PROXY", "false").equals("true") && props.getProperty("PROPERTY_PROXY_USE_AUTH", "false").equals("true")) {
                String password = props.getProperty("PROPERTY_PROXY_USERNAME", "") + ":" + props.getProperty("PROPERTY_PROXY_PASSWORD", "");
                Base64Encoder b = new Base64Encoder(password);
                String encodedPassword = b.processString();
                uConn.setRequestProperty("Proxy-Authorization", encodedPassword);
            }
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(uConn.getInputStream()));
            String version = null;
            while ((version = lnr.readLine()) != null) {
                String vnumber;
                if (!version.startsWith("JasperIntelligence ") || (vnumber = version.substring("JasperIntelligence ".length())).compareTo(IRPlugin.CURRENT_VERSION) <= 0) continue;
                final String fversion = "" + vnumber;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getFormattedString("messages.newversion", "{0} is available on http://www.jasperforge.org!", new Object[]{fversion}));
                    }
                });
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (this.win != null) {
            this.win.setVisible(false);
        }
    }

    public JRPluginConfigurationDialog getWin() {
        return this.win;
    }

    public void setWin(JRPluginConfigurationDialog win) {
        this.win = win;
    }
}

