/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui.dndobjects;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.RepositoryFile;
import com.jaspersoft.jasperserver.irplugin.RepositoryFolder;
import com.jaspersoft.jasperserver.irplugin.RepositoryReportUnit;
import it.businesslogic.ireport.HyperLinkableReportElement;
import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.JRLinkParameter;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.SubReportElement;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.library.AbstractLibraryObject;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class FileObject
extends AbstractLibraryObject {
    private RepositoryFolder repositoryFile = null;

    public FileObject(RepositoryFolder repositoryFile) {
        this.setRepositoryFile(repositoryFile);
    }

    public String getName() {
        return "" + this.repositoryFile;
    }

    public void drop(DropTargetDropEvent dtde) {
        block27: {
            try {
                Report report;
                ResourceDescriptor rdMain;
                ResourceDescriptor rd = rdMain = this.getRepositoryFile().getDescriptor();
                if (rdMain.getIsReference()) {
                    ResourceDescriptor rd2 = new ResourceDescriptor();
                    rd2.setUriString(rdMain.getReferenceUri());
                    rd = this.getRepositoryFile().getServer().getWSClient().get(rd2, null);
                    if (rd == null) {
                        rd = rdMain;
                    }
                }
                if (rd.getWsType().equals("img")) {
                    ImageReportElement ire = new ImageReportElement(0, 0, 10, 10);
                    ire.setImageClass("java.lang.String");
                    if (rd.getParentFolder() != null && rd.getParentFolder().endsWith("_files")) {
                        ire.setImageExpression("\"repo:" + rd.getName() + "\"");
                    } else {
                        ire.setImageExpression("\"repo:" + rd.getUriString() + "\"");
                    }
                    int w = 200;
                    int h = 100;
                    try {
                        RepositoryFile rf = new RepositoryFile(this.getRepositoryFile().getServer(), rd);
                        String fileName = rf.getFile();
                        if (fileName != null) {
                            ImageIcon img = new ImageIcon(fileName);
                            ire.setImg(img.getImage());
                            w = img.getIconWidth();
                            h = img.getIconHeight();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.getReportFrame().dropReportElement(dtde.getLocation(), (ReportElement)ire, w, h);
                    break block27;
                }
                if (rd.getWsType().equals("jrxml")) {
                    report = this.getReport();
                    if (rd.isMainReport()) {
                        return;
                    }
                    SubReportElement sre = new SubReportElement(0, 0, 10, 10);
                    sre.setSubreportExpressionClass("java.lang.String");
                    if (rd.getParentFolder() != null && rd.getParentFolder().endsWith("_files")) {
                        sre.setSubreportExpression("\"repo:" + rd.getName() + "\"");
                    } else {
                        sre.setSubreportExpression("\"repo:" + rd.getUriString() + "\"");
                    }
                    sre.setConnectionExpression("$P{REPORT_CONNECTION}");
                    sre.setUseConnection(true);
                    Point p = dtde.getLocation();
                    p.x = this.getReportFrame().getZoomedDim(report.getLeftMargin()) - this.getReportFrame().getHScroll() + 10;
                    this.getReportFrame().dropReportElement(p, (ReportElement)sre, report.getWidth() - report.getLeftMargin() - report.getRightMargin(), 100);
                } else if (rd.getWsType().equals("inputControl")) {
                    report = this.getReportFrame().getReport();
                    if (report == null) {
                        return;
                    }
                    Vector v = report.getParameters();
                    boolean found = false;
                    for (int i = 0; i < v.size(); ++i) {
                        JRParameter parameter = (JRParameter)v.get(i);
                        if (!parameter.getName().equals(rd.getName())) continue;
                        JRParameterDialog jrpd = new JRParameterDialog((Frame)MainFrame.getMainInstance(), true);
                        jrpd.setParameter(parameter);
                        jrpd.setVisible(true);
                        if (jrpd.getDialogResult() == 0) {
                            report.getKeywordLookup().removeKeyword("$P{" + parameter.getName() + "}");
                            parameter.setName(jrpd.getParameter().getName());
                            report.getKeywordLookup().addKeyword("$P{" + parameter.getName() + "}");
                            parameter.setClassType(jrpd.getParameter().getClassType());
                            parameter.setDescription(jrpd.getParameter().getDescription());
                            parameter.setDefaultValueExpression(jrpd.getParameter().getDefaultValueExpression());
                            parameter.setIsForPrompting(jrpd.getParameter().isIsForPrompting());
                            report.fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent((SubDataset)report, 2, 2, (Object)parameter, (Object)parameter));
                        }
                        found = true;
                        break;
                    }
                    if (!found) {
                        JRParameter newParam = new JRParameter(rd.getName(), "java.lang.String");
                        JRParameterDialog jrpd = new JRParameterDialog((Frame)MainFrame.getMainInstance(), true);
                        newParam.setIsForPrompting(true);
                        jrpd.setParameter(newParam);
                        jrpd.setSubDataset((SubDataset)report);
                        jrpd.setVisible(true);
                        if (jrpd.getDialogResult() == 0) {
                            JRParameter parameter = jrpd.getParameter();
                            report.addParameter(parameter);
                        }
                    }
                } else if (rd.getWsType().equals("reportUnit")) {
                    ReportElement re = this.getReportFrame().getElementAt(dtde.getLocation());
                    if (re != null && re instanceof HyperLinkableReportElement) {
                        RepositoryReportUnit reportUnit;
                        HyperLinkableReportElement hre = (HyperLinkableReportElement)re;
                        hre.setHyperlinkType("ReportExecution");
                        ArrayList<JRLinkParameter> linkParameters = new ArrayList<JRLinkParameter>();
                        linkParameters.add(new JRLinkParameter("_report", "\"" + rd.getUriString() + "\""));
                        List listChildren = rd.getChildren();
                        if (this.repositoryFile instanceof RepositoryReportUnit && (!(reportUnit = (RepositoryReportUnit)this.repositoryFile).isLoaded() || rd.getChildren().size() == 0)) {
                            ResourceDescriptor descriptor = new ResourceDescriptor();
                            descriptor.setWsType("reportUnit");
                            descriptor.setUriString(reportUnit.getDescriptor().getUriString());
                            listChildren = reportUnit.getServer().getWSClient().list(descriptor);
                        }
                        for (int i = 0; i < listChildren.size(); ++i) {
                            ResourceDescriptor childRd = (ResourceDescriptor)listChildren.get(i);
                            if (!childRd.getWsType().equals("inputControl")) continue;
                            linkParameters.add(new JRLinkParameter(childRd.getName(), ""));
                        }
                        hre.setLinkParameters(linkParameters);
                        this.getReportFrame().setSelectedElement(re);
                        MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(true);
                        MainFrame.getMainInstance().getElementPropertiesDialog().gotoTab(8);
                    } else {
                        JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getString("messages.fileObject.notHyperlinkElement", "Please drag your Report Unit over an hyper linkable element like a text field, an image or a chart."));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public RepositoryFolder getRepositoryFile() {
        return this.repositoryFile;
    }

    public void setRepositoryFile(RepositoryFolder repositoryFile) {
        this.repositoryFile = repositoryFile;
    }
}

