/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.engine.common.service.ActionModelService;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ActionModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionModelServiceImpl
implements ActionModelService,
InitializingBean,
ResourceLoaderAware {
    private static String actionModelBaseURI;
    private static Map<String, Document> actionModelMap;
    private static List<String> actionModelTypes;
    private static final String XML_FILE_EXT = ".xml";
    private static ActionModelServiceImpl _singleTon;
    private ResourceLoader resourceLoader;

    private ActionModelServiceImpl() {
        actionModelMap = new HashMap<String, Document>();
        actionModelTypes = new ArrayList<String>();
        System.out.println("Creating ActionModelService object.");
    }

    public static synchronized ActionModelServiceImpl getInstance() {
        return _singleTon;
    }

    public void afterPropertiesSet() throws Exception {
        _singleTon = this;
        this.generateActionModelMenus();
    }

    public static Map<String, Document> getActionModelMap() {
        return actionModelMap;
    }

    public static void setActionModelMap(Map<String, Document> actionModelMap) {
        ActionModelServiceImpl.actionModelMap = actionModelMap;
    }

    public void generateActionModelMenus() {
        System.out.println("Creating action model infrastructure.");
        ActionModel singleTon = ActionModel.getInstance();
        for (String model : actionModelTypes) {
            String xmlFile = this.getActionModelXmlURIStub() + "-" + model + XML_FILE_EXT;
            Document doc = singleTon.generateActionModelDocument(this.getInputStreamFromFile(xmlFile));
            actionModelMap.put(model, doc);
        }
    }

    private InputStream getInputStreamFromFile(String fileName) {
        InputStream stream;
        try {
            Resource resource = this.resourceLoader.getResource(fileName);
            stream = resource.getInputStream();
        }
        catch (IOException e) {
            System.err.println("[FATAL]: file " + fileName + " could not be found.");
            e.printStackTrace();
            throw new RuntimeException("[FATAL]: action model initialization failed");
        }
        return stream;
    }

    public Document getActionModelMenu(String context) {
        if (actionModelMap.size() > 0) {
            return actionModelMap.get(context);
        }
        throw new RuntimeException("[FATAL]: action model initialization failed");
    }

    public void setActionModelTypes(List<String> modelTypes) {
        actionModelTypes = new ArrayList<String>(modelTypes);
    }

    public List<String> getActionModelTypes() {
        return actionModelTypes;
    }

    public void setActionModelXmlURIStub(String url) {
        actionModelBaseURI = url;
    }

    public String getActionModelXmlURIStub() {
        return actionModelBaseURI;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

