/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.StyleInfo;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.StyleInfoPool;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.MaxFontSizeFinder;

public class SingleLineTextMeasurer
implements JRTextMeasurer {
    private static final FontRenderContext FONT_RENDER_CONTEXT = TextRenderer.LINE_BREAK_FONT_RENDER_CONTEXT;
    private JRCommonText textElement;
    private JRPropertiesHolder propertiesHolder;
    private MaxFontSizeFinder maxFontSizeFinder = null;
    private int width = 0;
    private int height = 0;
    private int topPadding = 0;
    private int leftPadding = 0;
    private int bottomPadding = 0;
    private int rightPadding = 0;
    private float lineSpacing = 0.0f;
    private float formatWidth = 0.0f;
    private int maxHeight = 0;
    private boolean canOverflow;
    private Map globalAttributes;
    private TextMeasuredState measuredState;
    private TextMeasuredState prevMeasuredState;

    public SingleLineTextMeasurer(JRCommonText textElement) {
        this.textElement = textElement;
        this.propertiesHolder = textElement instanceof JRPropertiesHolder ? (JRPropertiesHolder)textElement : null;
    }

    protected void initialize(JRStyledText styledText, int availableStretchHeight, boolean canOverflow) {
        this.width = this.textElement.getWidth();
        this.height = this.textElement.getHeight();
        this.topPadding = this.textElement.getLineBox().getTopPadding();
        this.leftPadding = this.textElement.getLineBox().getLeftPadding();
        this.bottomPadding = this.textElement.getLineBox().getBottomPadding();
        this.rightPadding = this.textElement.getLineBox().getRightPadding();
        switch (this.textElement.getRotation()) {
            case 1: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.leftPadding;
                this.leftPadding = this.bottomPadding;
                this.bottomPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
            case 2: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.rightPadding;
                this.rightPadding = this.bottomPadding;
                this.bottomPadding = this.leftPadding;
                this.leftPadding = tmpPadding;
                break;
            }
            case 3: {
                int tmpPadding = this.topPadding;
                this.topPadding = this.bottomPadding;
                this.bottomPadding = tmpPadding;
                tmpPadding = this.leftPadding;
                this.leftPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
        }
        switch (this.textElement.getLineSpacing()) {
            case 0: {
                this.lineSpacing = 1.0f;
                break;
            }
            case 1: {
                this.lineSpacing = 1.5f;
                break;
            }
            case 2: {
                this.lineSpacing = 2.0f;
                break;
            }
            default: {
                this.lineSpacing = 1.0f;
            }
        }
        this.maxFontSizeFinder = MaxFontSizeFinder.getInstance((boolean)this.textElement.isStyledText());
        this.formatWidth = this.width - this.leftPadding - this.rightPadding;
        this.formatWidth = this.formatWidth < 0.0f ? 0.0f : this.formatWidth;
        this.maxHeight = this.height + availableStretchHeight - this.topPadding - this.bottomPadding;
        this.maxHeight = this.maxHeight < 0 ? 0 : this.maxHeight;
        this.canOverflow = canOverflow;
        this.globalAttributes = styledText.getGlobalAttributes();
        this.measuredState = new TextMeasuredState();
        this.prevMeasuredState = null;
    }

    public JRMeasuredText measure(JRStyledText styledText, int remainingTextStart, int availableStretchHeight, boolean canOverflow) {
        this.initialize(styledText, availableStretchHeight, canOverflow);
        AttributedCharacterIterator allParagraphs = styledText.getAttributedString().getIterator();
        int tokenPosition = remainingTextStart;
        int lastParagraphStart = remainingTextStart;
        String lastParagraphText = null;
        String remainingText = styledText.getText().substring(remainingTextStart);
        StringTokenizer tkzer = new StringTokenizer(remainingText, "\n", true);
        boolean rendered = true;
        while (tkzer.hasMoreTokens() && rendered) {
            String token = tkzer.nextToken();
            if ("\n".equals(token)) {
                rendered = this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
                lastParagraphStart = tokenPosition + (tkzer.hasMoreTokens() || tokenPosition == 0 ? 1 : 0);
                lastParagraphText = null;
            } else {
                lastParagraphStart = tokenPosition;
                lastParagraphText = token;
            }
            tokenPosition += token.length();
        }
        if (rendered && lastParagraphStart < remainingTextStart + remainingText.length()) {
            this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
        }
        return this.measuredState;
    }

    private boolean renderParagraph(AttributedCharacterIterator allParagraphs, int lastParagraphStart, String lastParagraphText) {
        Set<AttributedCharacterIterator.Attribute> paragraphAttribs = allParagraphs.getAllAttributeKeys();
        Map<AttributedCharacterIterator.Attribute, Object> AttribValues = allParagraphs.getAttributes();
        String keyString = "";
        for (AttributedCharacterIterator.Attribute key : paragraphAttribs) {
            keyString = keyString + String.valueOf(AttribValues.get(key));
        }
        StyleInfo si = StyleInfoPool.getPoolElement(keyString);
        if (si == null) {
            boolean rendered = this.renderParagraphInner(allParagraphs, lastParagraphStart, lastParagraphText);
            StyleInfo nsi = new StyleInfo();
            nsi.setFirstLineLeading(this.measuredState.firstLineLeading);
            nsi.setFirstLineMaxFontSize(this.measuredState.firstLineMaxFontSize);
            nsi.setFontSizeSum(this.measuredState.fontSizeSum);
            nsi.setLines(1);
            nsi.setTextHeight(this.measuredState.textHeight);
            nsi.setLeftToRight(this.measuredState.isLeftToRight);
            StyleInfoPool.putPoolElement(keyString, nsi);
            System.out.println("key added: " + keyString);
            return rendered;
        }
        this.measuredState.firstLineLeading = si.getFirstLineLeading();
        this.measuredState.firstLineMaxFontSize = si.getFirstLineMaxFontSize();
        this.measuredState.fontSizeSum = si.getFontSizeSum();
        this.measuredState.lines = si.getLines();
        this.measuredState.textHeight = si.getTextHeight();
        this.measuredState.textOffset = lastParagraphText.length();
        this.measuredState.isLeftToRight = si.isLeftToRight();
        return this.measuredState.textHeight <= (float)this.maxHeight;
    }

    protected boolean renderParagraphInner(AttributedCharacterIterator allParagraphs, int lastParagraphStart, String lastParagraphText) {
        AttributedCharacterIterator paragraph = null;
        paragraph = lastParagraphText == null ? new AttributedString(" ", new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + 1).getIterator().getAttributes()).getIterator() : new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + lastParagraphText.length()).getIterator();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, FONT_RENDER_CONTEXT);
        this.measuredState.textOffset = lastParagraphStart;
        boolean rendered = true;
        boolean renderedLine = false;
        while (lineMeasurer.getPosition() < paragraph.getEndIndex() && rendered) {
            rendered = this.renderNextLine(lineMeasurer, paragraph);
            renderedLine = renderedLine || rendered;
        }
        if (!rendered && this.prevMeasuredState != null && !this.canOverflow) {
            this.processLastTruncatedRow(allParagraphs, lastParagraphText, lastParagraphStart, renderedLine);
        }
        return rendered;
    }

    protected void processLastTruncatedRow(AttributedCharacterIterator allParagraphs, String paragraphText, int paragraphOffset, boolean lineTruncated) {
        if (lineTruncated && this.isToTruncateAtChar()) {
            this.truncateLastLineAtChar(allParagraphs, paragraphText, paragraphOffset);
        }
        this.appendTruncateSuffix(allParagraphs);
    }

    protected void truncateLastLineAtChar(AttributedCharacterIterator allParagraphs, String paragraphText, int paragraphOffset) {
        this.measuredState = this.prevMeasuredState.cloneState();
        AttributedCharacterIterator lineParagraph = new AttributedString(allParagraphs, this.measuredState.textOffset, paragraphOffset + paragraphText.length()).getIterator();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(lineParagraph, BreakIterator.getCharacterInstance(), FONT_RENDER_CONTEXT);
        this.renderNextLine(lineMeasurer, lineParagraph);
    }

    protected void appendTruncateSuffix(AttributedCharacterIterator allParagraphs) {
        String truncateSuffx = this.getTruncateSuffix();
        if (truncateSuffx == null) {
            return;
        }
        int lineStart = this.prevMeasuredState.textOffset;
        StringBuffer lineText = new StringBuffer();
        allParagraphs.setIndex(lineStart);
        while (allParagraphs.getIndex() < this.measuredState.textOffset && allParagraphs.current() != '\n') {
            lineText.append(allParagraphs.current());
            allParagraphs.next();
        }
        int linePosition = allParagraphs.getIndex() - lineStart;
        boolean done = false;
        do {
            this.measuredState = this.prevMeasuredState.cloneState();
            String text = lineText.substring(0, linePosition) + truncateSuffx;
            AttributedString attributedText = new AttributedString(text);
            AttributedCharacterIterator lineAttributes = new AttributedString(allParagraphs, this.measuredState.textOffset, this.measuredState.textOffset + linePosition).getIterator();
            this.setAttributes(attributedText, lineAttributes, 0);
            this.setAttributes(attributedText, this.globalAttributes, text.length() - truncateSuffx.length(), text.length());
            AttributedCharacterIterator lineParagraph = attributedText.getIterator();
            BreakIterator breakIterator = this.isToTruncateAtChar() ? BreakIterator.getCharacterInstance() : BreakIterator.getLineInstance();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(lineParagraph, breakIterator, FONT_RENDER_CONTEXT);
            if (this.renderNextLine(lineMeasurer, lineParagraph)) {
                int lastPos = lineMeasurer.getPosition();
                if (lastPos == linePosition + truncateSuffx.length()) {
                    this.measuredState.textOffset -= truncateSuffx.length();
                    this.measuredState.textSuffix = truncateSuffx;
                    done = true;
                    continue;
                }
                if ((linePosition = breakIterator.preceding(linePosition)) != -1) continue;
                String actualSuffix = truncateSuffx.substring(0, this.measuredState.textOffset - this.prevMeasuredState.textOffset);
                if (this.prevMeasuredState.textOffset > 0 && allParagraphs.setIndex(this.prevMeasuredState.textOffset - 1) != '\n') {
                    actualSuffix = '\n' + actualSuffix;
                }
                this.measuredState.textSuffix = actualSuffix;
                this.measuredState.textOffset = this.prevMeasuredState.textOffset;
                done = true;
                continue;
            }
            done = true;
        } while (!done);
    }

    protected boolean isToTruncateAtChar() {
        return JRProperties.getBooleanProperty((JRPropertiesHolder)this.propertiesHolder, (String)"net.sf.jasperreports.text.truncate.at.char", (boolean)false);
    }

    protected String getTruncateSuffix() {
        String truncateSuffx = JRProperties.getProperty((JRPropertiesHolder)this.propertiesHolder, (String)"net.sf.jasperreports.text.truncate.suffix");
        if (truncateSuffx != null) {
            truncateSuffx = truncateSuffx.trim();
        }
        if (truncateSuffx.length() == 0) {
            truncateSuffx = null;
        }
        return truncateSuffx;
    }

    protected boolean renderNextLine(LineBreakMeasurer lineMeasurer, AttributedCharacterIterator paragraph) {
        boolean fits;
        int lineStartPosition = lineMeasurer.getPosition();
        TextLayout layout = lineMeasurer.nextLayout(this.formatWidth);
        float newTextHeight = this.measuredState.textHeight + layout.getLeading() + this.lineSpacing * layout.getAscent();
        boolean bl = fits = newTextHeight + layout.getDescent() <= (float)this.maxHeight;
        if (fits) {
            this.prevMeasuredState = this.measuredState.cloneState();
            this.measuredState.isLeftToRight = this.measuredState.isLeftToRight && layout.isLeftToRight();
            this.measuredState.textHeight = newTextHeight;
            ++this.measuredState.lines;
            this.measuredState.fontSizeSum += this.maxFontSizeFinder.findMaxFontSize(new AttributedString(paragraph, lineStartPosition, lineStartPosition + layout.getCharacterCount()).getIterator(), this.textElement.getFontSize());
            if (this.measuredState.lines == 1) {
                this.measuredState.firstLineLeading = this.measuredState.textHeight;
                this.measuredState.firstLineMaxFontSize = this.measuredState.fontSizeSum;
            }
            this.measuredState.textHeight += layout.getDescent();
            this.measuredState.textOffset += lineMeasurer.getPosition() - lineStartPosition;
        }
        return fits;
    }

    protected JRPropertiesHolder getTextPropertiesHolder() {
        return this.propertiesHolder;
    }

    protected void setAttributes(AttributedString string, AttributedCharacterIterator attributes, int stringOffset) {
        char c = attributes.first();
        while (c != '\uffff') {
            for (Map.Entry<AttributedCharacterIterator.Attribute, Object> attributeEntry : attributes.getAttributes().entrySet()) {
                AttributedCharacterIterator.Attribute attribute = attributeEntry.getKey();
                if (attributes.getRunStart(attribute) != attributes.getIndex()) continue;
                Object attributeValue = attributeEntry.getValue();
                string.addAttribute(attribute, attributeValue, attributes.getIndex() + stringOffset, attributes.getRunLimit(attribute) + stringOffset);
            }
            c = attributes.next();
        }
    }

    protected void setAttributes(AttributedString string, Map attributes, int startIndex, int endIndex) {
        for (Map.Entry entry : attributes.entrySet()) {
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)entry.getKey();
            Object attributeValue = entry.getValue();
            string.addAttribute(attribute, attributeValue, startIndex, endIndex);
        }
    }

    protected static class TextMeasuredState
    implements JRMeasuredText,
    Cloneable {
        protected int textOffset = 0;
        protected int lines = 0;
        protected int fontSizeSum = 0;
        protected int firstLineMaxFontSize = 0;
        protected float textHeight = 0.0f;
        protected float firstLineLeading = 0.0f;
        protected boolean isLeftToRight = true;
        protected String textSuffix = null;

        protected TextMeasuredState() {
        }

        public boolean isLeftToRight() {
            return this.isLeftToRight;
        }

        public int getTextOffset() {
            return this.textOffset;
        }

        public float getTextHeight() {
            return this.textHeight;
        }

        public float getLineSpacingFactor() {
            if (this.lines > 0) {
                return this.textHeight / (float)this.fontSizeSum;
            }
            return 0.0f;
        }

        public float getLeadingOffset() {
            return this.firstLineLeading - (float)this.firstLineMaxFontSize * this.getLineSpacingFactor();
        }

        public String getTextSuffix() {
            return this.textSuffix;
        }

        public TextMeasuredState cloneState() {
            try {
                return (TextMeasuredState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }

        public short[] getLineBreakOffsets() {
            return null;
        }
    }
}

