/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling;

import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobValidator;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobsInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportSchedulingInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRuntimeInformation;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsScheduler;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulerListener;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportSchedulingFacade
implements ReportSchedulingService,
ReportSchedulingInternalService,
ReportSchedulerListener,
InitializingBean {
    private static final Log log = LogFactory.getLog(ReportSchedulingFacade.class);
    private ReportJobsPersistenceService persistenceService;
    private ReportJobsInternalService jobsInternalService;
    private ReportJobsScheduler scheduler;
    private ReportJobValidator validator;
    private AuditContext auditContext;
    private Map outputKeyMapping;

    public Map getOutputKeyMapping() {
        return this.outputKeyMapping;
    }

    public void setOutputKeyMapping(Map outputKeyMapping) {
        this.outputKeyMapping = outputKeyMapping;
    }

    public ReportJobsPersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(ReportJobsPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public ReportJobsScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ReportJobsScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public ReportJobValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ReportJobValidator validator) {
        this.validator = validator;
    }

    public ReportJobsInternalService getJobsInternalService() {
        return this.jobsInternalService;
    }

    public void setJobsInternalService(ReportJobsInternalService jobsInternalService) {
        this.jobsInternalService = jobsInternalService;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.getScheduler().addReportSchedulerListener((ReportSchedulerListener)this);
    }

    private String getReportJobFormatsAsString(ReportJob job) {
        StringBuilder sb = new StringBuilder();
        for (Object outputFormat : job.getOutputFormats()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(((String)this.outputKeyMapping.get(outputFormat.toString())).toUpperCase());
        }
        return sb.toString();
    }

    private String getReportJobNotificationEmailsAsString(ReportJob job) {
        if (job.getMailNotification() == null) {
            return null;
        }
        ArrayList emailsList = new ArrayList();
        if (job.getMailNotification().getToAddresses() != null) {
            emailsList.addAll(job.getMailNotification().getToAddresses());
        }
        if (job.getMailNotification().getCcAddresses() != null) {
            emailsList.addAll(job.getMailNotification().getCcAddresses());
        }
        if (job.getMailNotification().getBccAddresses() != null) {
            emailsList.addAll(job.getMailNotification().getBccAddresses());
        }
        StringBuilder sb = new StringBuilder();
        for (Object email : emailsList) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(email.toString());
        }
        return sb.toString();
    }

    private String getSetOfBytesAsString(Set set, Map<Byte, String> namesMap) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object element : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(namesMap.get(Byte.valueOf(element.toString())));
        }
        return sb.toString();
    }

    public void createDeleteReportSchedulingEvent() {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                ReportSchedulingFacade.this.auditContext.createAuditEvent("deleteReportScheduling");
            }
        });
    }

    public void closeDeleteReportSchedulingEvent() {
        this.auditContext.doInAuditContext("deleteReportScheduling", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ReportSchedulingFacade.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public void addParamsToAuditEvent(final ReportJob job, String jobType) {
        this.auditContext.doInAuditContext(jobType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ReportJobCalendarTrigger trigger;
                auditEvent.setResourceUri(job.getSource().getReportUnitURI());
                ReportSchedulingFacade.this.auditContext.setResourceTypeToAuditEvent(ReportUnit.class.getName(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobLabel", (Object)job.getLabel(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobDescription", (Object)job.getDescription(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobBaseOutputFilename", (Object)job.getBaseOutputFilename(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobOutputFormats", (Object)ReportSchedulingFacade.this.getReportJobFormatsAsString(job), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobOutputLocale", (Object)job.getOutputLocale(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobDestinationFolder", (Object)job.getContentRepositoryDestination().getFolderURI(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobNotificationEmails", (Object)ReportSchedulingFacade.this.getReportJobNotificationEmailsAsString(job), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobTriggerStartType", (Object)(job.getTrigger().getStartType() == 1 ? "NOW" : "SCHEDULE"), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobTimezone", (Object)job.getTrigger().getTimezone(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobStartDate", (Object)job.getTrigger().getStartDate(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobEndDate", (Object)job.getTrigger().getEndDate(), auditEvent);
                if (job.getTrigger() instanceof ReportJobSimpleTrigger) {
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobTriggerType", (Object)"SIMPLE_TRIGGER", auditEvent);
                    trigger = (ReportJobSimpleTrigger)job.getTrigger();
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobSimpleTriggerOccurenceCount", (Object)trigger.getOccurrenceCount(), auditEvent);
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobSimpleTriggerRecurrenceInterval", (Object)trigger.getRecurrenceInterval(), auditEvent);
                    HashMap<Byte, String> intervalUnitNamesMap = new HashMap<Byte, String>();
                    intervalUnitNamesMap.put((byte)1, "MINUTE");
                    intervalUnitNamesMap.put((byte)2, "HOUR");
                    intervalUnitNamesMap.put((byte)3, "DAY");
                    intervalUnitNamesMap.put((byte)4, "WEEK");
                    String intervalUnitName = (String)intervalUnitNamesMap.get(trigger.getRecurrenceIntervalUnit());
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobSimpleTriggerRecurrenceIntervalUnit", (Object)intervalUnitName, auditEvent);
                } else {
                    trigger = (ReportJobCalendarTrigger)job.getTrigger();
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobTriggerType", (Object)"CALENDAR_TRIGGER", auditEvent);
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerMinutes", (Object)trigger.getMinutes(), auditEvent);
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerHours", (Object)trigger.getHours(), auditEvent);
                    HashMap<Byte, String> daysTypeNamesMap = new HashMap<Byte, String>();
                    daysTypeNamesMap.put((byte)1, "ALL");
                    daysTypeNamesMap.put((byte)2, "WEEK");
                    daysTypeNamesMap.put((byte)3, "MONTH");
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerDaysType", daysTypeNamesMap.get(trigger.getDaysType()), auditEvent);
                    HashMap<Byte, String> weekDaysMap = new HashMap<Byte, String>();
                    weekDaysMap.put((byte)2, "mon");
                    weekDaysMap.put((byte)3, "tue");
                    weekDaysMap.put((byte)4, "wen");
                    weekDaysMap.put((byte)5, "thu");
                    weekDaysMap.put((byte)6, "fri");
                    weekDaysMap.put((byte)7, "sat");
                    weekDaysMap.put((byte)1, "sun");
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerWeekDays", (Object)ReportSchedulingFacade.this.getSetOfBytesAsString(trigger.getWeekDays(), weekDaysMap), auditEvent);
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerMonthDays", (Object)trigger.getMonthDays(), auditEvent);
                    HashMap<Byte, String> monthsMap = new HashMap<Byte, String>();
                    monthsMap.put((byte)1, "jan");
                    monthsMap.put((byte)2, "feb");
                    monthsMap.put((byte)3, "mar");
                    monthsMap.put((byte)4, "apr");
                    monthsMap.put((byte)5, "may");
                    monthsMap.put((byte)6, "jun");
                    monthsMap.put((byte)7, "jul");
                    monthsMap.put((byte)8, "aug");
                    monthsMap.put((byte)9, "sep");
                    monthsMap.put((byte)10, "oct");
                    monthsMap.put((byte)11, "nov");
                    monthsMap.put((byte)12, "dec");
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerMonths", (Object)ReportSchedulingFacade.this.getSetOfBytesAsString(trigger.getMonths(), monthsMap), auditEvent);
                }
                if (job.getSource().getParametersMap() != null) {
                    for (Object key : job.getSource().getParametersMap().keySet()) {
                        String stringKey = key.toString();
                        Object value = job.getSource().getParametersMap().get(key);
                        String stringValue = value != null ? value.toString() : "";
                        String param = stringKey + "=" + stringValue;
                        ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobParam", (Object)param, auditEvent);
                    }
                }
            }
        });
    }

    public ReportJob scheduleJob(ExecutionContext context, ReportJob job) {
        this.validate(context, job);
        this.addParamsToAuditEvent(job, "scheduleReport");
        ReportJob savedJob = this.persistenceService.saveJob(context, job);
        this.scheduler.scheduleJob(context, savedJob);
        return savedJob;
    }

    protected void validate(ExecutionContext context, ReportJob job) {
        ValidationErrors errors = this.validator.validateJob(context, job);
        if (errors.isError()) {
            throw new JSValidationException(errors);
        }
    }

    public List getScheduledJobs(ExecutionContext context, String reportUnitURI) {
        List jobs = this.persistenceService.listJobs(context, reportUnitURI);
        this.setSummaryRuntimeInformation(context, jobs);
        return jobs;
    }

    public List getScheduledJobs(ExecutionContext context) {
        List jobs = this.persistenceService.listJobs(context);
        this.setSummaryRuntimeInformation(context, jobs);
        return jobs;
    }

    protected void setSummaryRuntimeInformation(ExecutionContext context, List jobs) {
        if (jobs != null && !jobs.isEmpty()) {
            long[] jobIds = new long[jobs.size()];
            int idx = 0;
            for (ReportJobSummary job : jobs) {
                jobIds[idx] = job.getId();
                ++idx;
            }
            ReportJobRuntimeInformation[] runtimeInfos = this.scheduler.getJobsRuntimeInformation(context, jobIds);
            idx = 0;
            for (ReportJobSummary job : jobs) {
                job.setRuntimeInformation(runtimeInfos[idx]);
                ++idx;
            }
        }
    }

    public void removeScheduledJob(ExecutionContext context, long jobId) {
        this.createDeleteReportSchedulingEvent();
        this.deleteJob(context, jobId);
        this.closeDeleteReportSchedulingEvent();
    }

    public void removeScheduledJobs(ExecutionContext context, long[] jobIds) {
        for (int i = 0; i < jobIds.length; ++i) {
            this.createDeleteReportSchedulingEvent();
            long jobId = jobIds[i];
            this.deleteJob(context, jobId);
            this.closeDeleteReportSchedulingEvent();
        }
    }

    @Override
    public void removeReportUnitJobs(String reportUnitURI) {
        long[] deletedJobIds = this.getJobsInternalService().deleteReportUnitJobs(reportUnitURI);
        this.unscheduleJobs(deletedJobIds);
    }

    protected void unscheduleJobs(long[] deletedJobIds) {
        if (deletedJobIds != null && deletedJobIds.length > 0) {
            for (int i = 0; i < deletedJobIds.length; ++i) {
                long jobId = deletedJobIds[i];
                this.scheduler.removeScheduledJob(null, jobId);
            }
        }
    }

    protected void deleteJob(ExecutionContext context, long jobId) {
        this.addParamsToAuditEvent(this.getScheduledJob(context, jobId), "deleteReportScheduling");
        this.scheduler.removeScheduledJob(context, jobId);
        this.persistenceService.deleteJob(context, new ReportJobIdHolder(jobId));
    }

    public ReportJob getScheduledJob(ExecutionContext context, long jobId) {
        return this.persistenceService.loadJob(context, new ReportJobIdHolder(jobId));
    }

    public void reportJobFinalized(long jobId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Job " + jobId + " finalized, deleting data"));
        }
        this.getJobsInternalService().deleteJob(jobId);
    }

    public void updateScheduledJob(ExecutionContext context, ReportJob job) {
        this.validate(context, job);
        ReportJobTrigger origTrigger = job.getTrigger();
        long origTriggerId = origTrigger.getId();
        int origTriggerVersion = origTrigger.getVersion();
        this.addParamsToAuditEvent(job, "updateReportScheduling");
        ReportJob savedJob = this.persistenceService.updateJob(context, job);
        ReportJobTrigger updatedTrigger = savedJob.getTrigger();
        if (updatedTrigger.getId() != origTriggerId || updatedTrigger.getVersion() != origTriggerVersion) {
            this.scheduler.rescheduleJob(context, savedJob);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Trigger attributes not changed for job " + job.getId() + ", the job will not be rescheduled"));
        }
    }

    public ValidationErrors validateJob(ExecutionContext context, ReportJob job) {
        ValidationErrors errors = this.validator.validateJob(context, job);
        if (!this.hasTriggerErrors(errors)) {
            this.scheduler.validate(job, errors);
        }
        return errors;
    }

    protected boolean hasTriggerErrors(ValidationErrors errors) {
        boolean triggerError = false;
        Iterator it = errors.getErrors().iterator();
        while (!triggerError && it.hasNext()) {
            ValidationError error = (ValidationError)it.next();
            String field = error.getField();
            if (field == null || !field.equals("trigger") && !field.startsWith("trigger.")) continue;
            triggerError = true;
        }
        return triggerError;
    }

    @Override
    public ReportJob saveJob(ExecutionContext context, ReportJob job) {
        this.validateSaveJob(context, job);
        ReportJob savedJob = this.jobsInternalService.saveJob(context, job, false);
        this.scheduler.scheduleJob(context, savedJob);
        return savedJob;
    }

    protected void validateSaveJob(ExecutionContext context, ReportJob job) {
        ValidationErrors errors = this.validator.validateJob(context, job);
        errors.removeError("error.before.current.date", "trigger.startDate");
        if (errors.isError()) {
            throw new JSValidationException(errors);
        }
    }

    @Override
    public void updateReportUnitURI(String oldURI, String newURI) {
        this.getJobsInternalService().updateReportUnitURI(oldURI, newURI);
    }
}

