/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.user.UserPersistenceHandler;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobsInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobNotFoundException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class HibernateReportJobsPersistenceService
extends HibernateDaoImpl
implements ReportJobsPersistenceService,
ReportJobsInternalService {
    protected static final Log log = LogFactory.getLog(HibernateReportJobsPersistenceService.class);
    private UserPersistenceHandler userHandler;

    public UserPersistenceHandler getUserHandler() {
        return this.userHandler;
    }

    public void setUserHandler(UserPersistenceHandler userHandler) {
        this.userHandler = userHandler;
    }

    public ReportJob saveJob(ExecutionContext context, ReportJob job) {
        return this.saveJob(context, job, true);
    }

    public ReportJob saveJob(ExecutionContext context, final ReportJob job, final boolean setContextUsername) {
        return (ReportJob)this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateTemplate hibernateTemplate = HibernateReportJobsPersistenceService.this.getHibernateTemplate();
                PersistentReportJob persistentJob = new PersistentReportJob();
                persistentJob.copyFrom(job, hibernateTemplate);
                RepoUser owner = setContextUsername ? HibernateReportJobsPersistenceService.this.userHandler.getPersistentUserFromContext() : HibernateReportJobsPersistenceService.this.userHandler.getPersistentUserFromUsername(job.getUsername());
                persistentJob.setOwner(owner);
                persistentJob.cascadeSave(hibernateTemplate);
                hibernateTemplate.save((Object)persistentJob);
                hibernateTemplate.flush();
                ReportJob clientJob = HibernateReportJobsPersistenceService.this.toClient(persistentJob);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saved report job " + clientJob.getId() + " for report " + clientJob.getSource().getReportUnitURI()));
                }
                return clientJob;
            }
        });
    }

    public ReportJob updateJob(ExecutionContext context, final ReportJob job) {
        return (ReportJob)this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateTemplate hibernateTemplate = HibernateReportJobsPersistenceService.this.getHibernateTemplate();
                PersistentReportJob persistentJob = HibernateReportJobsPersistenceService.this.findJob(job.getId(), true);
                persistentJob.copyFrom(job, hibernateTemplate);
                persistentJob.cascadeSave(hibernateTemplate);
                hibernateTemplate.update((Object)persistentJob);
                hibernateTemplate.flush();
                ReportJob clientJob = HibernateReportJobsPersistenceService.this.toClient(persistentJob);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updated report job " + clientJob.getId()));
                }
                return clientJob;
            }
        });
    }

    public ReportJob loadJob(ExecutionContext context, ReportJobIdHolder jobIdHolder) {
        final long jobId = jobIdHolder.getId();
        return (ReportJob)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                PersistentReportJob persistentJob = HibernateReportJobsPersistenceService.this.findJob(jobId, false);
                ReportJob job = persistentJob == null ? null : HibernateReportJobsPersistenceService.this.toClient(persistentJob);
                return job;
            }
        });
    }

    public void deleteJob(ExecutionContext context, ReportJobIdHolder jobIdHolder) {
        this.deleteJob(jobIdHolder.getId());
    }

    public void deleteJob(final long jobId) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                PersistentReportJob job = HibernateReportJobsPersistenceService.this.findJob(jobId, false);
                if (job != null) {
                    HibernateReportJobsPersistenceService.this.deleteJob(job);
                } else if (log.isInfoEnabled()) {
                    log.info((Object)("Report job with id " + jobId + " not found for deletion"));
                }
                return null;
            }
        }, false);
    }

    public List listJobs(ExecutionContext context, final String reportUnitURI) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List persistentJobs = HibernateReportJobsPersistenceService.this.getReportUnitJobs(reportUnitURI);
                List jobs = HibernateReportJobsPersistenceService.this.toClientSummary(persistentJobs);
                return jobs;
            }
        });
    }

    public List listJobs(ExecutionContext context) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List persistentJobs = HibernateReportJobsPersistenceService.this.getAllJobs();
                List jobs = HibernateReportJobsPersistenceService.this.toClientSummary(persistentJobs);
                return jobs;
            }
        });
    }

    protected PersistentReportJob findJob(long jobId, boolean required) {
        PersistentReportJob job = (PersistentReportJob)this.getHibernateTemplate().get(PersistentReportJob.class, (Serializable)new Long(jobId));
        if (job == null && required) {
            throw new ReportJobNotFoundException(jobId);
        }
        return job;
    }

    public String getJobOwner(final long jobId) {
        return (String)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                PersistentReportJob persistentJob = HibernateReportJobsPersistenceService.this.findJob(jobId, true);
                return HibernateReportJobsPersistenceService.this.userHandler.getClientUsername(persistentJob.getOwner());
            }
        });
    }

    public long[] deleteReportUnitJobs(final String reportUnitURI) {
        return (long[])this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List jobs = HibernateReportJobsPersistenceService.this.getReportUnitJobs(reportUnitURI);
                return HibernateReportJobsPersistenceService.this.deletePersistentJobs(jobs);
            }
        }, false);
    }

    protected void deleteJob(PersistentReportJob job) {
        job.delete(this.getHibernateTemplate());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted job " + job.getId()));
        }
    }

    protected List getReportUnitJobs(String reportUnitURI) {
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        DetachedCriteria crit = DetachedCriteria.forClass(PersistentReportJob.class);
        crit.add((Criterion)Restrictions.eq((String)"source.reportUnitURI", (Object)reportUnitURI));
        List persistentJobs = hibernateTemplate.findByCriteria(crit);
        return persistentJobs;
    }

    protected List getAllJobs() {
        return this.getHibernateTemplate().loadAll(PersistentReportJob.class);
    }

    public List toClientSummary(List persistentJobs) {
        ArrayList<ReportJobSummary> jobs = new ArrayList<ReportJobSummary>(persistentJobs.size());
        for (PersistentReportJob persistentJob : persistentJobs) {
            jobs.add(this.toClientSummary(persistentJob));
        }
        return jobs;
    }

    public long[] deletePersistentJobs(List jobs) {
        long[] jobIds;
        if (jobs == null || jobs.isEmpty()) {
            jobIds = null;
        } else {
            jobIds = new long[jobs.size()];
            int c = 0;
            for (PersistentReportJob job : jobs) {
                jobIds[c] = job.getId();
                this.deleteJob(job);
                ++c;
            }
        }
        return jobIds;
    }

    public long[] updateReportUnitURI(final String oldURI, final String newURI) {
        return (long[])this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List jobs = HibernateReportJobsPersistenceService.this.getReportUnitJobs(oldURI);
                return HibernateReportJobsPersistenceService.this.updateReportURI(jobs, newURI);
            }
        }, false);
    }

    protected Object updateReportURI(List jobs, String newURI) {
        long[] jobIds;
        if (jobs == null || jobs.isEmpty()) {
            jobIds = null;
        } else {
            jobIds = new long[jobs.size()];
            int c = 0;
            for (PersistentReportJob job : jobs) {
                jobIds[c] = job.getId();
                job.getSource().setReportUnitURI(newURI);
                this.getHibernateTemplate().update((Object)job);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updated report URI of job " + job.getId() + " to " + newURI));
                }
                ++c;
            }
        }
        return jobIds;
    }

    protected ReportJob toClient(PersistentReportJob persistentJob) {
        ReportJob clientJob = persistentJob.toClient();
        clientJob.setUsername(this.userHandler.getClientUsername(persistentJob.getOwner()));
        return clientJob;
    }

    protected ReportJobSummary toClientSummary(PersistentReportJob persistentJob) {
        ReportJobSummary clientSummary = persistentJob.toSummary();
        clientSummary.setUsername(this.userHandler.getClientUsername(persistentJob.getOwner()));
        return clientSummary;
    }
}

