/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.defaults;

import java.awt.Component;
import javax.swing.JSplitPane;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.DockingStrategy;
import org.flexdock.util.DockingUtility;

public class DockingSplitPane
extends JSplitPane
implements DockingConstants {
    protected DockingPort dockingPort;
    protected String region;
    protected boolean dividerLocDetermined;
    protected boolean controllerInTopLeft;

    public DockingSplitPane(DockingPort port, String region) {
        if (port == null) {
            throw new IllegalArgumentException("'port' cannot be null.");
        }
        if (!DockingManager.isValidDockingRegion(region)) {
            throw new IllegalArgumentException("'" + region + "' is not a valid region.");
        }
        this.region = region;
        this.dockingPort = port;
        this.controllerInTopLeft = !DockingUtility.isRegionTopLeft(region);
        boolean weight = this.controllerInTopLeft;
        this.setResizeWeight((double)weight);
    }

    protected boolean isDividerSizeProperlyDetermined() {
        if (this.getDividerLocation() != 0) {
            return true;
        }
        return this.dividerLocDetermined;
    }

    public Component getElderComponent() {
        Component c;
        Component component = c = this.controllerInTopLeft ? this.getLeftComponent() : this.getRightComponent();
        if (c instanceof DockingPort) {
            c = ((DockingPort)((Object)c)).getDockedComponent();
        }
        return c;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean isElderTopLeft() {
        return this.controllerInTopLeft;
    }

    public void doLayout() {
        if (!this.isDividerSizeProperlyDetermined()) {
            this.dividerLocDetermined = true;
            Component controller = this.getElderComponent();
            this.resetDividerLocation();
        }
        super.doLayout();
    }

    protected void resetDividerLocation() {
        DockingStrategy strategy = DockingManager.getDockingStrategy(this.dockingPort);
        int loc = strategy.getInitialDividerLocation(this.dockingPort, this);
        this.setDividerLocation(loc);
    }

    public void cleanup() {
        this.dockingPort = null;
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }
}

