/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.service.impl;

import com.jaspersoft.jasperserver.api.logging.context.LoggableEvent;
import com.jaspersoft.jasperserver.api.logging.service.LoggingService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingFacade
implements LoggingService {
    private Map<Class<? extends LoggableEvent>, LoggingService> routingMap;

    public void setRoutingMap(Map<Class<? extends LoggableEvent>, LoggingService> routingMap) {
        this.routingMap = routingMap;
    }

    public void saveEvent(LoggableEvent loggableEvent) {
        for (Class<? extends LoggableEvent> clazz : this.routingMap.keySet()) {
            LoggingService loggingService;
            if (!clazz.isAssignableFrom(loggableEvent.getClass()) || (loggingService = this.routingMap.get(clazz)) == null) continue;
            loggingService.saveEvent(loggableEvent);
        }
    }

    private Map<Class<? extends LoggableEvent>, List<LoggableEvent>> geSplittedEventsMap(List<LoggableEvent> events) {
        HashMap<Class<? extends LoggableEvent>, List<LoggableEvent>> eventsByTypeMap = new HashMap<Class<? extends LoggableEvent>, List<LoggableEvent>>();
        for (LoggableEvent loggableEvent : events) {
            for (Class<? extends LoggableEvent> clazz : this.routingMap.keySet()) {
                if (!clazz.isAssignableFrom(loggableEvent.getClass())) continue;
                if (!eventsByTypeMap.containsKey(clazz)) {
                    eventsByTypeMap.put(clazz, new ArrayList());
                }
                ((List)eventsByTypeMap.get(clazz)).add(loggableEvent);
            }
        }
        return eventsByTypeMap;
    }

    public void saveEvents(List<LoggableEvent> loggableEvents) {
        Map<Class<? extends LoggableEvent>, List<LoggableEvent>> eventsByTypeMap = this.geSplittedEventsMap(loggableEvents);
        for (Class<? extends LoggableEvent> clazz : eventsByTypeMap.keySet()) {
            LoggingService loggingService = this.routingMap.get(clazz);
            if (loggingService == null) continue;
            loggingService.saveEvents(eventsByTypeMap.get(clazz));
        }
    }
}

