/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorsImpl;
import com.jaspersoft.jasperserver.api.common.service.ClassMappingsObjectFactory;
import com.jaspersoft.jasperserver.api.common.util.CollatorFactory;
import com.jaspersoft.jasperserver.api.common.util.DefaultCollatorFactory;
import com.jaspersoft.jasperserver.api.logging.access.context.AccessContext;
import com.jaspersoft.jasperserver.api.logging.access.domain.AccessEvent;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.JSResourceNotFoundException;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceValidator;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.FolderMoveEvent;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositoryListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.ResourceMoveEvent;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateFilter;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.RepoManager;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.ContentRepoFileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResourceBase;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.RepositoryUtils;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.ResourceCriterionUtils;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.SortingUtils;
import com.jaspersoft.jasperserver.api.metadata.view.domain.Filter;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.search.IdAttribute;
import com.jaspersoft.jasperserver.api.search.ResultTransformer;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.api.search.SearchSorter;
import com.jaspersoft.jasperserver.api.search.TransformerFactory;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateRepositoryServiceImpl
extends HibernateDaoImpl
implements HibernateRepositoryService,
ReferenceResolver,
RepoManager {
    private static final Log log = LogFactory.getLog(HibernateRepositoryServiceImpl.class);
    protected static final int RESOURCE_NAME_LENGHT = 100;
    protected static final String TEMP_NAME_PREFIX = "*";
    protected static final int TEMP_NAME_PREFIX_LENGTH = "*".length();
    protected static final String CHILDREN_FOLDER_SUFFIX = "_files";
    protected static final String COPY_GENERATED_NAME_SEPARATOR = "_";
    private ResourceFactory resourceFactory;
    private ResourceFactory persistentClassMappings;
    private ClassMappingsObjectFactory validatorMappings;
    private ThreadLocal tempNameResources;
    private CollatorFactory collatorFactory = new DefaultCollatorFactory();
    private List repositoryListeners = new ArrayList();
    private RepositorySecurityChecker securityChecker;
    private boolean lockFoldersOnPathChange = true;
    private AuditContext auditContext;
    private AccessContext accessContext;

    public HibernateRepositoryServiceImpl() {
        this.tempNameResources = new ThreadLocal();
    }

    public ResourceFactory getPersistentClassMappings() {
        return this.persistentClassMappings;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public AccessContext getAccessContext() {
        return this.accessContext;
    }

    public void setAccessContext(AccessContext accessContext) {
        this.accessContext = accessContext;
    }

    public void setPersistentClassMappings(ResourceFactory persistentClassMappings) {
        this.persistentClassMappings = persistentClassMappings;
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public ClassMappingsObjectFactory getValidatorMappings() {
        return this.validatorMappings;
    }

    public void setValidatorMappings(ClassMappingsObjectFactory validatorMappings) {
        this.validatorMappings = validatorMappings;
    }

    public ResourceValidator getValidator(Resource resource) {
        return resource == null ? null : (ResourceValidator)this.validatorMappings.getClassObject(resource.getResourceType());
    }

    public RepositorySecurityChecker getSecurityChecker() {
        return this.securityChecker;
    }

    public void setSecurityChecker(RepositorySecurityChecker securityChecker) {
        this.securityChecker = securityChecker;
    }

    @Override
    public Resource getResource(ExecutionContext context, String uri) {
        return this.getResourceUnsecure(context, uri);
    }

    public Resource getResourceUnsecure(ExecutionContext context, final String uri) {
        return (Resource)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadResource(uri, null);
            }
        });
    }

    public Resource getResource(ExecutionContext context, final String uri, final Class resourceType) {
        return (Resource)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadResource(uri, resourceType);
            }
        });
    }

    private void auditResourceActivity(final String eventType, final String uri, final String resourceType) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                HibernateRepositoryServiceImpl.this.auditContext.createAuditEvent(eventType, uri, resourceType);
            }
        });
    }

    private void auditResourceCopyAndMove(final String eventType, final String sourceUri, final String destUri, final String resourceType) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                AuditEvent auditEvent = HibernateRepositoryServiceImpl.this.auditContext.createAuditEvent(eventType, sourceUri, resourceType);
                HibernateRepositoryServiceImpl.this.auditContext.addPropertyToAuditEvent("destFolderUri", (Object)destUri, auditEvent);
            }
        });
    }

    private void auditFolderActivity(final String eventType, final String uri) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                HibernateRepositoryServiceImpl.this.auditContext.createAuditEvent(eventType, uri, Folder.class.getName());
            }
        });
    }

    private void auditFolderActivity(final String eventType, final Folder folder) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                AuditEvent auditEvent = HibernateRepositoryServiceImpl.this.auditContext.createAuditEvent(eventType, folder.getURI(), Folder.class.getName());
                HibernateRepositoryServiceImpl.this.auditContext.addPropertyToAuditEvent("folderName", (Object)folder.getName(), auditEvent);
                HibernateRepositoryServiceImpl.this.auditContext.addPropertyToAuditEvent("folderLabel", (Object)folder.getLabel(), auditEvent);
                HibernateRepositoryServiceImpl.this.auditContext.addPropertyToAuditEvent("folderDescription", (Object)folder.getDescription(), auditEvent);
            }
        });
    }

    private void auditFolderCopyAndMove(final String eventType, final String sourceUri, final String destUri) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                AuditEvent auditEvent = HibernateRepositoryServiceImpl.this.auditContext.createAuditEvent(eventType, sourceUri, Folder.class.getName());
                HibernateRepositoryServiceImpl.this.auditContext.addPropertyToAuditEvent("destFolderUri", (Object)destUri, auditEvent);
            }
        });
    }

    private void closeAuditEvent(String eventType) {
        this.auditContext.doInAuditContext(eventType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                HibernateRepositoryServiceImpl.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    private void logAccessResource(final RepoResource repoResource, final boolean updating) {
        this.accessContext.doInAccessContext(new AccessContext.AccessContextCallback(){

            public void fillAccessEvent(AccessEvent accessEvent) {
                accessEvent.setResource((Resource)repoResource.toClient(HibernateRepositoryServiceImpl.this.resourceFactory));
                accessEvent.setUpdating(updating);
            }
        });
    }

    protected Object loadResource(String uri, Class resourceType) {
        Resource resource;
        Class persistentClass = this.resourcePersistentClass(resourceType);
        RepoResource repoResource = this.findByURI(persistentClass, uri, false);
        if (repoResource == null) {
            resource = null;
        } else {
            this.auditResourceActivity("accessResource", uri, repoResource.getClientType().getName());
            this.logAccessResource(repoResource, false);
            resource = (Resource)repoResource.toClient(this.resourceFactory);
            this.closeAuditEvent("accessResource");
        }
        return resource;
    }

    public ResourceLookup getResourceLookupUnsecure(ExecutionContext context, final String uri) {
        return (ResourceLookup)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadResourceLookup(uri, null);
            }
        });
    }

    protected ResourceLookup loadResourceLookup(String uri, Class resourceType) {
        Class persistentClass = this.resourcePersistentClass(resourceType);
        RepoResource repoResource = this.findByURI(persistentClass, uri, false);
        ResourceLookup resource = repoResource == null ? null : repoResource.toClientLookup();
        return resource;
    }

    protected Class resourcePersistentClass(Class resourceType) {
        Class persistentClass = resourceType == null ? RepoResource.class : this.getPersistentClassMappings().getImplementationClass(resourceType);
        return persistentClass;
    }

    public void saveFolder(ExecutionContext context, final Folder folder) {
        final HibernateRepositoryServiceImpl manager = this;
        final ExecutionContext executionContext = context;
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                String parentURI;
                String eventType;
                RepoFolder repoFolder = HibernateRepositoryServiceImpl.this.getFolder(folder.getURIString(), false);
                if (folder.isNew()) {
                    eventType = "createFolder";
                    HibernateRepositoryServiceImpl.this.auditFolderActivity(eventType, folder);
                    if (repoFolder != null || HibernateRepositoryServiceImpl.this.resourceExists(folder.getURIString())) {
                        throw new JSDuplicateResourceException("jsexception.folder.already.exists", new Object[]{folder.getURIString()});
                    }
                    repoFolder = HibernateRepositoryServiceImpl.this.createNewRepoFolder();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating new folder " + folder.getURIString()));
                    }
                } else {
                    eventType = "updateFolder";
                    HibernateRepositoryServiceImpl.this.auditFolderActivity(eventType, folder);
                    if (repoFolder == null) {
                        String quotedURI = "\"" + folder.getURIString() + "\"";
                        throw new JSException("jsexception.folder.not.found", new Object[]{quotedURI});
                    }
                }
                RepoFolder parent = (parentURI = folder.getParentFolder()) == null && folder.getName().equals("/") ? null : HibernateRepositoryServiceImpl.this.getFolder(parentURI, true);
                repoFolder.set(folder, parent, manager);
                if (executionContext != null && executionContext.getAttributes() != null && executionContext.getAttributes().contains("isImporting") && folder.getUpdateDate() != null) {
                    repoFolder.setUpdateDate(folder.getUpdateDate());
                }
                HibernateRepositoryServiceImpl.this.getHibernateTemplate().saveOrUpdate((Object)repoFolder);
                HibernateRepositoryServiceImpl.this.closeAuditEvent(eventType);
                return null;
            }
        });
    }

    protected RepoFolder createNewRepoFolder() {
        RepoFolder repoFolder = new RepoFolder();
        repoFolder.setCreationDate(this.getOperationTimestamp());
        repoFolder.setUpdateDate(this.getOperationTimestamp());
        return repoFolder;
    }

    protected RepoFolder getFolder(String uri, boolean required) {
        RepoFolder folder;
        if (uri == null || uri.length() == 0 || uri.equals("/")) {
            return this.getRootFolder();
        }
        String repoURIPrefix = "repo:";
        String workUri = uri.startsWith("repo:") ? uri.substring("repo:".length()) : uri;
        DetachedCriteria criteria = DetachedCriteria.forClass(RepoFolder.class);
        criteria.add((Criterion)Restrictions.naturalId().set("URI", (Object)workUri));
        List foldersList = this.getHibernateTemplate().findByCriteria(criteria);
        if (foldersList.isEmpty()) {
            if (required) {
                String quotedURI = "\"" + uri + "\"";
                throw new JSResourceNotFoundException("jsexception.folder.not.found.at", new Object[]{quotedURI});
            }
            log.debug((Object)("Folder not found at \"" + uri + "\""));
            folder = null;
        } else {
            folder = (RepoFolder)foldersList.get(0);
        }
        return folder;
    }

    protected RepoFolder getRootFolder() {
        DetachedCriteria criteria = DetachedCriteria.forClass(RepoFolder.class);
        criteria.add((Criterion)Restrictions.naturalId().set("URI", (Object)"/"));
        List foldersList = this.getHibernateTemplate().findByCriteria(criteria);
        RepoFolder root = foldersList.isEmpty() ? null : (RepoFolder)foldersList.get(0);
        return root;
    }

    public ValidationErrors validateResource(ExecutionContext context, Resource resource, ValidationErrorFilter filter) {
        return this.validate(resource, filter);
    }

    protected ValidationErrors validate(Resource resource, ValidationErrorFilter filter) {
        ResourceValidator validator = this.getValidator(resource);
        if (validator != null) {
            return validator.validate(resource, filter);
        }
        return new ValidationErrorsImpl();
    }

    public ValidationErrors validateFolder(ExecutionContext context, Folder folder, ValidationErrorFilter filter) {
        return this.validate((Resource)folder, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveResource(ExecutionContext executionContext, Resource res) {
        this.initTempNameResources();
        final ExecutionContext context = executionContext;
        final Resource resource = res;
        try {
            this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

                public Object execute() {
                    String eventType;
                    boolean isOverwriting;
                    RepoResource repo = HibernateRepositoryServiceImpl.this.getRepoResource(resource);
                    boolean isImporting = context != null && context.getAttributes() != null && context.getAttributes().contains("isImporting");
                    boolean bl = isOverwriting = context != null && context.getAttributes() != null && context.getAttributes().contains("isOverwriting");
                    if (repo.isNew()) {
                        eventType = "saveResource";
                        HibernateRepositoryServiceImpl.this.auditResourceActivity(eventType, resource.getURI(), resource.getResourceType());
                    } else {
                        eventType = isOverwriting ? "overwriteResource" : "updateResource";
                        HibernateRepositoryServiceImpl.this.auditResourceActivity(eventType, resource.getURI(), repo.getClientType().getName());
                    }
                    repo.copyFromClient(resource, HibernateRepositoryServiceImpl.this);
                    if (isImporting) {
                        repo.setCreationDate(HibernateRepositoryServiceImpl.this.getOperationTimestamp());
                        repo.setUpdateDate(resource.getUpdateDate() == null ? HibernateRepositoryServiceImpl.this.getOperationTimestamp() : repo.getUpdateDate());
                    } else {
                        if (isOverwriting) {
                            repo.setCreationDate(HibernateRepositoryServiceImpl.this.getOperationTimestamp());
                        }
                        repo.setUpdateDate(HibernateRepositoryServiceImpl.this.getOperationTimestamp());
                    }
                    RepoResource repositoryResource = repo;
                    HibernateRepositoryServiceImpl.this.getHibernateTemplate().saveOrUpdate((Object)repositoryResource);
                    HibernateRepositoryServiceImpl.this.logAccessResource(repositoryResource, true);
                    HibernateRepositoryServiceImpl.this.closeAuditEvent(eventType);
                    return null;
                }
            });
            if (this.tempNameResources() != null && !this.tempNameResources().isEmpty()) {
                this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

                    public Object execute() {
                        HibernateTemplate template = HibernateRepositoryServiceImpl.this.getHibernateTemplate();
                        for (RepoResource res : HibernateRepositoryServiceImpl.this.tempNameResources()) {
                            res.setName(res.getName().substring(TEMP_NAME_PREFIX_LENGTH));
                            RepoFolder childrenFolder = res.getChildrenFolder();
                            if (childrenFolder != null) {
                                childrenFolder.setName(childrenFolder.getName().substring(TEMP_NAME_PREFIX_LENGTH));
                                childrenFolder.refreshURI(HibernateRepositoryServiceImpl.this);
                            }
                            template.save((Object)res);
                        }
                        return null;
                    }
                });
            }
        }
        finally {
            this.resetTempNameResources();
        }
    }

    @Deprecated
    public void saveResource(ExecutionContext context, Resource resource, boolean updateCreationDate) {
        if (updateCreationDate) {
            if (context == null) {
                context = new ExecutionContextImpl();
            }
            if (context.getAttributes() == null) {
                context.setAttributes(new ArrayList());
            }
            context.getAttributes().add("isOverwriting");
        }
        this.saveResource(context, resource);
    }

    protected void initTempNameResources() {
        if (this.tempNameResources() == null) {
            this.tempNameResources.set(new HashSet());
        }
    }

    protected void resetTempNameResources() {
        this.tempNameResources.set(null);
    }

    protected Set tempNameResources() {
        return (Set)this.tempNameResources.get();
    }

    @Override
    public RepoResource getRepoResource(Resource resource) {
        RepoResource repo;
        Class persistentClass = this.getPersistentClassMappings().getImplementationClass(resource.getClass());
        if (persistentClass == null) {
            String quotedResource = "\"" + resource.getClass().getName() + "\"";
            throw new JSException("jsexception.no.persistent.class.mapped.to", new Object[]{quotedResource});
        }
        if (resource.isNew()) {
            if (this.pathExists(resource.getURIString())) {
                String quotedResource = "\"" + resource.getURIString() + "\"";
                throw new JSDuplicateResourceException("jsexception.resource.already.exists", new Object[]{quotedResource});
            }
            repo = this.createPersistentResource(persistentClass);
            RepoFolder parent = this.getFolder(resource.getParentFolder(), true);
            repo.setParent(parent);
        } else {
            repo = this.findByURI(persistentClass, resource.getURIString(), false);
            if (repo == null) {
                String quotedURI = "\"" + resource.getURIString() + "\"";
                throw new JSException("jsexception.resource.does.not.exist", new Object[]{quotedURI});
            }
        }
        return repo;
    }

    public boolean resourceExists(ExecutionContext executionContext, String uri) {
        return this.resourceExists(uri);
    }

    public boolean resourceExists(ExecutionContext executionContext, String uri, Class resourceType) {
        return this.resourceExists(uri, resourceType);
    }

    public boolean resourceExists(ExecutionContext executionContext, FilterCriteria filterCriteria) {
        boolean exists;
        DetachedCriteria criteria = this.translateFilterToCriteria(filterCriteria);
        if (criteria == null) {
            exists = false;
        } else {
            criteria.setProjection(Projections.rowCount());
            List countList = this.getHibernateTemplate().findByCriteria(criteria);
            int count = (Integer)countList.get(0);
            exists = count > 0;
        }
        return exists;
    }

    protected boolean resourceExists(String uri) {
        return this.resourceExists(uri, null);
    }

    protected boolean resourceExists(String uri, Class type) {
        int sep = uri.lastIndexOf("/");
        boolean exists = false;
        if (sep >= 0) {
            String name = uri.substring(sep + Folder.SEPARATOR_LENGTH);
            String folderName = uri.substring(0, sep);
            RepoFolder folder = this.getFolder(folderName, false);
            if (folder != null) {
                exists = this.resourceExists(folder, name, type);
            }
        }
        return exists;
    }

    @Override
    public ResourceLookup[] findResource(final ExecutionContext context, final FilterCriteria filterCriteria) {
        return (ResourceLookup[])this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadResources(context, filterCriteria);
            }
        });
    }

    public ResourceLookup[] findResources(final ExecutionContext context, final FilterCriteria[] filterCriteria) {
        return (ResourceLookup[])this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadResources(context, filterCriteria);
            }
        });
    }

    public List loadClientResources(FilterCriteria filterCriteria) {
        List repoResources = this.loadRepoResourceList(filterCriteria);
        ArrayList<Object> result = new ArrayList<Object>(repoResources.size());
        for (RepoResource repoResource : repoResources) {
            result.add(repoResource.toClient(this.resourceFactory));
        }
        return result;
    }

    public List loadResourcesList(FilterCriteria filterCriteria) {
        return this.loadResourcesList(null, filterCriteria);
    }

    public List loadResourcesList(ExecutionContext context, FilterCriteria filterCriteria) {
        List repoResources = this.loadRepoResourceList(context, filterCriteria);
        return this.toLookups(repoResources, false);
    }

    public List loadResourcesList(ExecutionContext context, FilterCriteria[] filterCriteria) {
        List repoResources;
        if (filterCriteria.length == 1) {
            repoResources = this.loadRepoResourceList(context, filterCriteria[0]);
        } else {
            repoResources = new ArrayList();
            for (int i = 0; i < filterCriteria.length; ++i) {
                FilterCriteria criteria = filterCriteria[i];
                List criteriaRes = this.loadRepoResourceList(context, criteria, false);
                if (criteriaRes == null) continue;
                repoResources.addAll(criteriaRes);
            }
            this.sortRepoResourcesByURI(context, repoResources);
        }
        return this.toLookups(repoResources, false);
    }

    public List<Long> getResourcesIds(ExecutionContext context, String text, Class type, Class aClass, List<SearchFilter> filters, Map<String, SearchFilter> typeSpecificFilters, SearchSorter sorter, TransformerFactory transformerFactory, int firstResult, int maxResult) {
        if (transformerFactory == null) {
            throw new IllegalArgumentException("Transformer factory is null.");
        }
        SearchCriteria criteria = this.getResourcesListCriteria(context, text, type, aClass, filters, typeSpecificFilters);
        ProjectionList distinctProperties = Projections.projectionList().add((Projection)Projections.id());
        criteria.addProjection(Projections.distinct((Projection)distinctProperties));
        if (sorter != null) {
            sorter.applyOrder(type.getName(), context, criteria);
        }
        List list = this.getHibernateTemplate().findByCriteria((DetachedCriteria)criteria, firstResult, maxResult);
        ArrayList<Long> ids = new ArrayList<Long>();
        ResultTransformer transformer = transformerFactory.createTransformer(filters, sorter);
        if (transformer == null) {
            throw new IllegalArgumentException("Result transformer is null.");
        }
        ids.addAll(transformer.transformToIdList(list));
        return ids;
    }

    public List<ResourceLookup> getResourcesByIdList(List<Long> idList) {
        List<RepoResource> resourceList = new ArrayList<RepoResource>();
        if (!idList.isEmpty()) {
            DetachedCriteria criteria = DetachedCriteria.forClass(RepoResource.class);
            criteria.add(Restrictions.in((String)"id", idList));
            resourceList = this.getHibernateTemplate().findByCriteria(criteria);
        }
        List orderedResourceList = this.orderByIdList(resourceList, idList);
        return this.toLookups(orderedResourceList, true);
    }

    private List orderByIdList(List<RepoResource> resourceList, List<Long> idList) {
        ArrayList<RepoResource> orderedList = new ArrayList<RepoResource>();
        for (Long id : idList) {
            for (RepoResource repoResource : resourceList) {
                if (repoResource.getId() != id.longValue()) continue;
                orderedList.add(repoResource);
            }
        }
        return orderedList;
    }

    public Map<Class, Integer> loadResourcesMapCount(ExecutionContext context, String text, List<Class> resourceTypeList, List<SearchFilter> filters, Map<String, SearchFilter> typeSpecificFilters, SearchSorter sorter, TransformerFactory transformerFactory) {
        if (transformerFactory == null) {
            throw new IllegalArgumentException("Transformer factory is null.");
        }
        HashMap<Class, Integer> result = new HashMap<Class, Integer>();
        Map<Class, Class> typeToPersistentClassMap = this.getTypeToPersistentClassMap(resourceTypeList);
        for (Map.Entry<Class, Class> entry : typeToPersistentClassMap.entrySet()) {
            SearchCriteria criteria = this.getResourcesListCriteria(context, text, entry.getKey(), entry.getValue(), filters, typeSpecificFilters);
            criteria.setProjection((Projection)Projections.countDistinct((String)"id"));
            List resourceList = this.getHibernateTemplate().findByCriteria((DetachedCriteria)criteria);
            ResultTransformer transformer = transformerFactory.createTransformer(filters, sorter);
            if (transformer != null) {
                result.put(entry.getKey(), transformer.transformToCount(resourceList));
                continue;
            }
            throw new IllegalArgumentException("Result transformer is null.");
        }
        return result;
    }

    private SearchCriteria getResourcesListCriteria(ExecutionContext context, String text, Class type, Class aClass, List<SearchFilter> filters, Map<String, SearchFilter> typeSpecificFilters) {
        SearchCriteria criteria = SearchCriteria.forClass((Class)aClass);
        if (filters != null) {
            for (SearchFilter filter : filters) {
                filter.applyRestrictions(type.getName(), context, criteria);
            }
        }
        if (typeSpecificFilters != null && typeSpecificFilters.get(type.getName()) != null) {
            typeSpecificFilters.get(type.getName()).applyRestrictions(type.getName(), context, criteria);
        } else {
            String st = text == null ? "" : text;
            criteria.add(ResourceCriterionUtils.getTextCriterion(st));
        }
        String p = criteria.getAlias("parent", "p");
        criteria.add((Criterion)Restrictions.eq((String)(p + ".hidden"), (Object)Boolean.FALSE));
        return criteria;
    }

    private Map<Class, Class> getTypeToPersistentClassMap(List<Class> resourceTypeList) {
        HashMap<Class, Class> typeToPersistentClassMap = new HashMap<Class, Class>();
        if (resourceTypeList == null) {
            typeToPersistentClassMap.put(null, RepoResource.class);
        } else {
            for (Class aClass : resourceTypeList) {
                Class persistentClass = this.getPersistentClassMappings().getImplementationClass(aClass);
                if (persistentClass == null) {
                    throw new JSResourceNotFoundException("jsexception.resource.of.type.not.found", new Object[]{"", aClass.getName()});
                }
                typeToPersistentClassMap.put(aClass, persistentClass);
            }
        }
        return typeToPersistentClassMap;
    }

    protected List toLookups(List repoResources, boolean addIdAsAttr) {
        ArrayList<ResourceLookup> result = new ArrayList<ResourceLookup>(repoResources.size());
        for (RepoResource repoResource : repoResources) {
            ResourceLookup resourceLookup = repoResource.toClientLookup();
            if (addIdAsAttr) {
                ArrayList<IdAttribute> attrList = resourceLookup.getAttributes();
                if (attrList == null) {
                    attrList = new ArrayList<IdAttribute>();
                    resourceLookup.setAttributes(attrList);
                }
                attrList.add(new IdAttribute(Long.valueOf(repoResource.getId())));
            }
            result.add(resourceLookup);
        }
        return result;
    }

    protected ResourceLookup[] loadResources(ExecutionContext context, FilterCriteria filterCriteria) {
        List repoResources = this.loadResourcesList(context, filterCriteria);
        ResourceLookup[] resourceLookups = new ResourceLookup[repoResources.size()];
        resourceLookups = repoResources.toArray(resourceLookups);
        return resourceLookups;
    }

    protected ResourceLookup[] loadResources(ExecutionContext context, FilterCriteria[] filterCriteria) {
        List repoResources = this.loadResourcesList(context, filterCriteria);
        ResourceLookup[] resourceLookups = new ResourceLookup[repoResources.size()];
        resourceLookups = repoResources.toArray(resourceLookups);
        return resourceLookups;
    }

    public List loadRepoResourceList(FilterCriteria filterCriteria) {
        return this.loadRepoResourceList(null, filterCriteria);
    }

    protected List loadRepoResourceList(ExecutionContext context, FilterCriteria filterCriteria) {
        return this.loadRepoResourceList(context, filterCriteria, true);
    }

    public List loadRepoResourceList(ExecutionContext context, FilterCriteria filterCriteria, boolean sort) {
        DetachedCriteria criteria = this.translateFilterToCriteria(filterCriteria);
        if (criteria == null) {
            return new ArrayList();
        }
        List repoResources = this.getHibernateTemplate().findByCriteria(criteria);
        if (sort) {
            this.sortRepoResourcesByURI(context, repoResources);
        }
        return repoResources;
    }

    protected DetachedCriteria translateFilterToCriteria(FilterCriteria filterCriteria) {
        DetachedCriteria criteria;
        Class filterClass = filterCriteria == null ? null : filterCriteria.getFilterClass();
        Class persistentClass = filterClass == null ? RepoResource.class : this.getPersistentClassMappings().getImplementationClass(filterClass);
        if (persistentClass == null) {
            criteria = null;
        } else {
            List filterElements;
            criteria = DetachedCriteria.forClass((Class)persistentClass);
            criteria.createAlias("parent", "parent");
            criteria.add((Criterion)Restrictions.eq((String)"parent.hidden", (Object)Boolean.FALSE));
            if (filterCriteria != null && !(filterElements = filterCriteria.getFilterElements()).isEmpty()) {
                Conjunction conjunction = Restrictions.conjunction();
                HibernateFilter filter = new HibernateFilter((Junction)conjunction, this);
                for (FilterElement filterElement : filterElements) {
                    filterElement.apply((Filter)filter);
                }
                criteria.add((Criterion)conjunction);
            }
        }
        return criteria;
    }

    protected void sortRepoResourcesByURI(ExecutionContext context, List repoResources) {
        SortingUtils.sortRepoResourcesByURI(this.getCollator(context), repoResources);
    }

    @Override
    public Resource newResource(ExecutionContext context, Class _class) {
        return this.resourceFactory.newResource(context, _class);
    }

    @Override
    public RepoResource findByURI(Class persistentClass, String uri, boolean required) {
        if (uri == null) {
            throw new JSException("jsexception.null.uri");
        }
        String repoURIPrefix = "repo:";
        String workUri = uri.startsWith("repo:") ? uri.substring("repo:".length()) : uri;
        int sep = workUri.lastIndexOf("/");
        RepoResource res = null;
        if (sep >= 0) {
            String name = workUri.substring(sep + Folder.SEPARATOR_LENGTH);
            String folderName = workUri.substring(0, sep);
            log.debug((Object)("Looking for name: " + name + " in folder: " + folderName));
            RepoFolder folder = this.getFolder(folderName, false);
            if (folder != null) {
                res = this.findByName(persistentClass, folder, name, required);
            } else {
                log.debug((Object)("No folder: " + folderName));
            }
        }
        if (res == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource of type " + persistentClass.getName() + " not found at " + uri));
            }
            if (required) {
                String quotedURI = "\"" + uri + "\"";
                throw new JSResourceNotFoundException("jsexception.resource.of.type.not.found", new Object[]{quotedURI, persistentClass});
            }
        }
        return res;
    }

    protected RepoResource findByName(Class persistentClass, RepoFolder folder, String name, boolean required) {
        RepoResource res;
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)persistentClass);
        criteria.add((Criterion)Restrictions.naturalId().set("name", (Object)name).set("parent", (Object)folder));
        List resourceList = this.getHibernateTemplate().findByCriteria(criteria);
        if (resourceList.isEmpty()) {
            if (required) {
                String uri = "\"" + folder.getURI() + "/" + name + "\"";
                throw new JSResourceNotFoundException("jsexception.resource.of.type.not.found", new Object[]{uri, persistentClass});
            }
            res = null;
        } else {
            res = (RepoResource)resourceList.get(0);
        }
        return res;
    }

    protected boolean resourceExists(RepoFolder folder, String name, Class resourceType) {
        Class persistentClass = this.resourcePersistentClass(resourceType);
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)persistentClass);
        criteria.add((Criterion)Restrictions.naturalId().set("name", (Object)name).set("parent", (Object)folder));
        criteria.setProjection(Projections.rowCount());
        List countList = this.getHibernateTemplate().findByCriteria(criteria);
        int count = (Integer)countList.get(0);
        return count > 0;
    }

    protected boolean folderExists(RepoFolder parent, String name) {
        String uri = parent.isRoot() ? "/" + name : parent.getURI() + "/" + name;
        return this.folderExists(uri);
    }

    protected RepoResource createPersistentResource(Class persistentClass) {
        try {
            RepoResource repo = (RepoResource)persistentClass.newInstance();
            repo.setCreationDate(this.getOperationTimestamp());
            repo.setUpdateDate(this.getOperationTimestamp());
            return repo;
        }
        catch (InstantiationException e) {
            log.fatal((Object)"Error instantiating persistent resource", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        catch (IllegalAccessException e) {
            log.fatal((Object)"Error instantiating persistent resource", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected RepoResource getRepositoryReference(RepoResource owner, Resource res) {
        Class persistentClass = this.getPersistentClassMappings().getImplementationClass(res.getClass());
        if (persistentClass == null) {
            String quotedClass = "\"" + res.getClass().getName() + "\"";
            throw new JSException("jsexception.no.persistent.class.mapped.to", new Object[]{quotedClass});
        }
        RepoResource repo = null;
        RepoFolder folder = owner.getChildrenFolder();
        if (res.isNew()) {
            boolean tempName = folder != null && !folder.isNew() && this.resourceExists(folder, res.getName(), null);
            repo = this.createPersistentResource(persistentClass);
            if (tempName) {
                this.tempNameResources().add(repo);
            }
        } else {
            if (folder != null && !folder.isNew()) {
                repo = this.findByName(persistentClass, folder, res.getName(), false);
            }
            if (repo == null) {
                String quotedResource = "\"" + res.getURIString() + "\"";
                throw new JSException("jsexception.resource.does.not.exist", new Object[]{quotedResource});
            }
        }
        return repo;
    }

    @Override
    public RepoResource getReference(RepoResource owner, ResourceReference resourceRef, Class persistentReferenceClass) {
        if (resourceRef == null) {
            return null;
        }
        RepoResource repoRes = resourceRef.isLocal() ? this.getReference(owner, resourceRef.getLocalResource(), persistentReferenceClass) : this.findByURI(persistentReferenceClass, resourceRef.getReferenceURI(), true);
        return repoRes;
    }

    @Override
    public RepoResource getReference(RepoResource owner, Resource resource, Class persistentReferenceClass) {
        return this.getReference(owner, resource, persistentReferenceClass, this);
    }

    protected RepoResource getReference(RepoResource owner, Resource resource, Class persistentReferenceClass, ReferenceResolver referenceResolver) {
        if (resource == null) {
            return null;
        }
        RepoResource repoRes = this.getRepositoryReference(owner, resource);
        RepoFolder local = owner.getChildrenFolder();
        if (local == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating children folder for " + this));
            }
            local = this.createNewRepoFolder();
            local.setName(this.getChildrenFolderName(owner.getName()));
            local.setLabel(owner.getLabel());
            local.setDescription(owner.getDescription());
            local.setParent(owner.getParent());
            local.setHidden(true);
            local.refreshURI(this);
            owner.setChildrenFolder(local);
        }
        owner.addNewChild(repoRes);
        repoRes.copyFromClient(resource, referenceResolver);
        if (this.tempNameResources().contains(repoRes)) {
            repoRes.setName(TEMP_NAME_PREFIX + repoRes.getName());
            RepoFolder childrenFolder = repoRes.getChildrenFolder();
            if (childrenFolder != null) {
                childrenFolder.setName(TEMP_NAME_PREFIX + childrenFolder.getName());
                childrenFolder.refreshURI(this);
            }
        }
        return repoRes;
    }

    public List getAllFolders(final ExecutionContext context) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadAllSubfolders(context, null);
            }
        });
    }

    protected List loadAllSubfolders(ExecutionContext context, String parentURI) {
        DetachedCriteria criteria = DetachedCriteria.forClass(RepoFolder.class);
        criteria.add((Criterion)Restrictions.eq((String)"hidden", (Object)Boolean.FALSE));
        if (parentURI != null && !"/".equals(parentURI)) {
            criteria.add((Criterion)Restrictions.or((Criterion)(parentURI.indexOf("%") == -1 ? Restrictions.eq((String)"URI", (Object)parentURI) : Restrictions.like((String)"URI", (Object)parentURI)), (Criterion)Restrictions.like((String)"URI", (Object)(parentURI + "/%"))));
        }
        List repoFolders = this.getHibernateTemplate().findByCriteria(criteria);
        ArrayList<Folder> folders = new ArrayList<Folder>(repoFolders.size());
        for (RepoFolder repoFolder : repoFolders) {
            Folder folder = repoFolder.toClient();
            folders.add(folder);
        }
        SortingUtils.sortFoldersByURI(this.getCollator(context), folders);
        return folders;
    }

    public List getAllSubfolders(final ExecutionContext context, final String parentURI) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadAllSubfolders(context, parentURI);
            }
        });
    }

    public List getSubFolders(final ExecutionContext context, final String folderURI) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                ArrayList<Folder> subfolders;
                final RepoFolder folder = HibernateRepositoryServiceImpl.this.getFolder(folderURI, false);
                if (folder == null || folder.getSubFolders() == null) {
                    subfolders = new ArrayList<Folder>();
                } else {
                    List folders = HibernateRepositoryServiceImpl.this.getHibernateTemplate().executeFind(new HibernateCallback(){

                        public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                            return session.createFilter((Object)folder.getSubFolders(), "where hidden = false").list();
                        }
                    });
                    subfolders = new ArrayList(folders.size());
                    for (RepoFolder repoFolder : folders) {
                        subfolders.add(repoFolder.toClient());
                    }
                    SortingUtils.sortFoldersByName(HibernateRepositoryServiceImpl.this.getCollator(context), subfolders);
                }
                return subfolders;
            }
        });
    }

    @Override
    public FileResourceData getResourceData(ExecutionContext context, final String uri) throws JSResourceNotFoundException {
        return (FileResourceData)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                RepoFileResource res = (RepoFileResource)HibernateRepositoryServiceImpl.this.findByURI(RepoFileResource.class, uri, true);
                while (res.isFileReference()) {
                    res = res.getReference();
                }
                return res.copyData();
            }
        });
    }

    public FileResourceData getContentResourceData(ExecutionContext context, final String uri) throws JSResourceNotFoundException {
        return (FileResourceData)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                ContentRepoFileResource res = (ContentRepoFileResource)HibernateRepositoryServiceImpl.this.findByURI(ContentRepoFileResource.class, uri, true);
                return res.copyData();
            }
        });
    }

    @Override
    public RepoResource getExternalReference(String uri, Class persistentReferenceClass) {
        return this.findByURI(persistentReferenceClass, uri, true);
    }

    @Override
    public RepoResource getPersistentReference(String uri, Class clientReferenceClass) {
        return this.findByURI(this.resourcePersistentClass(clientReferenceClass), uri, true);
    }

    @Override
    public void deleteResource(ExecutionContext context, final String uri) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateRepositoryServiceImpl.this.deleteResource(uri);
                return null;
            }
        });
    }

    protected void deleteResource(String uri) {
        RepoResource repoResource = this.findByURI(RepoResource.class, uri, true);
        this.auditResourceActivity("deleteResource", uri, repoResource.getClientType().getName());
        this.getHibernateTemplate().delete((Object)repoResource);
        this.closeAuditEvent("deleteResource");
    }

    @Override
    public void deleteFolder(ExecutionContext context, final String uri) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateRepositoryServiceImpl.this.deleteFolder(uri);
                return null;
            }
        });
    }

    protected void deleteFolder(String uri) {
        this.auditFolderActivity("deleteFolder", uri);
        RepoFolder folder = this.getFolder(uri, true);
        if (folder.isRoot()) {
            throw new JSException("jsexception.folder.delete.root");
        }
        this.getHibernateTemplate().delete((Object)folder);
        this.closeAuditEvent("deleteFolder");
    }

    @Override
    public void delete(ExecutionContext context, final String[] resourceURIs, final String[] folderURIs) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                int i;
                if (resourceURIs != null && resourceURIs.length > 0) {
                    for (i = 0; i < resourceURIs.length; ++i) {
                        HibernateRepositoryServiceImpl.this.deleteResource(resourceURIs[i]);
                    }
                }
                if (folderURIs != null && folderURIs.length > 0) {
                    for (i = 0; i < folderURIs.length; ++i) {
                        HibernateRepositoryServiceImpl.this.deleteFolder(folderURIs[i]);
                    }
                }
                return null;
            }
        });
    }

    public Folder getFolder(ExecutionContext context, String uri) {
        return this.getFolderUnsecure(context, uri);
    }

    public boolean folderExists(ExecutionContext context, String uri) {
        return this.folderExists(uri);
    }

    public Folder getFolderUnsecure(ExecutionContext context, final String uri) {
        return (Folder)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                RepoFolder repoFolder = HibernateRepositoryServiceImpl.this.getFolder(uri, false);
                Folder folder = repoFolder == null ? null : repoFolder.toClient();
                return folder;
            }
        });
    }

    protected boolean folderExists(String uri) {
        return this.getFolder(uri, false) != null;
    }

    public String getChildrenFolderName(String resourceName) {
        return resourceName + CHILDREN_FOLDER_SUFFIX;
    }

    public CollatorFactory getCollatorFactory() {
        return this.collatorFactory;
    }

    public void setCollatorFactory(CollatorFactory collatorFactory) {
        this.collatorFactory = collatorFactory;
    }

    protected Collator getCollator(ExecutionContext context) {
        return this.getCollatorFactory().getCollator(context);
    }

    protected boolean pathExists(String uri) {
        return this.resourceExists(uri) || this.folderExists(uri);
    }

    public boolean repositoryPathExists(ExecutionContext context, String uri) {
        return this.pathExists(uri);
    }

    public void hideFolder(String uri) {
        this.setFolderHiddenFlag(uri, true);
    }

    public void unhideFolder(String uri) {
        this.setFolderHiddenFlag(uri, false);
    }

    private void setFolderHiddenFlag(String uri, boolean hidden) {
        RepoFolder folder = this.getFolder(uri, false);
        if (folder != null && folder.isHidden() != hidden) {
            folder.setHidden(hidden);
            this.getHibernateTemplate().saveOrUpdate((Object)folder);
        }
    }

    public void moveFolder(ExecutionContext context, final String sourceURI, final String destinationFolderURI) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateRepositoryServiceImpl.this.auditFolderCopyAndMove("moveFolder", sourceURI, destinationFolderURI);
                RepoFolder source = HibernateRepositoryServiceImpl.this.getFolder(sourceURI, true);
                RepoFolder dest = HibernateRepositoryServiceImpl.this.getFolder(destinationFolderURI, true);
                if (HibernateRepositoryServiceImpl.this.isAncestorOrEqual(source.getResourceURI(), dest.getResourceURI())) {
                    throw new JSException("jsexception.move.folder.source.uri.ancestor.destination", new Object[]{sourceURI, destinationFolderURI});
                }
                if (source.getParent().getResourceURI().equals(dest.getResourceURI())) {
                    throw new JSException("jsexception.move.folder.to.same.folder", new Object[]{sourceURI, destinationFolderURI});
                }
                if (HibernateRepositoryServiceImpl.this.nameExistsInFolder(dest, source.getName())) {
                    throw new JSException("jsexception.move.folder.path.already.exists", new Object[]{sourceURI, destinationFolderURI});
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Moving folder " + source.getResourceURI() + " to " + dest.getResourceURI()));
                }
                source.moveTo(dest, HibernateRepositoryServiceImpl.this);
                HibernateRepositoryServiceImpl.this.closeAuditEvent("moveFolder");
                return null;
            }
        });
    }

    public void moveResource(ExecutionContext context, final String sourceURI, final String destinationFolderURI) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                RepoResource source = HibernateRepositoryServiceImpl.this.findByURI(RepoResource.class, sourceURI, true);
                RepoFolder dest = HibernateRepositoryServiceImpl.this.getFolder(destinationFolderURI, true);
                HibernateRepositoryServiceImpl.this.auditResourceCopyAndMove("moveResource", sourceURI, destinationFolderURI, source.getClientType().getName());
                if (source.getParent().getResourceURI().equals(dest.getResourceURI())) {
                    throw new JSException("jsexception.move.resource.to.same.folder", new Object[]{sourceURI, destinationFolderURI});
                }
                if (HibernateRepositoryServiceImpl.this.nameExistsInFolder(dest, source.getName())) {
                    throw new JSException("jsexception.move.resource.path.already.exists", new Object[]{sourceURI, destinationFolderURI});
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Moving resource " + source.getResourceURI() + " to " + dest.getResourceURI()));
                }
                source.moveTo(dest, HibernateRepositoryServiceImpl.this);
                HibernateRepositoryServiceImpl.this.closeAuditEvent("moveResource");
                return null;
            }
        });
    }

    protected boolean isAncestorOrEqual(String ancestorURI, String childURI) {
        return RepositoryUtils.isAncestorOrEqual(ancestorURI, childURI);
    }

    @Override
    public void update(Object repoObject) {
        this.getHibernateTemplate().update(repoObject);
    }

    public List getRepositoryListeners() {
        return this.repositoryListeners;
    }

    public void setRepositoryListeners(List repositoryListeners) {
        this.repositoryListeners = repositoryListeners;
    }

    protected boolean nameExistsInFolder(RepoFolder folder, String name) {
        return this.resourceExists(folder, name, null) || this.folderExists(folder, name);
    }

    @Override
    public void folderMoved(RepoFolder folder, String oldBaseURI, String newBaseURI) {
        String newURI = folder.getResourceURI();
        String oldURI = this.getMovedOldURI(newURI, oldBaseURI, newBaseURI);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Folder " + oldURI + " has been moved to " + newURI));
        }
        FolderMoveEvent folderMove = new FolderMoveEvent(oldBaseURI, newBaseURI, oldURI, newURI);
        for (RepositoryListener listener : this.getRepositoryListeners()) {
            listener.folderMoved(folderMove);
        }
    }

    @Override
    public void resourceMoved(RepoResource resource, String oldBaseURI, String newBaseURI) {
        String newURI = resource.getResourceURI();
        String oldURI = this.getMovedOldURI(newURI, oldBaseURI, newBaseURI);
        Class type = resource.getClientType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource " + oldURI + " has been moved to " + newURI));
        }
        ResourceMoveEvent resourceMove = new ResourceMoveEvent(type, oldBaseURI, newBaseURI, oldURI, newURI);
        for (RepositoryListener listener : this.getRepositoryListeners()) {
            listener.resourceMoved(resourceMove);
        }
    }

    protected String getMovedOldURI(String newURI, String oldBaseURI, String newBaseURI) {
        if (!RepositoryUtils.isAncestorOrEqual(newBaseURI, newURI)) {
            throw new JSException("New folder URI " + newURI + " does not match new base URI " + newBaseURI);
        }
        String newPostBaseURI = newBaseURI.equals("/") ? newURI : newURI.substring(newBaseURI.length());
        String oldURI = oldBaseURI.equals("/") ? newPostBaseURI : oldBaseURI + newPostBaseURI;
        return oldURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource copyResource(ExecutionContext context, final String sourceURI, final String destinationURI) {
        this.initTempNameResources();
        try {
            Resource copy;
            Resource resource = copy = (Resource)this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

                public Object execute() {
                    RepoResource repoCopy = HibernateRepositoryServiceImpl.this.copyResource(sourceURI, destinationURI);
                    return repoCopy.toClient(HibernateRepositoryServiceImpl.this.resourceFactory);
                }
            });
            return resource;
        }
        finally {
            this.resetTempNameResources();
        }
    }

    protected RepoResource copyResource(String sourceURI, String destinationURI) {
        RepoResource sourceRepoResource = this.findByURI(RepoResource.class, sourceURI, true);
        this.auditResourceCopyAndMove("copyResource", sourceURI, destinationURI, sourceRepoResource.getClientType().getName());
        String copyURI = this.getCopyURI(destinationURI, true);
        RepoResource repoCopy = this.copyResource(sourceRepoResource, copyURI);
        this.closeAuditEvent("copyResource");
        return repoCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResources(ExecutionContext context, final String[] resources, final String destinationFolder) {
        this.initTempNameResources();
        try {
            this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

                public Object execute() {
                    HibernateRepositoryServiceImpl.this.copyResources(resources, destinationFolder);
                    return null;
                }
            });
        }
        finally {
            this.resetTempNameResources();
        }
    }

    protected void copyResources(String[] sourceURIs, String destinationFolder) {
        RepoResource[] sources = new RepoResource[sourceURIs.length];
        for (int i = 0; i < sourceURIs.length; ++i) {
            sources[i] = this.findByURI(RepoResource.class, sourceURIs[i], true);
        }
        RepoFolder destination = this.getFolder(destinationFolder, true);
        MultiResourceCopier copier = new MultiResourceCopier(sources, destination);
        copier.copy();
    }

    protected String getCopyURI(String destinationURI, boolean resource) {
        String parentURI = RepositoryUtils.getParentPath(destinationURI);
        RepoFolder parent = this.getFolder(parentURI, true);
        this.lockReadFolder(parent);
        String destinationName = RepositoryUtils.getName(destinationURI);
        String copyURI = this.makeCopyURI(parent, destinationName, resource);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using " + copyURI + " for copy at " + destinationURI));
        }
        return copyURI;
    }

    protected String makeCopyURI(RepoFolder destination, String name, boolean resource) {
        String copyURI;
        if (this.nameExistsInFolder(destination, name)) {
            String copyName;
            int maxNameLenght = 100;
            if (resource) {
                maxNameLenght -= CHILDREN_FOLDER_SUFFIX.length();
            }
            String baseName = name;
            int counter = 1;
            do {
                if ((copyName = baseName + COPY_GENERATED_NAME_SEPARATOR + counter).length() > maxNameLenght) {
                    String truncatedBaseName = baseName.substring(0, baseName.length() - copyName.length() + maxNameLenght);
                    copyName = truncatedBaseName + COPY_GENERATED_NAME_SEPARATOR + counter;
                }
                ++counter;
            } while (this.nameExistsInFolder(destination, copyName));
            copyURI = RepositoryUtils.concatenatePath(destination.getURI(), copyName);
        } else {
            copyURI = RepositoryUtils.concatenatePath(destination.getURI(), name);
        }
        return copyURI;
    }

    protected RepoResource copyResource(RepoResource resource, String copyURI) {
        Resource copy = this.getClientClone(resource);
        copy.setURIString(copyURI);
        RepoResource repoCopy = this.getRepoResource(copy);
        repoCopy.copyFromClient(copy, this);
        this.getHibernateTemplate().save((Object)repoCopy);
        return repoCopy;
    }

    protected Resource getClientClone(RepoResource resource) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("fullData", null);
        options.put("asNew", null);
        Resource copy = (Resource)resource.toClient(this.resourceFactory, options);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder copyFolder(ExecutionContext context, final String sourceURI, final String destinationURI) {
        this.initTempNameResources();
        this.auditFolderCopyAndMove("copyFolder", sourceURI, destinationURI);
        try {
            Folder copy = (Folder)this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

                public Object execute() {
                    RepoFolder folderCopy = HibernateRepositoryServiceImpl.this.copyFolder(sourceURI, destinationURI);
                    return folderCopy.toClient();
                }
            });
            this.closeAuditEvent("copyFolder");
            Folder folder = copy;
            return folder;
        }
        finally {
            this.resetTempNameResources();
        }
    }

    protected RepoFolder copyFolder(String sourceURI, String destinationURI) {
        RepoFolder repoSource = this.getFolder(sourceURI, true);
        String copyURI = this.getCopyURI(destinationURI, false);
        RecursiveCopier copier = new RecursiveCopier(repoSource, copyURI);
        copier.copy();
        return copier.getCopiedRootFolder();
    }

    @Override
    public void lockPath(RepoFolder folder) {
        if (!this.isLockFoldersOnPathChange()) {
            return;
        }
        HibernateTemplate template = this.getHibernateTemplate();
        RepoFolder parent = folder.getParent();
        if (parent != null && !parent.isNew()) {
            this.lockReadFolder(parent);
        }
        if (!folder.isNew()) {
            template.lock((Object)folder, LockMode.UPGRADE);
        }
    }

    protected void lockReadFolder(RepoFolder folder) {
        HibernateTemplate template = this.getHibernateTemplate();
        Session session = template.getSessionFactory().getCurrentSession();
        LockMode folderLockMode = session.getCurrentLockMode((Object)folder);
        if (LockMode.READ.equals(folderLockMode)) {
            String currentURI = folder.getURI();
            template.refresh((Object)folder, LockMode.UPGRADE);
            if (!currentURI.equals(folder.getURI())) {
                throw new JSException("jsexception.folder.moved", new Object[]{currentURI, folder.getURI()});
            }
        }
    }

    public boolean isLockFoldersOnPathChange() {
        return this.lockFoldersOnPathChange;
    }

    public void setLockFoldersOnPathChange(boolean lockFoldersOnPathChange) {
        this.lockFoldersOnPathChange = lockFoldersOnPathChange;
    }

    @Override
    public Object getPersistentObject(Object clientObject) {
        if (clientObject instanceof Folder) {
            return this.getFolder(((Folder)clientObject).getURIString(), false);
        }
        if (clientObject instanceof Resource) {
            return this.findByURI(RepoResource.class, ((Resource)clientObject).getURIString(), false);
        }
        return null;
    }

    public List<ResourceLookup> getResources(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter, TransformerFactory transformerFactory, int current, int max) {
        SearchCriteria criteria = this.getResourcesListCriteria(context, searchCriteriaFactory, filters);
        criteria.addProjection(Projections.distinct((Projection)Projections.id()));
        searchCriteriaFactory.applySorter(context, criteria, sorter);
        List list = this.getHibernateTemplate().findByCriteria((DetachedCriteria)criteria, current, max);
        ArrayList<Long> ids = new ArrayList<Long>();
        ResultTransformer transformer = transformerFactory.createTransformer(filters, sorter);
        if (transformer == null) {
            throw new IllegalArgumentException("Result transformer is null.");
        }
        ids.addAll(transformer.transformToIdList(list));
        return this.getResourcesByIdList(ids);
    }

    public int getResourcesCount(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter, TransformerFactory transformerFactory) {
        if (transformerFactory == null) {
            throw new IllegalArgumentException("Transformer factory is null.");
        }
        SearchCriteria criteria = this.getResourcesListCriteria(context, searchCriteriaFactory, filters);
        criteria.setProjection((Projection)Projections.countDistinct((String)"id"));
        List resourceList = this.getHibernateTemplate().findByCriteria((DetachedCriteria)criteria);
        ResultTransformer transformer = transformerFactory.createTransformer(filters, sorter);
        if (transformer != null) {
            return transformer.transformToCount(resourceList);
        }
        throw new IllegalArgumentException("Result transformer is null.");
    }

    private SearchCriteria getResourcesListCriteria(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters) {
        SearchCriteria criteria = searchCriteriaFactory.create(context, filters);
        String p = criteria.getAlias("parent", "p");
        criteria.add((Criterion)Restrictions.eq((String)(p + ".hidden"), (Object)Boolean.FALSE));
        return criteria;
    }

    protected class MultiResourceCopier
    extends BaseResourceCopier {
        private final Map sourcesMap;
        private final RepoFolder destination;
        private final Map copyURIs;

        public MultiResourceCopier(RepoResource[] sources, RepoFolder destination) {
            this.copyURIs = new HashMap();
            this.sourcesMap = new LinkedHashMap();
            for (int i = 0; i < sources.length; ++i) {
                RepoResource source = sources[i];
                this.sourcesMap.put(source.getResourceURI(), source);
            }
            this.destination = destination;
        }

        public void copy() {
            this.copyResources();
            this.save();
        }

        protected void copyResources() {
            for (RepoResource resource : this.sourcesMap.values()) {
                this.copyResource(resource);
            }
        }

        protected void save() {
            HibernateTemplate template = HibernateRepositoryServiceImpl.this.getHibernateTemplate();
            for (RepoResource resource : this.copiedResources.values()) {
                template.save((Object)resource);
            }
        }

        protected RepoFolder getCopyParent(RepoResourceBase resource) {
            return this.destination;
        }

        protected String getCopyURI(String uri) {
            String copyURI = (String)this.copyURIs.get(uri);
            if (copyURI == null) {
                String name = RepositoryUtils.getName(uri);
                copyURI = HibernateRepositoryServiceImpl.this.makeCopyURI(this.destination, name, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using " + copyURI + " for copy of " + name + " at " + this.destination.getURI()));
                }
                this.copyURIs.put(uri, copyURI);
            }
            return copyURI;
        }

        protected boolean isCopiedResource(String uri) {
            return this.sourcesMap.containsKey(uri);
        }

        protected RepoResource loadResourceToCopy(String uri, Class persistentClass) {
            return (RepoResource)this.sourcesMap.get(uri);
        }
    }

    protected class RecursiveCopier
    extends BaseResourceCopier {
        private final RepoFolder sourceRoot;
        private final String destinationRootURI;
        private final LinkedHashMap copiedFolders;

        public RecursiveCopier(RepoFolder sourceRoot, String destinationRootURI) {
            this.copiedFolders = new LinkedHashMap();
            this.sourceRoot = sourceRoot;
            this.destinationRootURI = destinationRootURI;
        }

        public void copy() {
            this.copyFolderRecursively(this.sourceRoot);
            this.save();
        }

        protected void save() {
            HibernateTemplate template = HibernateRepositoryServiceImpl.this.getHibernateTemplate();
            for (RepoFolder folder : this.copiedFolders.values()) {
                template.save((Object)folder);
            }
            for (RepoResource resource : this.copiedResources.values()) {
                template.save((Object)resource);
            }
        }

        protected void copyFolderRecursively(RepoFolder folder) {
            Set resources;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Recursively copying folder " + folder.getURI()));
            }
            this.copyFolder(folder);
            Set subfolders = folder.getSubFolders();
            if (subfolders != null) {
                for (RepoFolder subfolder : subfolders) {
                    if (subfolder.isHidden() || !HibernateRepositoryServiceImpl.this.getSecurityChecker().isFolderReadable(subfolder.getURI())) continue;
                    this.copyFolderRecursively(subfolder);
                }
            }
            if ((resources = folder.getChildren()) != null) {
                for (RepoResource resource : resources) {
                    if (!HibernateRepositoryServiceImpl.this.getSecurityChecker().isResourceReadable(resource.getResourceURI())) continue;
                    this.copyResource(resource);
                }
            }
        }

        protected RepoFolder copyFolder(RepoFolder folder) {
            String copyURI = this.getCopyURI(folder.getURI());
            RepoFolder folderCopy = (RepoFolder)this.copiedFolders.get(copyURI);
            if (folderCopy == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating copy of folder " + folder.getURI() + " at " + copyURI));
                }
                Folder copy = folder.toClient();
                copy.setVersion(-1);
                copy.setURIString(copyURI);
                folderCopy = HibernateRepositoryServiceImpl.this.createNewRepoFolder();
                RepoFolder copyParent = this.getCopyParent(folder);
                folderCopy.set(copy, copyParent, HibernateRepositoryServiceImpl.this);
                this.copiedFolders.put(copyURI, folderCopy);
            }
            return folderCopy;
        }

        protected String getCopyURI(String uri) {
            String copyURI = this.sourceRoot.getURI().equals(uri) ? this.destinationRootURI : (this.sourceRoot.isRoot() ? this.destinationRootURI + uri : this.destinationRootURI + uri.substring(this.sourceRoot.getURI().length()));
            return copyURI;
        }

        protected RepoFolder getCopyParent(RepoResourceBase resource) {
            RepoFolder parent;
            String uri = resource.getResourceURI();
            if (this.sourceRoot.getURI().equals(uri)) {
                String destinationParentURI = RepositoryUtils.getParentPath(this.destinationRootURI);
                parent = HibernateRepositoryServiceImpl.this.getFolder(destinationParentURI, true);
            } else {
                String copyParentURI = this.getCopyURI(resource.getParent().getURI());
                parent = (RepoFolder)this.copiedFolders.get(copyParentURI);
                if (parent == null) {
                    parent = this.copyFolder(resource.getParent());
                }
            }
            return parent;
        }

        protected boolean isCopiedResource(String uri) {
            return RepositoryUtils.isAncestorOrEqual(this.sourceRoot.getURI(), uri);
        }

        protected RepoResource loadResourceToCopy(String uri, Class persistentClass) {
            if (!HibernateRepositoryServiceImpl.this.getSecurityChecker().isResourceReadable(uri)) {
                throw new JSException("jsexception.copy.resource.referenced.not.readable", new Object[]{uri});
            }
            return HibernateRepositoryServiceImpl.this.findByURI(persistentClass, uri, true);
        }

        public RepoFolder getCopiedRootFolder() {
            return (RepoFolder)this.copiedFolders.get(this.destinationRootURI);
        }
    }

    protected abstract class BaseResourceCopier
    implements ReferenceResolver {
        protected final LinkedHashMap copiedResources = new LinkedHashMap();
        private final Set copyingResourceStack = new HashSet();

        protected BaseResourceCopier() {
        }

        protected abstract boolean isCopiedResource(String var1);

        protected abstract RepoFolder getCopyParent(RepoResourceBase var1);

        protected abstract String getCopyURI(String var1);

        protected abstract RepoResource loadResourceToCopy(String var1, Class var2);

        protected RepoResource copyResource(RepoResource resource) {
            String copyURI = this.getCopyURI(resource.getResourceURI());
            RepoResource resourceCopy = (RepoResource)this.copiedResources.get(copyURI);
            if (resourceCopy == null) {
                resourceCopy = this.copyResource(resource, copyURI);
            }
            return resourceCopy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RepoResource copyResource(RepoResource resource, String copyURI) {
            HibernateRepositoryServiceImpl.this.auditResourceCopyAndMove("copyResource", resource.getResourceURI(), copyURI, resource.getClientType().getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating copy of resource " + resource.getResourceURI() + " at " + copyURI));
            }
            if (!this.copyingResourceStack.add(copyURI)) {
                throw new JSException("jsexception.copy.resource.circular.reference", new Object[]{resource.getResourceURI()});
            }
            try {
                Resource copy = HibernateRepositoryServiceImpl.this.getClientClone(resource);
                copy.setURIString(copyURI);
                Class persistentClass = HibernateRepositoryServiceImpl.this.resourcePersistentClass(copy.getClass());
                RepoResource resourceCopy = HibernateRepositoryServiceImpl.this.createPersistentResource(persistentClass);
                RepoFolder copyParent = this.getCopyParent(resource);
                resourceCopy.setParent(copyParent);
                resourceCopy.copyFromClient(copy, this);
                this.copiedResources.put(copyURI, resourceCopy);
                HibernateRepositoryServiceImpl.this.closeAuditEvent("copyResource");
                RepoResource repoResource = resourceCopy;
                return repoResource;
            }
            finally {
                this.copyingResourceStack.remove(copyURI);
            }
        }

        protected RepoResource getCopiedResourceReference(String uri, Class persistentClass) {
            String copyURI = this.getCopyURI(uri);
            RepoResource resourceCopy = (RepoResource)this.copiedResources.get(copyURI);
            if (resourceCopy == null) {
                RepoResource resource = this.loadResourceToCopy(uri, persistentClass);
                resourceCopy = this.copyResource(resource, copyURI);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reference to " + uri + " has been changed to " + copyURI));
            }
            return resourceCopy;
        }

        protected RepoResource getCopyReference(String uri, Class persistentReferenceClass) {
            RepoResource reference = this.isCopiedResource(uri) ? this.getCopiedResourceReference(uri, persistentReferenceClass) : HibernateRepositoryServiceImpl.this.findByURI(persistentReferenceClass, uri, true);
            return reference;
        }

        public RepoResource getExternalReference(String uri, Class persistentReferenceClass) {
            return this.getCopyReference(uri, persistentReferenceClass);
        }

        public RepoResource getPersistentReference(String uri, Class clientReferenceClass) {
            return this.getCopyReference(uri, HibernateRepositoryServiceImpl.this.resourcePersistentClass(clientReferenceClass));
        }

        public RepoResource getReference(RepoResource owner, ResourceReference resourceReference, Class persistentReferenceClass) {
            if (resourceReference == null) {
                return null;
            }
            RepoResource repoRes = resourceReference.isLocal() ? this.getReference(owner, resourceReference.getLocalResource(), persistentReferenceClass) : this.getCopyReference(resourceReference.getReferenceURI(), persistentReferenceClass);
            return repoRes;
        }

        public RepoResource getReference(RepoResource owner, Resource resource, Class persistentReferenceClass) {
            return HibernateRepositoryServiceImpl.this.getReference(owner, resource, persistentReferenceClass, this);
        }
    }
}

