/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HttpOnlyResponseWrapper
extends HttpServletResponseWrapper {
    private static SimpleDateFormat cookieFormat = new SimpleDateFormat("EEE, d-MMM-yyyy HH:mm:ss zzz", Locale.ENGLISH);

    public HttpOnlyResponseWrapper(HttpServletResponse res) {
        super(res);
        cookieFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void addCookie(Cookie cookie) {
        StringBuffer header = new StringBuffer();
        if (cookie.getName() != null && !cookie.getName().equals("")) {
            header.append(cookie.getName());
        }
        if (cookie.getValue() != null) {
            header.append("=" + cookie.getValue());
        }
        if (cookie.getVersion() == 1) {
            header.append(";Version=1");
            if (cookie.getComment() != null) {
                header.append(";Comment=\"" + cookie.getComment() + "\"");
            }
            if (cookie.getMaxAge() > -1) {
                header.append(";Max-Age=" + cookie.getMaxAge());
            }
        } else if (cookie.getMaxAge() > -1) {
            Date now = new Date();
            now.setTime(now.getTime() + 1000L * (long)cookie.getMaxAge());
            header.append(";Expires=" + cookieFormat.format(now));
        }
        if (cookie.getDomain() != null) {
            header.append(";Domain=" + cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            header.append(";Path=" + cookie.getPath());
        }
        if (cookie.getSecure()) {
            header.append(";Secure");
        }
        header.append(";HttpOnly");
        this.addHeader("Set-Cookie", header.toString());
    }
}

