/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.export.io.PathProcessor;

public class AsciiEscapingPathProcessor
implements PathProcessor {
    private char escapeChar;

    public String processPath(String logicalPath) {
        return this.escapeChars(logicalPath);
    }

    protected String escapeChars(String path) {
        int nameLength = path.length();
        StringBuffer xmlName = new StringBuffer(nameLength + 10);
        for (int i = 0; i < nameLength; ++i) {
            char c = path.charAt(i);
            if (this.toEscape(c)) {
                this.appendEscaped(xmlName, c);
                continue;
            }
            xmlName.append(c);
        }
        return xmlName.toString();
    }

    protected void appendEscaped(StringBuffer xmlName, char c) {
        xmlName.append(this.escapeChar);
        String hexCode = Integer.toHexString(c);
        switch (hexCode.length()) {
            case 1: {
                xmlName.append("000");
                break;
            }
            case 2: {
                xmlName.append("00");
                break;
            }
            case 3: {
                xmlName.append("0");
            }
        }
        xmlName.append(hexCode);
    }

    protected boolean toEscape(char c) {
        return c > '\u007f' || c == this.escapeChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }
}

