/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.RepositoryObjectPermissionBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceReferenceBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class ResourceBean {
    private String name;
    private String label;
    private String description;
    private String folder;
    private Date creationDate;
    private Date updateDate;
    private int version;
    private RepositoryObjectPermissionBean[] permissions;

    public final void copyFrom(Resource res, ResourceExportHandler exportHandler) {
        this.setName(res.getName());
        this.setLabel(res.getLabel());
        this.setDescription(res.getDescription());
        this.setFolder(res.getParentFolder());
        this.setCreationDate(res.getCreationDate());
        this.setUpdateDate(res.getUpdateDate());
        this.setVersion(res.getVersion());
        this.additionalCopyFrom(res, exportHandler);
    }

    protected abstract void additionalCopyFrom(Resource var1, ResourceExportHandler var2);

    public final void copyTo(Resource res, ResourceImportHandler importHandler) {
        res.setName(this.getName());
        res.setLabel(this.getLabel());
        res.setDescription(this.getDescription());
        res.setParentFolder(this.getFolder());
        res.setUpdateDate(this.getUpdateDate());
        this.additionalCopyTo(res, importHandler);
    }

    protected abstract void additionalCopyTo(Resource var1, ResourceImportHandler var2);

    protected final ResourceReferenceBean[] handleReferences(List references, ResourceExportHandler exportHandler) {
        ResourceReferenceBean[] refBeans;
        if (references == null || references.isEmpty()) {
            refBeans = null;
        } else {
            refBeans = new ResourceReferenceBean[references.size()];
            int c = 0;
            for (ResourceReference controlRef : references) {
                refBeans[c] = exportHandler.handleReference(controlRef);
                ++c;
            }
        }
        return refBeans;
    }

    protected List handleReferences(ResourceReferenceBean[] beanReferences, ResourceImportHandler importHandler) {
        ArrayList<ResourceReference> references;
        if (beanReferences == null) {
            references = null;
        } else {
            references = new ArrayList<ResourceReference>(beanReferences.length);
            for (int i = 0; i < beanReferences.length; ++i) {
                ResourceReferenceBean beanReference = beanReferences[i];
                ResourceReference reference = importHandler.handleReference(beanReference);
                references.add(reference);
            }
        }
        return references;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folderUri) {
        this.folder = folderUri;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public RepositoryObjectPermissionBean[] getPermissions() {
        return this.permissions;
    }

    public void setPermissions(RepositoryObjectPermissionBean[] permissions) {
        this.permissions = permissions;
    }
}

