/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.search.action.SearchHolder;
import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.common.SearchMode;
import com.jaspersoft.jasperserver.search.factory.RepositorySearchModeFactory;
import com.jaspersoft.jasperserver.search.state.InitialStateResolver;
import com.jaspersoft.jasperserver.search.util.JSONConverter;
import com.jaspersoft.jasperserver.war.action.BaseFormAction;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;
import org.springframework.webflow.execution.RequestContext;

public class BaseSearchAction
extends BaseFormAction {
    private static final String ATTRIBUTE_SEARCH_HOLDER = "searchHolder";
    public static final String PARAMETER_SOURCE_FOLDER_URI = "sourceFolderUri";
    public static final String PARAMETER_FOLDER = "folder";
    public static final String PARAMETER_SELECTED_RESOURCES = "selectedResources";
    public static final String PARAMETER_DEST_FOLDER_URI = "destFolderUri";
    public static final String PARAMETER_SELECTED_RESOURCE = "selectedResource";
    private static final String PARAMETER_MODE = "mode";
    private static final String PARAMETER_LAST_MODE = "lastMode";
    private RepositorySearchModeFactory repositorySearchModeFactory;

    public void setRepositorySearchModeFactory(RepositorySearchModeFactory repositorySearchModeFactory) {
        this.repositorySearchModeFactory = repositorySearchModeFactory;
    }

    protected JSONConverter getConverter(RequestContext context) {
        return this.repositorySearchModeFactory.getConverter(this.getMode(context));
    }

    protected RepositorySearchConfiguration getConfiguration(RequestContext context) {
        return this.repositorySearchModeFactory.getConfiguration(this.getMode(context));
    }

    protected InitialStateResolver getInitialStateResolver(RequestContext context) {
        return this.repositorySearchModeFactory.getInitialStateResolver(this.getMode(context));
    }

    protected String getErrorMessage(Exception e) {
        String errorMsg;
        if (e instanceof JSException) {
            JSException jse = (JSException)e;
            errorMsg = this.messages.getMessage(jse.getMessage(), jse.getArgs(), LocaleContextHolder.getLocale());
        } else {
            errorMsg = e.getMessage();
        }
        return errorMsg;
    }

    protected void initSearchHolder(RequestContext context) {
        SearchHolder searchHolder = this.getSearchHolder(context);
        if (searchHolder == null) {
            searchHolder = new SearchHolder();
            context.getExternalContext().getSessionMap().put(ATTRIBUTE_SEARCH_HOLDER, (Object)searchHolder);
        }
    }

    protected SearchHolder getSearchHolder(RequestContext context) {
        SharedAttributeMap session = context.getExternalContext().getSessionMap();
        return (SearchHolder)session.get(ATTRIBUTE_SEARCH_HOLDER);
    }

    protected SearchMode getMode(RequestContext context) {
        ParameterMap map = context.getRequestParameters();
        SearchMode mode = SearchMode.BROWSE;
        String lastModeParameter = (String)map.get(PARAMETER_LAST_MODE, String.class);
        if (Boolean.parseBoolean(lastModeParameter)) {
            mode = this.getSearchHolder(context).getLastMode();
        } else {
            String modeParameter = (String)map.get(PARAMETER_MODE, String.class);
            if (modeParameter != null && SearchMode.SEARCH.toString().equals(modeParameter)) {
                mode = SearchMode.SEARCH;
            }
        }
        return mode;
    }

    protected Object getParameter(RequestContext context, String name, Class clazz) {
        ParameterMap map = context.getRequestParameters();
        if (map.contains(name)) {
            return map.get(name, clazz);
        }
        return null;
    }
}

