/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.state.impl;

import com.jaspersoft.jasperserver.search.common.CustomFilter;
import com.jaspersoft.jasperserver.search.common.CustomSorter;
import com.jaspersoft.jasperserver.search.common.Option;
import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.model.FilterPath;
import com.jaspersoft.jasperserver.search.model.PathItem;
import com.jaspersoft.jasperserver.search.state.InitialStateResolver;
import com.jaspersoft.jasperserver.search.state.State;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateImpl
implements State,
InitialStateResolver,
Cloneable,
Serializable {
    public static String JSON_TEXT = "text";
    public static String JSON_SORT_BY = "sortBy";
    public static String JSON_FOLDER_URI = "folderUri";
    public static String JSON_CUSTOM_FILTERS = "customFilters";
    private String text;
    private String sortBy;
    private String folderUri;
    private Map<String, String> customFiltersMap;
    private int resultIndex;
    private int resultsCount;
    private Map<String, String> selectedFiltersMap = new LinkedHashMap<String, String>();

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    @Override
    public String getFolderUri() {
        return this.folderUri;
    }

    public void setFolderUri(String folderUri) {
        this.folderUri = folderUri;
    }

    @Override
    public Map<String, String> getCustomFiltersMap() {
        return Collections.unmodifiableMap(this.customFiltersMap);
    }

    public void setCustomFiltersMap(Map<String, String> customFiltersMap) {
        this.customFiltersMap = customFiltersMap;
    }

    @Override
    public int getResultIndex() {
        return this.resultIndex;
    }

    public void setResultIndex(int resultIndex) {
        this.resultIndex = resultIndex;
    }

    @Override
    public int getResultsCount() {
        return this.resultsCount;
    }

    public void setResultsCount(int resultsCount) {
        this.resultsCount = resultsCount;
    }

    @Override
    public void updateText(String text) {
        this.text = text;
        this.updateResultState(0, 0);
    }

    @Override
    public void updateSorter(String sortBy) {
        this.sortBy = sortBy;
        this.updateResultState(0, 0);
    }

    @Override
    public void updateFolder(String folderUri) {
        this.folderUri = folderUri;
        this.updateResultState(0, 0);
    }

    @Override
    public void updateFilter(String filterId, String optionId, boolean isDefault) {
        this.customFiltersMap.put(filterId, optionId);
        this.updateResultState(0, 0);
        if (isDefault) {
            this.selectedFiltersMap.remove(filterId);
        } else {
            this.selectedFiltersMap.put(filterId, optionId);
        }
    }

    @Override
    public void updateResultState(int resultIndex, int resultsCount) {
        this.resultIndex = resultIndex;
        this.resultsCount = resultsCount;
    }

    @Override
    public void rollback(int position, RepositorySearchConfiguration configuration) {
        int filterPosition = --position;
        LinkedHashMap<String, String> newSelectedFiltersMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.selectedFiltersMap.entrySet()) {
            if (filterPosition < 0) break;
            --filterPosition;
            newSelectedFiltersMap.put(entry.getKey(), entry.getValue());
        }
        this.selectedFiltersMap = newSelectedFiltersMap;
        for (Map.Entry<String, String> entry : this.customFiltersMap.entrySet()) {
            if (this.selectedFiltersMap.containsKey(entry.getKey())) continue;
            this.customFiltersMap.put(entry.getKey(), this.getDefaultOption(entry.getKey(), configuration));
        }
        this.updateResultState(0, 0);
    }

    private String getDefaultOption(String filterId, RepositorySearchConfiguration configuration) {
        for (CustomFilter customFilter : configuration.getCustomFilters()) {
            if (!customFilter.getId().equals(filterId)) continue;
            return customFilter.getDefaultOption();
        }
        throw new RuntimeException("Custom filter with filter id '" + filterId + "' not found!");
    }

    @Override
    public FilterPath getFilterPath(RepositorySearchConfiguration configuration, MessageSource messageSource) {
        ArrayList<PathItem> pathItems = new ArrayList<PathItem>(this.selectedFiltersMap.size() + 1);
        int position = 0;
        PathItem textPathItem = new PathItem();
        textPathItem.setPosition(position++);
        textPathItem.setType(PathItem.Type.TEXT);
        if (this.text == null || this.text.length() == 0) {
            textPathItem.setLabel(messageSource.getMessage("SEARCH_FILTER_PATH_ALL", null, LocaleContextHolder.getLocale()));
        } else {
            textPathItem.setLabel("'" + this.text + "'");
        }
        pathItems.add(textPathItem);
        for (Map.Entry<String, String> entry : this.selectedFiltersMap.entrySet()) {
            PathItem filterPathItem = new PathItem();
            filterPathItem.setPosition(position++);
            filterPathItem.setType(PathItem.Type.FILTER);
            filterPathItem.setLabel(this.getPathItemLabelForFilter(configuration, messageSource, entry.getKey(), entry.getValue()));
            pathItems.add(filterPathItem);
        }
        return new FilterPath(pathItems);
    }

    private String getPathItemLabelForFilter(RepositorySearchConfiguration configuration, MessageSource messageSource, String filterId, String filterOption) {
        for (CustomFilter customFilter : configuration.getCustomFilters()) {
            if (!customFilter.getId().equals(filterId)) continue;
            for (Option option : customFilter.getOptions()) {
                if (!option.getId().equals(filterOption)) continue;
                return messageSource.getMessage(option.getLabelId(), null, LocaleContextHolder.getLocale());
            }
        }
        throw new RuntimeException("Custom filter with filter id '" + filterId + "' and filter option '" + filterOption + "' not found!");
    }

    @Override
    public JSONObject toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(JSON_TEXT, (Object)this.text);
        jsonObject.put(JSON_SORT_BY, (Object)this.sortBy);
        jsonObject.put(JSON_FOLDER_URI, (Object)this.folderUri);
        jsonObject.put(JSON_CUSTOM_FILTERS, (Object)new JSONObject(this.customFiltersMap));
        return jsonObject;
    }

    protected Object clone() throws CloneNotSupportedException {
        StateImpl state = (StateImpl)super.clone();
        state.customFiltersMap = new HashMap<String, String>(this.customFiltersMap);
        state.selectedFiltersMap = new HashMap<String, String>(this.selectedFiltersMap);
        return state;
    }

    private StateImpl cloneState() {
        try {
            return (StateImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error occurred when cloning state", e);
        }
    }

    @Override
    public State getInitialState(RepositorySearchConfiguration repositorySearchConfiguration) {
        StateImpl state = this.cloneState();
        List<CustomSorter> customSorters = repositorySearchConfiguration.getCustomSorters();
        boolean hasSorterAccess = false;
        for (CustomSorter customSorter : customSorters) {
            if (!customSorter.getId().equals(state.sortBy)) continue;
            hasSorterAccess = true;
            break;
        }
        if (!hasSorterAccess && customSorters.size() > 0) {
            state.sortBy = customSorters.get(0).getId();
        }
        List<CustomFilter> customFilters = repositorySearchConfiguration.getCustomFilters();
        HashMap<String, String> clonedCustomFiltersMap = new HashMap<String, String>(state.customFiltersMap);
        for (Map.Entry entry : clonedCustomFiltersMap.entrySet()) {
            String filterId = (String)entry.getKey();
            String optionId = (String)entry.getValue();
            CustomFilter currentCustomFilter = null;
            for (CustomFilter customFilter : customFilters) {
                if (!customFilter.getId().equals(filterId)) continue;
                currentCustomFilter = customFilter;
                break;
            }
            if (currentCustomFilter == null) {
                state.customFiltersMap.remove(entry.getKey());
                continue;
            }
            boolean hasOptionAccess = false;
            for (Option option : currentCustomFilter.getOptions()) {
                if (!option.getId().equals(optionId)) continue;
                hasOptionAccess = true;
                break;
            }
            if (hasOptionAccess) continue;
            state.customFiltersMap.put((String)entry.getKey(), currentCustomFilter.getOptions().get(0).getId());
        }
        return state;
    }
}

