/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePrintElement;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRBasePrintText
extends JRBasePrintElement
implements JRPrintText {
    private static final long serialVersionUID = 10200L;
    protected String text = "";
    protected Integer textTruncateIndex;
    protected short[] lineBreakOffsets;
    protected String textTruncateSuffix;
    protected transient String truncatedText;
    protected float lineSpacingFactor;
    protected float leadingOffset;
    protected HorizontalAlignEnum horizontalAlignmentValue;
    protected VerticalAlignEnum verticalAlignmentValue;
    protected RotationEnum rotationValue;
    protected RunDirectionEnum runDirectionValue = RunDirectionEnum.LTR;
    protected float textHeight;
    protected LineSpacingEnum lineSpacingValue;
    protected String markup;
    protected String anchorName;
    protected String linkType;
    protected String linkTarget;
    protected String hyperlinkReference;
    protected String hyperlinkAnchor;
    protected Integer hyperlinkPage;
    protected String hyperlinkTooltip;
    protected JRPrintHyperlinkParameters hyperlinkParameters;
    protected int bookmarkLevel = 0;
    protected JRLineBox lineBox = new JRBaseLineBox(this);
    protected JRReportFont reportFont;
    protected String fontName;
    protected Boolean isBold;
    protected Boolean isItalic;
    protected Boolean isUnderline;
    protected Boolean isStrikeThrough;
    protected Integer fontSize;
    protected String pdfFontName;
    protected String pdfEncoding;
    protected Boolean isPdfEmbedded;
    protected String valueClassName;
    protected String pattern;
    protected String formatFactoryClass;
    protected String localeCode;
    protected String timeZoneId;
    private int PSEUDO_SERIAL_VERSION_UID = 30705;
    private Byte horizontalAlignment;
    private Byte verticalAlignment;
    private Byte rotation;
    private Byte lineSpacing;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;
    private Boolean isStyledText;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private byte runDirection;

    public JRBasePrintText(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode((JRCommonElement)this, ModeEnum.TRANSPARENT);
    }

    @Override
    public String getText() {
        if (this.truncatedText == null && this.text != null) {
            this.truncatedText = this.getTextTruncateIndex() == null ? this.text : (!"none".equals(this.getMarkup()) ? JRStyledTextParser.getInstance().write(this.getFullStyledText(JRStyledTextAttributeSelector.ALL), 0, this.getTextTruncateIndex()) : this.text.substring(0, this.getTextTruncateIndex()));
            if (this.textTruncateSuffix != null) {
                this.truncatedText = this.truncatedText + this.textTruncateSuffix;
            }
        }
        return this.truncatedText;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.truncatedText = null;
    }

    @Override
    public Integer getTextTruncateIndex() {
        return this.textTruncateIndex;
    }

    @Override
    public void setTextTruncateIndex(Integer textTruncateIndex) {
        this.textTruncateIndex = textTruncateIndex;
        this.truncatedText = null;
    }

    @Override
    public String getTextTruncateSuffix() {
        return this.textTruncateSuffix;
    }

    @Override
    public void setTextTruncateSuffix(String textTruncateSuffix) {
        this.textTruncateSuffix = textTruncateSuffix;
        this.truncatedText = null;
    }

    @Override
    public short[] getLineBreakOffsets() {
        return this.lineBreakOffsets;
    }

    @Override
    public void setLineBreakOffsets(short[] lineBreakOffsets) {
        this.lineBreakOffsets = lineBreakOffsets;
    }

    @Override
    public String getFullText() {
        String fullText = this.text;
        if (this.textTruncateIndex == null && this.textTruncateSuffix != null) {
            fullText = fullText + this.textTruncateSuffix;
        }
        return fullText;
    }

    @Override
    public String getOriginalText() {
        return this.text;
    }

    @Override
    public JRStyledText getStyledText(JRStyledTextAttributeSelector attributeSelector) {
        if (this.getText() == null) {
            return null;
        }
        return JRStyledTextParser.getInstance().getStyledText(attributeSelector.getStyledTextAttributes(this), this.getText(), !"none".equals(this.getMarkup()), JRStyledTextAttributeSelector.getTextLocale(this));
    }

    @Override
    public JRStyledText getFullStyledText(JRStyledTextAttributeSelector attributeSelector) {
        if (this.getFullText() == null) {
            return null;
        }
        return JRStyledTextParser.getInstance().getStyledText(attributeSelector.getStyledTextAttributes(this), this.getFullText(), !"none".equals(this.getMarkup()), JRStyledTextAttributeSelector.getTextLocale(this));
    }

    @Override
    public float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    @Override
    public void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    @Override
    public float getLeadingOffset() {
        return this.leadingOffset;
    }

    @Override
    public void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    @Override
    public byte getTextAlignment() {
        return this.getHorizontalAlignment();
    }

    @Override
    public void setTextAlignment(byte horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
    }

    @Override
    public byte getHorizontalAlignment() {
        return this.getHorizontalAlignmentValue().getValue();
    }

    @Override
    public Byte getOwnHorizontalAlignment() {
        return this.getOwnHorizontalAlignmentValue() == null ? null : this.getOwnHorizontalAlignmentValue().getValueByte();
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return this.horizontalAlignmentValue;
    }

    @Override
    public void setHorizontalAlignment(byte horizontalAlignment) {
        this.setHorizontalAlignment(HorizontalAlignEnum.getByValue(horizontalAlignment));
    }

    @Override
    public void setHorizontalAlignment(Byte horizontalAlignment) {
        this.setHorizontalAlignment(HorizontalAlignEnum.getByValue(horizontalAlignment));
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignmentValue) {
        this.horizontalAlignmentValue = horizontalAlignmentValue;
    }

    @Override
    public byte getVerticalAlignment() {
        return this.getVerticalAlignmentValue().getValue();
    }

    @Override
    public Byte getOwnVerticalAlignment() {
        return this.getOwnVerticalAlignmentValue() == null ? null : this.getOwnVerticalAlignmentValue().getValueByte();
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return this.verticalAlignmentValue;
    }

    @Override
    public void setVerticalAlignment(byte verticalAlignment) {
        this.setVerticalAlignment(VerticalAlignEnum.getByValue(verticalAlignment));
    }

    @Override
    public void setVerticalAlignment(Byte verticalAlignment) {
        this.setVerticalAlignment(VerticalAlignEnum.getByValue(verticalAlignment));
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignmentValue) {
        this.verticalAlignmentValue = verticalAlignmentValue;
    }

    @Override
    public byte getRotation() {
        return this.getRotationValue().getValue();
    }

    @Override
    public Byte getOwnRotation() {
        return this.getOwnRotationValue() == null ? null : this.getOwnRotationValue().getValueByte();
    }

    @Override
    public RotationEnum getRotationValue() {
        return JRStyleResolver.getRotationValue(this);
    }

    @Override
    public RotationEnum getOwnRotationValue() {
        return this.rotationValue;
    }

    @Override
    public void setRotation(byte rotation) {
        this.setRotation(RotationEnum.getByValue(rotation));
    }

    @Override
    public void setRotation(Byte rotation) {
        this.setRotation(RotationEnum.getByValue(rotation));
    }

    @Override
    public void setRotation(RotationEnum rotationValue) {
        this.rotationValue = rotationValue;
    }

    @Override
    public byte getRunDirection() {
        return this.getRunDirectionValue().getValue();
    }

    @Override
    public void setRunDirection(byte runDirection) {
        this.setRunDirection(RunDirectionEnum.getByValue(runDirection));
    }

    @Override
    public RunDirectionEnum getRunDirectionValue() {
        return this.runDirectionValue;
    }

    @Override
    public void setRunDirection(RunDirectionEnum runDirectionValue) {
        this.runDirectionValue = runDirectionValue;
    }

    @Override
    public float getTextHeight() {
        return this.textHeight;
    }

    @Override
    public void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    @Override
    public byte getLineSpacing() {
        return this.getLineSpacingValue().getValue();
    }

    @Override
    public Byte getOwnLineSpacing() {
        return this.getOwnLineSpacingValue() == null ? null : this.getOwnLineSpacingValue().getValueByte();
    }

    @Override
    public void setLineSpacing(byte lineSpacing) {
        this.setLineSpacing(LineSpacingEnum.getByValue(lineSpacing));
    }

    @Override
    public void setLineSpacing(Byte lineSpacing) {
        this.setLineSpacing(LineSpacingEnum.getByValue(lineSpacing));
    }

    @Override
    public LineSpacingEnum getLineSpacingValue() {
        return JRStyleResolver.getLineSpacingValue(this);
    }

    @Override
    public LineSpacingEnum getOwnLineSpacingValue() {
        return this.lineSpacingValue;
    }

    @Override
    public void setLineSpacing(LineSpacingEnum lineSpacingValue) {
        this.lineSpacingValue = lineSpacingValue;
    }

    @Override
    public boolean isStyledText() {
        return "styled".equals(this.getMarkup());
    }

    @Override
    public Boolean isOwnStyledText() {
        String mkp = this.getOwnMarkup();
        return "styled".equals(mkp) ? Boolean.TRUE : (mkp == null ? null : Boolean.FALSE);
    }

    @Override
    public void setStyledText(boolean isStyledText) {
        this.setStyledText(isStyledText ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setStyledText(Boolean isStyledText) {
        if (isStyledText == null) {
            this.setMarkup(null);
        } else {
            this.setMarkup(isStyledText != false ? "styled" : "none");
        }
    }

    @Override
    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return this.markup;
    }

    @Override
    public void setMarkup(String markup) {
        this.markup = markup;
    }

    @Override
    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public void setBox(JRBox box) {
        JRBoxUtil.setBoxToLineBox(box, this.lineBox);
    }

    public void copyBox(JRLineBox lineBox) {
        this.lineBox = lineBox.clone(this);
    }

    @Override
    public JRFont getFont() {
        return this;
    }

    @Override
    public void setFont(JRFont font) {
        this.reportFont = font.getReportFont();
        this.fontName = font.getOwnFontName();
        this.isBold = font.isOwnBold();
        this.isItalic = font.isOwnItalic();
        this.isUnderline = font.isOwnUnderline();
        this.isStrikeThrough = font.isOwnStrikeThrough();
        this.fontSize = font.getOwnSize();
        this.pdfFontName = font.getOwnPdfFontName();
        this.pdfEncoding = font.getOwnPdfEncoding();
        this.isPdfEmbedded = font.isOwnPdfEmbedded();
    }

    @Override
    public String getAnchorName() {
        return this.anchorName;
    }

    @Override
    public void setAnchorName(String anchorName) {
        this.anchorName = anchorName;
    }

    @Override
    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this.getLinkType());
    }

    @Override
    public void setHyperlinkType(byte hyperlinkType) {
        this.setHyperlinkType(HyperlinkTypeEnum.getByValue(hyperlinkType));
    }

    @Override
    public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    @Override
    public byte getHyperlinkTarget() {
        return this.getHyperlinkTargetValue().getValue();
    }

    @Override
    public HyperlinkTargetEnum getHyperlinkTargetValue() {
        return JRHyperlinkHelper.getHyperlinkTargetValue(this.getLinkTarget());
    }

    @Override
    public void setHyperlinkTarget(byte hyperlinkTarget) {
        this.setHyperlinkTarget(HyperlinkTargetEnum.getByValue(hyperlinkTarget));
    }

    @Override
    public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    @Override
    public String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    @Override
    public void setHyperlinkReference(String hyperlinkReference) {
        this.hyperlinkReference = hyperlinkReference;
    }

    @Override
    public String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    @Override
    public void setHyperlinkAnchor(String hyperlinkAnchor) {
        this.hyperlinkAnchor = hyperlinkAnchor;
    }

    @Override
    public Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    @Override
    public void setHyperlinkPage(Integer hyperlinkPage) {
        this.hyperlinkPage = hyperlinkPage;
    }

    public void setHyperlinkPage(String hyperlinkPage) {
        this.hyperlinkPage = Integer.valueOf(hyperlinkPage);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    @Override
    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    @Override
    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    @Override
    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    @Override
    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    @Override
    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    @Override
    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.lineBox.getPen().setLineColor(borderColor);
    }

    @Override
    public int getPadding() {
        return this.lineBox.getPadding();
    }

    @Override
    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    @Override
    public void setPadding(int padding) {
        this.lineBox.setPadding(padding);
    }

    @Override
    public void setPadding(Integer padding) {
        this.lineBox.setPadding(padding);
    }

    @Override
    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    @Override
    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    @Override
    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    @Override
    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    @Override
    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
        this.lineBox.getTopPen().setLineColor(topBorderColor);
    }

    @Override
    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    @Override
    public void setTopPadding(Integer topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    @Override
    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    @Override
    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    @Override
    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
        this.lineBox.getLeftPen().setLineColor(leftBorderColor);
    }

    @Override
    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    @Override
    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    @Override
    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    @Override
    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
        this.lineBox.getBottomPen().setLineColor(bottomBorderColor);
    }

    @Override
    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    @Override
    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    @Override
    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    @Override
    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    @Override
    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
        this.lineBox.getRightPen().setLineColor(rightBorderColor);
    }

    @Override
    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    @Override
    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    @Override
    public void setReportFont(JRReportFont reportFont) {
        this.reportFont = reportFont;
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Override
    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.isBold;
    }

    @Override
    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    @Override
    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    @Override
    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    @Override
    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    @Override
    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    @Override
    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    @Override
    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
        this.isStrikeThrough = isStrikeThrough;
    }

    @Override
    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    @Override
    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize((Integer)fontSize);
    }

    @Override
    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public int getSize() {
        return this.getFontSize();
    }

    @Override
    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    @Override
    public void setSize(int size) {
        this.setFontSize(size);
    }

    @Override
    public void setSize(Integer size) {
        this.setFontSize(size);
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        this.pdfFontName = pdfFontName;
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    @Override
    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    @Override
    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    public void setValueClassName(String valueClassName) {
        this.valueClassName = valueClassName;
    }

    @Override
    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public void setFormatFactoryClass(String formatFactoryClass) {
        this.formatFactoryClass = formatFactoryClass;
    }

    @Override
    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    @Override
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    @Override
    public JRPrintHyperlinkParameters getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    @Override
    public void setHyperlinkParameters(JRPrintHyperlinkParameters hyperlinkParameters) {
        this.hyperlinkParameters = hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRPrintHyperlinkParameter parameter) {
        if (this.hyperlinkParameters == null) {
            this.hyperlinkParameters = new JRPrintHyperlinkParameters();
        }
        this.hyperlinkParameters.addParameter(parameter);
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public void setLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
    }

    @Override
    public String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    @Override
    public void setHyperlinkTooltip(String hyperlinkTooltip) {
        this.hyperlinkTooltip = hyperlinkTooltip;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.horizontalAlignmentValue = HorizontalAlignEnum.getByValue(this.horizontalAlignment);
            this.verticalAlignmentValue = VerticalAlignEnum.getByValue(this.verticalAlignment);
            this.rotationValue = RotationEnum.getByValue(this.rotation);
            this.runDirectionValue = RunDirectionEnum.getByValue(this.runDirection);
            this.lineSpacingValue = LineSpacingEnum.getByValue(this.lineSpacing);
            this.horizontalAlignment = null;
            this.verticalAlignment = null;
            this.rotation = null;
            this.lineSpacing = null;
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.isStyledText != null) {
            this.markup = this.isStyledText != false ? "styled" : "none";
            this.isStyledText = null;
        }
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
    }

    @Override
    public <T> void accept(PrintElementVisitor<T> visitor, T arg) {
        visitor.visit(this, arg);
    }
}

