/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.governors;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactory;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactoryContext;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.governors.MaxPagesGovernor;
import net.sf.jasperreports.governors.TimeoutGovernor;

public final class GovernorFactory
implements ScriptletFactory {
    private static final GovernorFactory INSTANCE = new GovernorFactory();

    private GovernorFactory() {
    }

    public static GovernorFactory getInstance() {
        return INSTANCE;
    }

    public List getScriplets(ScriptletFactoryContext context) throws JRException {
        long timeout;
        boolean timeoutEnabled;
        int maxPages;
        ArrayList<JRDefaultScriptlet> scriptlets = new ArrayList<JRDefaultScriptlet>();
        boolean maxPagesEnabled = JRProperties.getBooleanProperty(context.getDataset(), "net.sf.jasperreports.governor.max.pages.enabled", true);
        if (maxPagesEnabled && (maxPages = JRProperties.getIntegerProperty(context.getDataset(), "net.sf.jasperreports.governor.max.pages", 0)) > 0) {
            scriptlets.add(new MaxPagesGovernor(maxPages));
        }
        if ((timeoutEnabled = JRProperties.getBooleanProperty(context.getDataset(), "net.sf.jasperreports.governor.timeout.enabled", true)) && (timeout = JRProperties.getLongProperty(context.getDataset(), "net.sf.jasperreports.governor.timeout", 0)) > 0L) {
            scriptlets.add(new TimeoutGovernor(timeout));
        }
        return scriptlets;
    }

    protected JRAbstractScriptlet getScriptlet(String scriptletClassName) throws JRException {
        JRAbstractScriptlet scriptlet = null;
        try {
            Class scriptletClass = JRClassLoader.loadClassForName(scriptletClassName);
            scriptlet = (JRAbstractScriptlet)scriptletClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Error loading scriptlet class : " + scriptletClassName, e);
        }
        catch (Exception e) {
            throw new JRException("Error creating scriptlet class instance : " + scriptletClassName, e);
        }
        return scriptlet;
    }
}

