/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.create;

import java.util.Map;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

public abstract class AbstractCreator
implements Creator {
    private boolean cacheable = false;
    private String javascript = null;
    private String scope = "page";

    public void setProperties(Map params) throws IllegalArgumentException {
    }

    public String getJavascript() {
        return this.javascript;
    }

    public void setJavascript(String javascript) {
        this.javascript = javascript;
    }

    public void setScope(String scope) {
        AbstractCreator.checkScope(scope);
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    protected static void checkScope(String cscope) {
        if (!(cscope.equals("script") || cscope.equals("page") || cscope.equals("request") || cscope.equals("session") || cscope.equals("application"))) {
            throw new IllegalArgumentException(Messages.getString("AbstractCreator.IllegalScope", cscope));
        }
    }

    public String toString() {
        return LocalUtil.getShortClassName(this.getClass()) + "[" + this.getJavascript() + "]";
    }
}

