/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Injector;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.guice.DwrGuiceServletContextListener;

class DwrGuiceUtil {
    private static final ThreadLocal<LinkedList<ServletContext>> servletContexts = new ThreadLocal<LinkedList<ServletContext>>(){

        @Override
        protected LinkedList<ServletContext> initialValue() {
            return new LinkedList<ServletContext>();
        }
    };

    DwrGuiceUtil() {
    }

    static Injector getInjector() {
        return DwrGuiceServletContextListener.getPublishedInjector(DwrGuiceUtil.getServletContext());
    }

    static ServletContext getServletContext() {
        WebContext webcx = WebContextFactory.get();
        if (webcx != null) {
            return webcx.getServletContext();
        }
        return servletContexts.get().getFirst();
    }

    static void pushServletContext(ServletContext context) {
        servletContexts.get().addFirst(context);
    }

    static void popServletContext() {
        servletContexts.get().removeFirst();
    }
}

