/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.JDBCConnection;
import it.businesslogic.ireport.connection.gui.MondrianConnectionEditor;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mondrian.olap.DriverManager;
import net.sf.jasperreports.engine.JRDataSource;

public class MondrianConnection
extends IReportConnection {
    public static final String CATALOG_URI = "CatalogUri";
    public static final String CONNECTION_NAME = "ConnectionName";
    private String name;
    private HashMap map = new HashMap();
    private String persistenceUnit;
    private mondrian.olap.Connection mondrianConnection = null;
    private int usedby = 0;

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return false;
    }

    public HashMap getProperties() {
        return this.map;
    }

    public void loadProperties(HashMap map) {
        this.map = map;
    }

    public JRDataSource getJRDataSource() {
        return null;
    }

    public void closeMondrianConnection() {
        try {
            if (this.getMondrianConnection() != null) {
                --this.usedby;
                if (this.usedby == 0) {
                    this.mondrianConnection.close();
                    this.mondrianConnection = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public mondrian.olap.Connection getMondrianConnection() throws Exception {
        if (this.mondrianConnection == null) {
            JDBCConnection con = this.getJDBCConnection();
            this.mondrianConnection = DriverManager.getConnection((String)("Provider=mondrian;JdbcDrivers=" + this.escapeProperty(con.getJDBCDriver()) + ";" + "Jdbc=" + this.escapeProperty(con.getUrl()) + ";" + "JdbcUser=" + this.escapeProperty(con.getUsername()) + ";" + "JdbcPassword=" + this.escapeProperty(con.getPassword()) + ";" + "Catalog=" + this.escapeProperty(this.getCatalogUri()) + ";"), null, (boolean)false);
        }
        ++this.usedby;
        return this.mondrianConnection;
    }

    public void setMondrianConnection(mondrian.olap.Connection mondrianConnection) {
        this.mondrianConnection = mondrianConnection;
    }

    public String getCatalogUri() {
        return (String)this.getProperties().get(CATALOG_URI);
    }

    public void setCatalogUri(String catalogUri) {
        this.getProperties().put(CATALOG_URI, catalogUri);
    }

    public String getConnectionName() {
        return (String)this.getProperties().get(CONNECTION_NAME);
    }

    public void setConnectionName(String connectionName) {
        this.getProperties().put(CONNECTION_NAME, connectionName);
    }

    private JDBCConnection getJDBCConnection() {
        String name = this.getConnectionName();
        Vector conns = MainFrame.getMainInstance().getConnections();
        for (int i = 0; i < conns.size(); ++i) {
            IReportConnection con = (IReportConnection)conns.elementAt(i);
            if (!(con instanceof JDBCConnection) || !con.getName().equals(name)) continue;
            return (JDBCConnection)con;
        }
        return null;
    }

    public String escapeProperty(String s) {
        if (s == null) {
            s = "";
        }
        s = Misc.string_replace("\"\"", "\"", s);
        return s;
    }

    public String getDescription() {
        return I18n.getString("connectionType.olap", "Mondrian OLAP connection");
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new MondrianConnectionEditor();
    }

    public void test() throws Exception {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Thread.currentThread().setContextClassLoader(MainFrame.getMainInstance().getReportClassLoader());
                    try {
                        MondrianConnection.this.getMondrianConnection();
                        MondrianConnection.this.closeMondrianConnection();
                        JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("messages.connectionDialog.connectionTestSuccessful", "Connection test successful!"), "", 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(MainFrame.getMainInstance(), ex.getMessage(), I18n.getString("message.title.error", "Error"), 0);
                        return;
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

