/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationCredentialsNotFoundException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.config.TestBusinessBean;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class InterceptMethodsBeanDefinitionDecoratorTests {
    private ClassPathXmlApplicationContext appContext;
    private TestBusinessBean target;

    @Before
    public void loadContext() {
        this.appContext = new ClassPathXmlApplicationContext("org/springframework/security/config/method-security.xml");
        this.target = (TestBusinessBean)this.appContext.getBean("target");
    }

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
        }
        SecurityContextHolder.clearContext();
    }

    @Test
    public void targetShouldAllowUnprotectedMethodInvocationWithNoContext() {
        this.target.unprotected();
    }

    @Test
    public void targetShouldPreventProtectedMethodInvocationWithNoContext() {
        try {
            this.target.doSomething();
            Assert.fail((String)"Expected AuthenticationCredentialsNotFoundException");
        }
        catch (AuthenticationCredentialsNotFoundException authenticationCredentialsNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void targetShouldAllowProtectedMethodInvocationWithCorrectRole() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_USER")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target.doSomething();
    }

    @Test
    public void targetShouldPreventProtectedMethodInvocationWithIncorrectRole() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SOMEOTHERROLE")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        try {
            this.target.doSomething();
            Assert.fail((String)"Expected AccessDeniedException");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }
}

