/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.ldap.authenticator;

import javax.naming.Name;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.MessageSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.ldap.AbstractLdapIntegrationTests;
import org.springframework.security.ldap.LdapUserSearch;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.ldap.authenticator.BindAuthenticator;
import org.springframework.security.providers.ldap.authenticator.MockUserSearch;

public class BindAuthenticatorTests
extends AbstractLdapIntegrationTests {
    private BindAuthenticator authenticator;
    private Authentication bob;

    public void onSetUp() {
        this.authenticator = new BindAuthenticator(this.getContextSource());
        this.authenticator.setMessageSource((MessageSource)new SpringSecurityMessageSource());
        this.bob = new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bobspassword");
    }

    @Test
    public void testAuthenticationWithCorrectPasswordSucceeds() {
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=people"});
        DirContextOperations user = this.authenticator.authenticate(this.bob);
        Assert.assertEquals((Object)"bob", (Object)user.getStringAttribute("uid"));
    }

    @Test
    public void testAuthenticationWithInvalidUserNameFails() {
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=people"});
        try {
            this.authenticator.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"nonexistentsuser", (Object)"password"));
            Assert.fail((String)"Shouldn't be able to bind with invalid username");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    @Test
    public void testAuthenticationWithUserSearch() throws Exception {
        DirContextAdapter ctx = new DirContextAdapter((Name)new DistinguishedName("uid=bob,ou=people"));
        this.authenticator.setUserSearch((LdapUserSearch)new MockUserSearch((DirContextOperations)ctx));
        this.authenticator.afterPropertiesSet();
        this.authenticator.authenticate(this.bob);
    }

    @Test
    public void testAuthenticationWithWrongPasswordFails() {
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=people"});
        try {
            this.authenticator.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"wrongpassword"));
            Assert.fail((String)"Shouldn't be able to bind with wrong password");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    @Test
    public void testUserDnPatternReturnsCorrectDn() {
        this.authenticator.setUserDnPatterns(new String[]{"cn={0},ou=people"});
        Assert.assertEquals((Object)"cn=Joe,ou=people", this.authenticator.getUserDns("Joe").get(0));
    }
}

