/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.runas;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.runas.RunAsUserToken;

public class RunAsUserTokenTests
extends TestCase {
    public RunAsUserTokenTests() {
    }

    public RunAsUserTokenTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(RunAsUserTokenTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAuthenticationSetting() {
        RunAsUserToken token = new RunAsUserToken("my_password", (Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, UsernamePasswordAuthenticationToken.class);
        RunAsUserTokenTests.assertTrue((boolean)token.isAuthenticated());
        token.setAuthenticated(false);
        RunAsUserTokenTests.assertTrue((!token.isAuthenticated() ? 1 : 0) != 0);
    }

    public void testGetters() {
        RunAsUserToken token = new RunAsUserToken("my_password", (Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, UsernamePasswordAuthenticationToken.class);
        RunAsUserTokenTests.assertEquals((Object)"Test", (Object)token.getPrincipal());
        RunAsUserTokenTests.assertEquals((Object)"Password", (Object)token.getCredentials());
        RunAsUserTokenTests.assertEquals((int)"my_password".hashCode(), (int)token.getKeyHash());
        RunAsUserTokenTests.assertEquals(UsernamePasswordAuthenticationToken.class, (Object)token.getOriginalAuthentication());
    }

    public void testNoArgConstructorDoesntExist() {
        Class<RunAsUserToken> clazz = RunAsUserToken.class;
        try {
            clazz.getDeclaredConstructor(null);
            RunAsUserTokenTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            RunAsUserTokenTests.assertTrue((boolean)true);
        }
    }

    public void testToString() {
        RunAsUserToken token = new RunAsUserToken("my_password", (Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, UsernamePasswordAuthenticationToken.class);
        RunAsUserTokenTests.assertTrue((token.toString().lastIndexOf("Original Class:") != -1 ? 1 : 0) != 0);
    }
}

