/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.hierarchicalroles;

import junit.framework.TestCase;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.hierarchicalroles.CycleInRoleHierarchyException;
import org.springframework.security.userdetails.hierarchicalroles.HierarchicalRolesTestHelper;
import org.springframework.security.userdetails.hierarchicalroles.RoleHierarchyImpl;

public class RoleHierarchyImplTests
extends TestCase {
    public RoleHierarchyImplTests() {
    }

    public RoleHierarchyImplTests(String testCaseName) {
        super(testCaseName);
    }

    public void testSimpleRoleHierarchy() {
        GrantedAuthority[] authorities0 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_0")};
        GrantedAuthority[] authorities1 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")};
        GrantedAuthority[] authorities2 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_B")};
        RoleHierarchyImpl roleHierarchyImpl = new RoleHierarchyImpl();
        roleHierarchyImpl.setHierarchy("ROLE_A > ROLE_B");
        RoleHierarchyImplTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(roleHierarchyImpl.getReachableGrantedAuthorities(authorities0), authorities0));
        RoleHierarchyImplTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(roleHierarchyImpl.getReachableGrantedAuthorities(authorities1), authorities2));
        RoleHierarchyImplTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(roleHierarchyImpl.getReachableGrantedAuthorities(authorities2), authorities2));
    }

    public void testTransitiveRoleHierarchies() {
        GrantedAuthority[] authorities1 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")};
        GrantedAuthority[] authorities2 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_B"), new GrantedAuthorityImpl("ROLE_C")};
        GrantedAuthority[] authorities3 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_B"), new GrantedAuthorityImpl("ROLE_C"), new GrantedAuthorityImpl("ROLE_D")};
        RoleHierarchyImpl roleHierarchyImpl = new RoleHierarchyImpl();
        roleHierarchyImpl.setHierarchy("ROLE_A > ROLE_B\nROLE_B > ROLE_C");
        RoleHierarchyImplTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(roleHierarchyImpl.getReachableGrantedAuthorities(authorities1), authorities2));
        roleHierarchyImpl.setHierarchy("ROLE_A > ROLE_B\nROLE_B > ROLE_C\nROLE_C > ROLE_D");
        RoleHierarchyImplTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(roleHierarchyImpl.getReachableGrantedAuthorities(authorities1), authorities3));
    }

    public void testComplexRoleHierarchy() {
        GrantedAuthority[] authoritiesInput1 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")};
        GrantedAuthority[] authoritiesOutput1 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_B"), new GrantedAuthorityImpl("ROLE_C"), new GrantedAuthorityImpl("ROLE_D")};
        GrantedAuthority[] authoritiesInput2 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_B")};
        GrantedAuthority[] authoritiesOutput2 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_B"), new GrantedAuthorityImpl("ROLE_D")};
        GrantedAuthority[] authoritiesInput3 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_C")};
        GrantedAuthority[] authoritiesOutput3 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_C"), new GrantedAuthorityImpl("ROLE_D")};
        GrantedAuthority[] authoritiesInput4 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_D")};
        GrantedAuthority[] authoritiesOutput4 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_D")};
        RoleHierarchyImpl roleHierarchyImpl = new RoleHierarchyImpl();
        roleHierarchyImpl.setHierarchy("ROLE_A > ROLE_B\nROLE_A > ROLE_C\nROLE_C > ROLE_D\nROLE_B > ROLE_D");
        RoleHierarchyImplTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(roleHierarchyImpl.getReachableGrantedAuthorities(authoritiesInput1), authoritiesOutput1));
        RoleHierarchyImplTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(roleHierarchyImpl.getReachableGrantedAuthorities(authoritiesInput2), authoritiesOutput2));
        RoleHierarchyImplTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(roleHierarchyImpl.getReachableGrantedAuthorities(authoritiesInput3), authoritiesOutput3));
        RoleHierarchyImplTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(roleHierarchyImpl.getReachableGrantedAuthorities(authoritiesInput4), authoritiesOutput4));
    }

    public void testCyclesInRoleHierarchy() {
        RoleHierarchyImpl roleHierarchyImpl = new RoleHierarchyImpl();
        try {
            roleHierarchyImpl.setHierarchy("ROLE_A > ROLE_A");
            RoleHierarchyImplTests.fail((String)"Cycle in role hierarchy was not detected!");
        }
        catch (CycleInRoleHierarchyException e) {
            // empty catch block
        }
        try {
            roleHierarchyImpl.setHierarchy("ROLE_A > ROLE_B\nROLE_B > ROLE_A");
            RoleHierarchyImplTests.fail((String)"Cycle in role hierarchy was not detected!");
        }
        catch (CycleInRoleHierarchyException e) {
            // empty catch block
        }
        try {
            roleHierarchyImpl.setHierarchy("ROLE_A > ROLE_B\nROLE_B > ROLE_C\nROLE_C > ROLE_A");
            RoleHierarchyImplTests.fail((String)"Cycle in role hierarchy was not detected!");
        }
        catch (CycleInRoleHierarchyException e) {
            // empty catch block
        }
        try {
            roleHierarchyImpl.setHierarchy("ROLE_A > ROLE_B\nROLE_B > ROLE_C\nROLE_C > ROLE_E\nROLE_E > ROLE_D\nROLE_D > ROLE_B");
            RoleHierarchyImplTests.fail((String)"Cycle in role hierarchy was not detected!");
        }
        catch (CycleInRoleHierarchyException cycleInRoleHierarchyException) {
            // empty catch block
        }
    }

    public void testNoCyclesInRoleHierarchy() {
        RoleHierarchyImpl roleHierarchyImpl = new RoleHierarchyImpl();
        try {
            roleHierarchyImpl.setHierarchy("ROLE_A > ROLE_B\nROLE_A > ROLE_C\nROLE_C > ROLE_D\nROLE_B > ROLE_D");
        }
        catch (CycleInRoleHierarchyException e) {
            RoleHierarchyImplTests.fail((String)"A cycle in role hierarchy was incorrectly detected!");
        }
    }
}

