/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.hierarchicalroles;

import junit.framework.TestCase;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.hierarchicalroles.HierarchicalRolesTestHelper;

public class TestHelperTests
extends TestCase {
    public TestHelperTests() {
    }

    public TestHelperTests(String testCaseName) {
        super(testCaseName);
    }

    public void testContainTheSameGrantedAuthorities() {
        GrantedAuthority[] authorities1 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_B")};
        GrantedAuthority[] authorities2 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_B"), new GrantedAuthorityImpl("ROLE_A")};
        GrantedAuthority[] authorities3 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_C")};
        GrantedAuthority[] authorities4 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")};
        GrantedAuthority[] authorities5 = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_A")};
        TestHelperTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(null, null));
        TestHelperTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(authorities1, authorities1));
        TestHelperTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(authorities1, authorities2));
        TestHelperTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(authorities2, authorities1));
        TestHelperTests.assertFalse((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(null, authorities1));
        TestHelperTests.assertFalse((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(authorities1, null));
        TestHelperTests.assertFalse((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(authorities1, authorities3));
        TestHelperTests.assertFalse((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(authorities3, authorities1));
        TestHelperTests.assertFalse((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(authorities1, authorities4));
        TestHelperTests.assertFalse((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(authorities4, authorities1));
        TestHelperTests.assertFalse((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(authorities4, authorities5));
    }
}

