/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.vote;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.JoinPoint;
import org.springframework.security.Authentication;
import org.springframework.security.AuthorizationServiceException;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.MockAclManager;
import org.springframework.security.SecurityConfig;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.AclManager;
import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.MockAclObjectIdentity;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.util.SimpleMethodInvocation;
import org.springframework.security.vote.BasicAclEntryVoter;
import org.springframework.security.vote.SomeDomainObject;
import org.springframework.security.vote.SomeDomainObjectManager;

public class BasicAclEntryVoterTests
extends TestCase {
    public BasicAclEntryVoterTests() {
    }

    public BasicAclEntryVoterTests(String arg0) {
        super(arg0);
    }

    private MethodInvocation getMethodInvocation(SomeDomainObject domainObject) throws Exception {
        Class<SomeDomainObjectManager> clazz = SomeDomainObjectManager.class;
        Method method = clazz.getMethod("someServiceMethod", SomeDomainObject.class);
        return new SimpleMethodInvocation((Object)new SomeDomainObjectManager(), method, new Object[]{domainObject});
    }

    public static void main(String[] args) {
        TestRunner.run(BasicAclEntryVoterTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testNormalOperation() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject, "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        BasicAclEntryVoterTests.assertEquals((Object)aclManager, (Object)voter.getAclManager());
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        BasicAclEntryVoterTests.assertEquals((String)"FOO_ADMIN_OR_WRITE_ACCESS", (String)voter.getProcessConfigAttribute());
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        BasicAclEntryVoterTests.assertEquals((int)2, (int)voter.getRequirePermission().length);
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        BasicAclEntryVoterTests.assertEquals(SomeDomainObject.class, (Object)voter.getProcessDomainObjectClass());
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("FOO_ADMIN_OR_WRITE_ACCESS");
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)1, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", null), (Object)mi, attr));
    }

    public void testOnlySupportsMethodInvocationAndJoinPoint() {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        BasicAclEntryVoterTests.assertTrue((boolean)voter.supports(MethodInvocation.class));
        BasicAclEntryVoterTests.assertTrue((boolean)voter.supports(JoinPoint.class));
        BasicAclEntryVoterTests.assertFalse((boolean)voter.supports(String.class));
    }

    public void testStartupRejectsMissingAclManager() throws Exception {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        try {
            voter.afterPropertiesSet();
            BasicAclEntryVoterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testStartupRejectsMissingProcessConfigAttribute() throws Exception {
        MockAclManager aclManager = new MockAclManager("domain1", "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        try {
            voter.afterPropertiesSet();
            BasicAclEntryVoterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testStartupRejectsMissingProcessDomainObjectClass() throws Exception {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        try {
            voter.setProcessDomainObjectClass(null);
            BasicAclEntryVoterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testStartupRejectsMissingRequirePermission() throws Exception {
        MockAclManager aclManager = new MockAclManager("domain1", "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        try {
            voter.afterPropertiesSet();
            BasicAclEntryVoterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testSupportsConfigAttribute() {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setProcessConfigAttribute("foobar");
        BasicAclEntryVoterTests.assertTrue((boolean)voter.supports((ConfigAttribute)new SecurityConfig("foobar")));
    }

    public void testVoterAbstainsIfDomainObjectIsNull() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject, "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("A_DIFFERENT_ATTRIBUTE");
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)0, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", null), (Object)mi, attr));
    }

    public void testVoterAbstainsIfNotMatchingConfigAttribute() throws Exception {
        SomeDomainObject domainObject = null;
        MockAclManager aclManager = new MockAclManager(domainObject, "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("FOO_ADMIN_OR_WRITE_ACCESS");
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)0, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", null), (Object)mi, attr));
    }

    public void testVoterCanDenyAccessBasedOnInternalMethodOfDomainObject() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject.getParent(), "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        voter.setInternalMethod("getParent");
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("FOO_ADMIN_OR_WRITE_ACCESS");
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)-1, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", null), (Object)mi, attr));
    }

    public void testVoterCanDenyAccessIfPrincipalHasNoPermissionsAtAllToDomainObject() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject, "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        voter.setInternalMethod("getParent");
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("FOO_ADMIN_OR_WRITE_ACCESS");
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)-1, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"scott", null), (Object)mi, attr));
    }

    public void testVoterCanGrantAccessBasedOnInternalMethodOfDomainObject() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject.getParent(), "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        voter.setInternalMethod("getParent");
        BasicAclEntryVoterTests.assertEquals((String)"getParent", (String)voter.getInternalMethod());
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("FOO_ADMIN_OR_WRITE_ACCESS");
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)1, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", null), (Object)mi, attr));
    }

    public void testVoterThrowsExceptionIfInvalidInternalMethodOfDomainObject() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject.getParent(), "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        voter.setInternalMethod("getNonExistentParentName");
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("FOO_ADMIN_OR_WRITE_ACCESS");
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        try {
            voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", null), (Object)mi, attr);
            BasicAclEntryVoterTests.fail((String)"Should have thrown AuthorizationServiceException");
        }
        catch (AuthorizationServiceException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testVoterThrowsExceptionIfProcessDomainObjectNotFound() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject.getParent(), "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(SomeDomainObject.class);
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("FOO_ADMIN_OR_WRITE_ACCESS");
        Class<String> clazz = String.class;
        Method method = clazz.getMethod("toString", new Class[0]);
        SimpleMethodInvocation mi = new SimpleMethodInvocation((Object)new String(), method, new Object[]{domainObject});
        try {
            voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", null), (Object)mi, attr);
            BasicAclEntryVoterTests.fail((String)"Should have thrown AuthorizationServiceException");
        }
        catch (AuthorizationServiceException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testSetRequirePermissionFromString() {
        this.assertPermission("NOTHING", 0);
        this.assertPermission("ADMINISTRATION", SimpleAclEntry.ADMINISTRATION);
        this.assertPermission("READ", SimpleAclEntry.READ);
        this.assertPermission("WRITE", SimpleAclEntry.WRITE);
        this.assertPermission("CREATE", SimpleAclEntry.CREATE);
        this.assertPermission("DELETE", SimpleAclEntry.DELETE);
        this.assertPermission(new String[]{"WRITE", "CREATE"}, new int[]{SimpleAclEntry.WRITE, SimpleAclEntry.CREATE});
    }

    public void testSetRequirePermissionFromStringWrongValues() {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        try {
            voter.setRequirePermissionFromString(new String[]{"X"});
            BasicAclEntryVoterTests.fail((String)(IllegalArgumentException.class.getName() + " must have been thrown."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertPermission(String text, int value) {
        this.assertPermission(new String[]{text}, new int[]{value});
    }

    private void assertPermission(String[] text, int[] value) {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setRequirePermissionFromString(text);
        BasicAclEntryVoterTests.assertEquals((String)"Test incorreclty coded", (int)value.length, (int)text.length);
        BasicAclEntryVoterTests.assertEquals((int)value.length, (int)voter.getRequirePermission().length);
        for (int i = 0; i < value.length; ++i) {
            BasicAclEntryVoterTests.assertEquals((int)value[i], (int)voter.getRequirePermission()[i]);
        }
    }

    private class MockAclEntry
    implements AclEntry {
        private MockAclEntry() {
        }
    }
}

